/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshKeyPairFactory {
    private static Map pks;
    private static String defaultAlgorithm;
    private static Log log;
    static /* synthetic */ Class class$com$sshtools$j2ssh$configuration$SshAPIConfiguration;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$SshKeyPairFactory;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssKeyPair;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$rsa$SshRsaKeyPair;

    protected SshKeyPairFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultPublicKey() {
        return defaultAlgorithm;
    }

    public static List getSupportedKeys() {
        return new ArrayList(pks.keySet());
    }

    public static SshKeyPair newInstance(String string) throws AlgorithmNotSupportedException {
        try {
            SshKeyPair sshKeyPair = (SshKeyPair)((Class)pks.get(string)).newInstance();
            return sshKeyPair;
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(String.valueOf(String.valueOf(string)).concat(" is not supported!"));
        }
    }

    public static boolean supportsKey(String string) {
        return pks.containsKey(string);
    }

    public static SshPrivateKey decodePrivateKey(byte[] byArray) throws AlgorithmNotSupportedException, InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (SshKeyPairFactory.supportsKey(string)) {
                SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
                SshPrivateKey sshPrivateKey = sshKeyPair.decodePrivateKey(byArray);
                return sshPrivateKey;
            }
            throw new AlgorithmNotSupportedException(String.valueOf(String.valueOf(string)).concat(" is not supported"));
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException.getMessage());
        }
    }

    public static SshPublicKey decodePublicKey(byte[] byArray) throws AlgorithmNotSupportedException, InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (SshKeyPairFactory.supportsKey(string)) {
                SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
                SshPublicKey sshPublicKey = sshKeyPair.decodePublicKey(byArray);
                return sshPublicKey;
            }
            throw new AlgorithmNotSupportedException(String.valueOf(String.valueOf(string)).concat(" is not supported"));
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException.getMessage());
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object object;
        log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$transport$publickey$SshKeyPairFactory == null ? (class$com$sshtools$j2ssh$transport$publickey$SshKeyPairFactory = SshKeyPairFactory.class$("com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory")) : class$com$sshtools$j2ssh$transport$publickey$SshKeyPairFactory));
        pks = new HashMap();
        log.info((Object)"Loading public key algorithms");
        pks.put("ssh-dss", class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssKeyPair == null ? (class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssKeyPair = SshKeyPairFactory.class$("com.sshtools.j2ssh.transport.publickey.dsa.SshDssKeyPair")) : class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssKeyPair);
        pks.put("ssh-rsa", class$com$sshtools$j2ssh$transport$publickey$rsa$SshRsaKeyPair == null ? (class$com$sshtools$j2ssh$transport$publickey$rsa$SshRsaKeyPair = SshKeyPairFactory.class$("com.sshtools.j2ssh.transport.publickey.rsa.SshRsaKeyPair")) : class$com$sshtools$j2ssh$transport$publickey$rsa$SshRsaKeyPair);
        try {
            if (ConfigurationLoader.isConfigurationAvailable(class$com$sshtools$j2ssh$configuration$SshAPIConfiguration == null ? (class$com$sshtools$j2ssh$configuration$SshAPIConfiguration = SshKeyPairFactory.class$("com.sshtools.j2ssh.configuration.SshAPIConfiguration")) : class$com$sshtools$j2ssh$configuration$SshAPIConfiguration) && (object = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(class$com$sshtools$j2ssh$configuration$SshAPIConfiguration == null ? (class$com$sshtools$j2ssh$configuration$SshAPIConfiguration = SshKeyPairFactory.class$("com.sshtools.j2ssh.configuration.SshAPIConfiguration")) : class$com$sshtools$j2ssh$configuration$SshAPIConfiguration)) != null) {
                List list = object.getPublicKeyExtensions();
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ExtensionAlgorithm extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
                        String string = extensionAlgorithm.getAlgorithmName();
                        if (pks.containsKey(string)) {
                            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Standard public key ").append(string).append(" is being overidden by ").append(extensionAlgorithm.getImplementationClass()))));
                        } else {
                            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(extensionAlgorithm.getAlgorithmName()))).append(" public key is implemented by ").append(extensionAlgorithm.getImplementationClass()))));
                        }
                        try {
                            pks.put(extensionAlgorithm.getAlgorithmName(), ConfigurationLoader.getExtensionClass(extensionAlgorithm.getImplementationClass()));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            log.error((Object)"Could not locate ".concat(String.valueOf(String.valueOf(extensionAlgorithm.getImplementationClass()))));
                        }
                    }
                }
                defaultAlgorithm = object.getDefaultPublicKey();
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (defaultAlgorithm == null || !pks.containsKey(defaultAlgorithm)) {
            log.debug((Object)"The default public key is not set! using first in list");
            object = pks.keySet().iterator();
            defaultAlgorithm = (String)object.next();
        }
    }
}

