/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.Base64EncodedFileFormat;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.sshtools.j2ssh.util.Hash;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class SshtoolsPrivateKeyFormat
extends Base64EncodedFileFormat
implements SshPrivateKeyFormat {
    private static String BEGIN = "---- BEGIN SSHTOOLS ENCRYPTED PRIVATE KEY ----";
    private static String END = "---- END SSHTOOLS ENCRYPTED PRIVATE KEY ----";
    private int cookie = 1391688382;

    public SshtoolsPrivateKeyFormat(String string, String string2) {
        super(BEGIN, END);
        this.setHeaderValue("Subject", string);
        this.setHeaderValue("Comment", string2);
    }

    public SshtoolsPrivateKeyFormat() {
        super(BEGIN, END);
    }

    public String getFormatType() {
        return "SSHTools-PrivateKey-".concat(String.valueOf(String.valueOf(super.getFormatType())));
    }

    public boolean isPassphraseProtected(byte[] byArray) {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(this.getKeyBlob(byArray));
            String string = byteArrayReader.readString();
            if (string.equals("none")) {
                boolean bl = false;
                return bl;
            }
            if (string.equalsIgnoreCase("3des-cbc")) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] decryptKeyblob(byte[] byArray, String string) throws InvalidSshKeyException {
        try {
            byte[] byArray2 = this.getKeyBlob(byArray);
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray2);
            String string2 = byteArrayReader.readString();
            if (string2.equalsIgnoreCase("3des-cbc")) {
                byte[] byArray3 = this.makePassphraseKey(string);
                byte[] byArray4 = new byte[8];
                if (string2.equals("3DES-CBC")) {
                    byteArrayReader.read(byArray4);
                }
                byArray2 = byteArrayReader.readBinaryString();
                Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray3);
                SecretKey secretKey = SecretKeyFactory.getInstance("DESede").generateSecret(dESedeKeySpec);
                cipher.init(2, (Key)secretKey, new IvParameterSpec(byArray4, 0, cipher.getBlockSize()));
                ByteArrayReader byteArrayReader2 = new ByteArrayReader(cipher.doFinal(byArray2));
                if (byteArrayReader2.readInt() != (long)this.cookie) throw new InvalidSshKeyException("The host key is invalid, check the passphrase supplied");
                byArray2 = byteArrayReader2.readBinaryString();
                return byArray2;
            } else {
                byArray2 = byteArrayReader.readBinaryString();
            }
            return byArray2;
        }
        catch (Exception exception) {
            throw new InvalidSshKeyException("Failed to read host key");
        }
    }

    public byte[] encryptKeyblob(byte[] byArray, String string) {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            String string2 = "none";
            if (string != null && !string.trim().equals("")) {
                string2 = "3DES-CBC";
                byte[] byArray2 = this.makePassphraseKey(string);
                byte[] byArray3 = new byte[8];
                ConfigurationLoader.getRND().nextBytes(byArray3);
                Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray2);
                SecretKey secretKey = SecretKeyFactory.getInstance("DESede").generateSecret(dESedeKeySpec);
                cipher.init(1, (Key)secretKey, new IvParameterSpec(byArray3, 0, cipher.getBlockSize()));
                ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
                byteArrayWriter.writeString(string2);
                byteArrayWriter.write(byArray3);
                byteArrayWriter2.writeInt(this.cookie);
                byteArrayWriter2.writeBinaryString(byArray);
                byteArrayWriter.writeBinaryString(cipher.doFinal(byteArrayWriter2.toByteArray()));
                byte[] byArray4 = this.formatKey(byteArrayWriter.toByteArray());
                return byArray4;
            }
            byteArrayWriter.writeString(string2);
            byteArrayWriter.writeBinaryString(byArray);
            byte[] byArray5 = this.formatKey(byteArrayWriter.toByteArray());
            return byArray5;
        }
        catch (Exception exception) {
            byte[] byArray6 = null;
            return byArray6;
        }
    }

    public boolean supportsAlgorithm(String string) {
        return true;
    }

    private byte[] makePassphraseKey(String string) {
        try {
            Hash hash = new Hash("MD5");
            hash.putBytes(string.getBytes());
            byte[] byArray = hash.doFinal();
            hash.reset();
            hash.putBytes(string.getBytes());
            hash.putBytes(byArray);
            byte[] byArray2 = hash.doFinal();
            byte[] byArray3 = new byte[32];
            System.arraycopy(byArray, 0, byArray3, 0, 16);
            System.arraycopy(byArray2, 0, byArray3, 16, 16);
            byte[] byArray4 = byArray3;
            return byArray4;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            byte[] byArray = null;
            return byArray;
        }
    }
}

