/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.dsa;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.util.SimpleASNWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshDssPublicKey
extends SshPublicKey {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPublicKey == null ? (class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPublicKey = SshDssPublicKey.class$("com.sshtools.j2ssh.transport.publickey.dsa.SshDssPublicKey")) : class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPublicKey));
    private DSAPublicKey pubkey;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPublicKey;

    public SshDssPublicKey(DSAPublicKey dSAPublicKey) {
        this.pubkey = dSAPublicKey;
    }

    public SshDssPublicKey(byte[] byArray) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                throw new InvalidSshKeyException();
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            BigInteger bigInteger4 = byteArrayReader.readBigInteger();
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            this.pubkey = (DSAPublicKey)keyFactory.generatePublic(dSAPublicKeySpec);
        }
        catch (Exception exception) {
            throw new InvalidSshKeyException();
        }
    }

    public String getAlgorithmName() {
        return "ssh-dss";
    }

    public int getBitLength() {
        return this.pubkey.getY().bitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithmName());
            byteArrayWriter.writeBigInteger(this.pubkey.getParams().getP());
            byteArrayWriter.writeBigInteger(this.pubkey.getParams().getQ());
            byteArrayWriter.writeBigInteger(this.pubkey.getParams().getG());
            byteArrayWriter.writeBigInteger(this.pubkey.getY());
            byte[] byArray = byteArrayWriter.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            byte[] byArray = null;
            return byArray;
        }
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws InvalidSshKeySignatureException {
        try {
            Object object;
            Object object2;
            Closeable closeable;
            log.debug((Object)"Verifying host key signature");
            log.debug((Object)"Signature length is ".concat(String.valueOf(String.valueOf(String.valueOf(byArray.length)))));
            if (byArray.length != 40) {
                closeable = new ByteArrayReader(byArray);
                object2 = ((ByteArrayReader)closeable).readBinaryString();
                object = new String((byte[])object2);
                log.debug((Object)"Header is ".concat(String.valueOf(String.valueOf(object))));
                if (!((String)object).equals("ssh-dss")) {
                    throw new InvalidSshKeySignatureException();
                }
                byArray = ((ByteArrayReader)closeable).readBinaryString();
                log.debug((Object)"Read signature from blob: ".concat(String.valueOf(String.valueOf(new String(byArray)))));
            }
            closeable = new ByteArrayOutputStream();
            object2 = new ByteArrayOutputStream();
            object = new SimpleASNWriter();
            ((SimpleASNWriter)object).writeByte(2);
            if ((byArray[0] & 0x80) == 128 && byArray[0] != 0) {
                ((ByteArrayOutputStream)closeable).write(0);
                ((ByteArrayOutputStream)closeable).write(byArray, 0, 20);
            } else {
                ((ByteArrayOutputStream)closeable).write(byArray, 0, 20);
            }
            ((SimpleASNWriter)object).writeData(((ByteArrayOutputStream)closeable).toByteArray());
            ((SimpleASNWriter)object).writeByte(2);
            if ((byArray[20] & 0x80) == 128 && byArray[20] != 0) {
                ((ByteArrayOutputStream)object2).write(0);
                ((ByteArrayOutputStream)object2).write(byArray, 20, 20);
            } else {
                ((ByteArrayOutputStream)object2).write(byArray, 20, 20);
            }
            ((SimpleASNWriter)object).writeData(((ByteArrayOutputStream)object2).toByteArray());
            SimpleASNWriter simpleASNWriter = new SimpleASNWriter();
            simpleASNWriter.writeByte(48);
            simpleASNWriter.writeData(((SimpleASNWriter)object).toByteArray());
            byte[] byArray3 = simpleASNWriter.toByteArray();
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(this.pubkey);
            signature.update(byArray2);
            boolean bl = signature.verify(byArray3);
            return bl;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidSshKeySignatureException();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidSshKeySignatureException();
        }
        catch (IOException iOException) {
            throw new InvalidSshKeySignatureException();
        }
        catch (SignatureException signatureException) {
            throw new InvalidSshKeySignatureException();
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

