/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicClassLoader
extends ClassLoader {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$util$DynamicClassLoader == null ? (class$com$sshtools$j2ssh$util$DynamicClassLoader = DynamicClassLoader.class$("com.sshtools.j2ssh.util.DynamicClassLoader")) : class$com$sshtools$j2ssh$util$DynamicClassLoader));
    private static int generationCounter = 0;
    private Hashtable cache;
    private List classpath = new Vector();
    private int generation;
    private ClassLoader parent;
    static /* synthetic */ Class class$com$sshtools$j2ssh$util$DynamicClassLoader;

    public DynamicClassLoader(ClassLoader classLoader, List list) throws IllegalArgumentException {
        this.parent = classLoader;
        this.cache = new Hashtable();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            File file = null;
            if (e instanceof String) {
                file = new File((String)e);
            } else if (e instanceof File) {
                file = (File)e;
            } else {
                throw new IllegalArgumentException("Entries in classpath must be either a String or File object");
            }
            if (!file.exists()) {
                throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Classpath ").append(file.getAbsolutePath()).append(" doesn't exist!"))));
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException("Don't have read access for file ".concat(String.valueOf(String.valueOf(file.getAbsolutePath()))));
            }
            if (!file.isDirectory() && !this.isJarArchive(file)) {
                throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(file.getAbsolutePath()))).append(" is not a directory or jar file").append(" or if it's a jar file then it is corrupted."))));
            }
            this.classpath.add(file);
        }
        this.generation = generationCounter++;
    }

    public URL getResource(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            return uRL;
        }
        Iterator iterator = this.classpath.iterator();
        while (iterator.hasNext()) {
            String string2;
            File file;
            File file2 = (File)iterator.next();
            if (!file2.isDirectory() || !(file = new File(file2, string2 = string.replace('/', File.separatorChar))).exists()) continue;
            try {
                URL uRL2 = new URL("file://".concat(String.valueOf(String.valueOf(file.getAbsolutePath()))));
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                URL uRL3 = null;
                return uRL3;
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream;
        block1: {
            File file;
            inputStream = ClassLoader.getSystemResourceAsStream(string);
            if (inputStream != null) break block1;
            Iterator iterator = this.classpath.iterator();
            while (iterator.hasNext() && (inputStream = (file = (File)iterator.next()).isDirectory() ? this.loadResourceFromDirectory(file, string) : this.loadResourceFromZipfile(file, string)) == null) {
            }
        }
        return inputStream;
    }

    public DynamicClassLoader reinstantiate() {
        return new DynamicClassLoader(this.parent, this.classpath);
    }

    public synchronized boolean shouldReload(String string) {
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry == null) {
            return false;
        }
        if (classCacheEntry.isSystemClass()) {
            return false;
        }
        boolean bl = classCacheEntry.origin.lastModified() != classCacheEntry.lastModified;
        return bl;
    }

    public synchronized boolean shouldReload() {
        Enumeration enumeration = this.cache.elements();
        while (enumeration.hasMoreElements()) {
            ClassCacheEntry classCacheEntry = (ClassCacheEntry)enumeration.nextElement();
            if (classCacheEntry.isSystemClass()) continue;
            long l = classCacheEntry.origin.lastModified();
            if (l == (long)0) {
                return true;
            }
            if (l == classCacheEntry.lastModified) continue;
            return true;
        }
        return false;
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry != null) {
            clazz = classCacheEntry.loadedClass;
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (!this.securityAllowsClass(string)) {
            return this.loadSystemClass(string, bl);
        }
        try {
            clazz = this.loadSystemClass(string, bl);
            if (clazz != null) {
                if (bl) {
                    this.resolveClass(clazz);
                }
                Class<?> clazz2 = clazz;
                return clazz2;
            }
        }
        catch (Exception exception) {
            clazz = null;
        }
        Iterator iterator = this.classpath.iterator();
        ClassCacheEntry classCacheEntry2 = new ClassCacheEntry();
        while (iterator.hasNext()) {
            byte[] byArray;
            File file = (File)iterator.next();
            try {
                byArray = file.isDirectory() ? this.loadClassFromDirectory(file, string, classCacheEntry2) : this.loadClassFromZipfile(file, string, classCacheEntry2);
            }
            catch (IOException iOException) {
                byArray = null;
            }
            if (byArray == null) continue;
            classCacheEntry2.loadedClass = clazz = this.defineClass(string, byArray, 0, byArray.length);
            classCacheEntry2.lastModified = classCacheEntry2.origin.lastModified();
            this.cache.put(string, classCacheEntry2);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isJarArchive(File file) {
        boolean bl = true;
        ZipFile zipFile = null;
        zipFile = new ZipFile(file);
        Object var6_4 = null;
        if (zipFile == null) return bl;
        try {
            zipFile.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
        {
            catch (ZipException zipException) {
                bl = false;
                Object var6_5 = null;
                if (zipFile == null) return bl;
                try {
                    zipFile.close();
                    return bl;
                }
                catch (IOException iOException) {}
                return bl;
            }
            catch (IOException iOException) {
                bl = false;
                Object var6_6 = null;
                if (zipFile == null) return bl;
                try {
                    zipFile.close();
                    return bl;
                }
                catch (IOException iOException2) {}
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (zipFile == null) throw throwable;
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private byte[] loadBytesFromStream(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n > 0 && (n2 = inputStream.read(byArray, n3, n)) != -1) {
            n3 += n2;
            n -= n2;
        }
        return byArray;
    }

    private byte[] loadClassFromDirectory(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        File file2;
        String string2 = String.valueOf(String.valueOf(string.replace('.', File.separatorChar))).concat(".class");
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            int n = 1;
            while (!Character.isJavaIdentifierStart(string2.charAt(n++))) {
            }
            string2 = string2.substring(n);
        }
        if ((file2 = new File(file, string2)).exists()) {
            byte[] byArray;
            classCacheEntry.origin = file2;
            FileInputStream fileInputStream = new FileInputStream(file2);
            try {
                byArray = this.loadBytesFromStream(fileInputStream, (int)file2.length());
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            ((InputStream)fileInputStream).close();
            return byArray;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadClassFromZipfile(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        byte[] byArray;
        ZipFile zipFile;
        block4: {
            byte[] byArray2;
            block3: {
                String string2 = String.valueOf(String.valueOf(string.replace('.', '/'))).concat(".class");
                zipFile = new ZipFile(file);
                try {
                    ZipEntry zipEntry = zipFile.getEntry(string2);
                    if (zipEntry != null) {
                        classCacheEntry.origin = file;
                        byArray2 = this.loadBytesFromStream(zipFile.getInputStream(zipEntry), (int)zipEntry.getSize());
                        Object var9_9 = null;
                        break block3;
                    }
                    byArray = null;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    zipFile.close();
                    throw throwable;
                }
            }
            zipFile.close();
            return byArray2;
        }
        Object var9_10 = null;
        zipFile.close();
        return byArray;
    }

    private InputStream loadResourceFromDirectory(File file, String string) {
        String string2 = string.replace('/', File.separatorChar);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                return fileInputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                InputStream inputStream = null;
                return inputStream;
            }
        }
        return null;
    }

    private InputStream loadResourceFromZipfile(File file, String string) {
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) {
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                return inputStream;
            }
            InputStream inputStream = null;
            return inputStream;
        }
        catch (IOException iOException) {
            InputStream inputStream = null;
            return inputStream;
        }
    }

    private Class loadSystemClass(String string, boolean bl) throws ClassNotFoundException, NoClassDefFoundError {
        Class<?> clazz = this.parent.loadClass(string);
        if (bl) {
            this.resolveClass(clazz);
        }
        ClassCacheEntry classCacheEntry = new ClassCacheEntry();
        classCacheEntry.origin = null;
        classCacheEntry.loadedClass = clazz;
        classCacheEntry.lastModified = Long.MAX_VALUE;
        this.cache.put(string, classCacheEntry);
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private boolean securityAllowsClass(String string) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                boolean bl = true;
                return bl;
            }
            int n = string.lastIndexOf(46);
            securityManager.checkPackageDefinition(n > -1 ? string.substring(0, n) : "");
            boolean bl = true;
            return bl;
        }
        catch (SecurityException securityException) {
            boolean bl = false;
            return bl;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File origin;
        long lastModified;

        private ClassCacheEntry() {
        }

        public boolean isSystemClass() {
            return this.origin == null;
        }
    }
}

