/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mail;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.mail.MailServiceMBean;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MailService
extends ServiceMBeanSupport
implements MailServiceMBean {
    public static final String JNDI_NAME = "java:/Mail";
    private String user;
    private String password;
    private String jndiName = "java:/Mail";
    private Element config;
    ObjectName mMail;
    Properties ourProps = null;
    static /* synthetic */ Class class$javax$mail$Session;
    static /* synthetic */ Class class$org$jboss$naming$NonSerializableFactory;

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected String getPassword() {
        return this.password;
    }

    public Element getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Element element) {
        this.config = element;
    }

    public void setJNDIName(String name) {
        this.jndiName = name;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public String getStoreProtocol() {
        if (this.ourProps != null) {
            return this.ourProps.getProperty("mail.store.protocol");
        }
        return null;
    }

    public String getTransportProtocol() {
        if (this.ourProps != null) {
            return this.ourProps.getProperty("mail.transport.protocol");
        }
        return null;
    }

    public String getDefaultSender() {
        if (this.ourProps != null) {
            return this.ourProps.getProperty("mail.from");
        }
        return null;
    }

    public String getSMTPServerHost() {
        if (this.ourProps != null) {
            return this.ourProps.getProperty("mail.smtp.host");
        }
        return null;
    }

    public String getPOP3SererHost() {
        if (this.ourProps != null) {
            return this.ourProps.getProperty("mail.pop3.host");
        }
        return null;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? MailServiceMBean.OBJECT_NAME : name;
    }

    protected void startService() throws Exception {
        final PasswordAuthentication pa = new PasswordAuthentication(this.getUser(), this.getPassword());
        Authenticator a = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return pa;
            }
        };
        Properties props = this.getProperties();
        Session session = Session.getInstance((Properties)props, (Authenticator)a);
        this.bind(session);
        this.ourProps = props;
    }

    protected Properties getProperties() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        Properties props = new Properties();
        if (this.config == null) {
            this.log.warn((Object)"No configuration specified; using empty properties map");
            return props;
        }
        NodeList list = this.config.getElementsByTagName("property");
        int len = list.getLength();
        block4: for (int i = 0; i < len; ++i) {
            Node node = list.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element child = (Element)node;
                    if (!child.hasAttribute("name")) {
                        this.log.warn((Object)("Ignoring invalid element; missing 'name' attribute: " + child));
                        continue block4;
                    }
                    String name = child.getAttribute("name");
                    if (!child.hasAttribute("value")) {
                        this.log.warn((Object)("Ignoring invalid element; missing 'value' attribute: " + child));
                        continue block4;
                    }
                    String value = child.getAttribute("value");
                    if (debug) {
                        this.log.debug((Object)("setting property " + name + "=" + value));
                    }
                    props.setProperty(name, value);
                    continue block4;
                }
                case 8: {
                    continue block4;
                }
                default: {
                    this.log.debug((Object)("ignoring unsupported node type: " + node));
                }
            }
        }
        if (debug) {
            this.log.debug((Object)("Using properties: " + props));
        }
        return props;
    }

    protected void stopService() throws Exception {
        this.unbind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(Session session) throws NamingException {
        String bindName = this.getJNDIName();
        NonSerializableFactory.bind((String)bindName, (Object)session);
        Context ctx = new InitialContext();
        try {
            Name n = ctx.getNameParser("").parse(bindName);
            while (n.size() > 1) {
                String ctxName = n.get(0);
                try {
                    ctx = (Context)ctx.lookup(ctxName);
                }
                catch (NameNotFoundException e) {
                    ctx = ctx.createSubcontext(ctxName);
                }
                n = n.getSuffix(1);
            }
            StringRefAddr addr = new StringRefAddr("nns", bindName);
            Reference ref = new Reference((class$javax$mail$Session == null ? (class$javax$mail$Session = MailService.class$("javax.mail.Session")) : class$javax$mail$Session).getName(), addr, (class$org$jboss$naming$NonSerializableFactory == null ? (class$org$jboss$naming$NonSerializableFactory = MailService.class$("org.jboss.naming.NonSerializableFactory")) : class$org$jboss$naming$NonSerializableFactory).getName(), null);
            ctx.bind(n.get(0), (Object)ref);
        }
        finally {
            ctx.close();
        }
        this.log.info((Object)("Mail Service bound to " + bindName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind() throws NamingException {
        String bindName = this.getJNDIName();
        if (bindName != null) {
            InitialContext ctx = new InitialContext();
            try {
                ctx.unbind(bindName);
            }
            finally {
                ctx.close();
            }
            NonSerializableFactory.unbind((String)bindName);
            this.log.info((Object)("Mail service '" + this.getJNDIName() + "' removed from JNDI"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

