/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dom4j.Document;
import org.dom4j.Element;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EjbPortComponentMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.webservice.AxisService;
import org.jboss.webservice.AxisServiceMBean;
import org.jboss.webservice.PortComponentInfo;
import org.jboss.webservice.ServiceDeployerMBean;
import org.jboss.webservice.WSDLFilePublisher;
import org.jboss.webservice.metadata.PortComponentMetaData;
import org.jboss.webservice.metadata.WebserviceDescriptionMetaData;
import org.jboss.webservice.metadata.WebservicesFactory;
import org.jboss.webservice.metadata.WebservicesMetaData;
import org.jboss.xml.binding.ObjectModelFactory;
import org.jboss.xml.binding.Unmarshaller;

public abstract class ServiceDeployer
extends ServiceMBeanSupport
implements ServiceDeployerMBean,
NotificationListener {
    private final Logger log = Logger.getLogger((Class)ServiceDeployer.class);
    public static final String INIT_PARAM_WEBSERVICE_ID = "webserviceID";
    public static final String WEBSERVICE_CONTEXT_ROOT = "webservice-context-root";
    protected Map webservicesMap = new HashMap();
    static /* synthetic */ Class class$org$jboss$webservice$PortComponentInfo;
    static /* synthetic */ Class class$java$lang$String;

    protected void startService() throws Exception {
    }

    protected void stopService() {
    }

    public void handleNotification(Notification notification, Object handback) {
        DeploymentInfo di = (DeploymentInfo)notification.getUserData();
        if (this.getWebservicesDescriptor(di) == null) {
            return;
        }
        String moduleName = di.shortName;
        try {
            if (notification.getType().equals("org.jboss.deployment.SubDeployer.init")) {
                this.initWebservice(di);
            } else if (notification.getType().equals("org.jboss.deployment.SubDeployer.create")) {
                this.createWebservice(di);
            } else if (notification.getType().equals("org.jboss.deployment.SubDeployer.start")) {
                this.startWebservice(di);
            }
        }
        catch (Throwable e) {
            this.handleStartupException(moduleName, e);
        }
        try {
            if (notification.getType().equals("org.jboss.deployment.SubDeployer.stop")) {
                this.stopWebservice(di);
            } else if (notification.getType().equals("org.jboss.deployment.SubDeployer.destroy")) {
                this.destroyWebservice(di);
            }
        }
        catch (Throwable e) {
            this.handleShutdownException(moduleName, e);
        }
    }

    protected void initWebservice(DeploymentInfo di) throws DeploymentException {
    }

    protected void createWebservice(DeploymentInfo di) throws DeploymentException {
        URL url = this.getWebservicesDescriptor(di);
        if (url != null) {
            WebservicesMetaData wsMetaData = this.parseWebservicesXML(di, url);
            this.webservicesMap.put(di.url, wsMetaData);
        }
    }

    protected abstract URL getWebservicesDescriptor(DeploymentInfo var1);

    protected void startWebservice(DeploymentInfo di) throws DeploymentException {
        WebservicesMetaData webservices = (WebservicesMetaData)this.webservicesMap.get(di.url);
        if (webservices != null) {
            ServiceLocationResolver locationResolver = new ServiceLocationResolver(di);
            WebserviceDescriptionMetaData[] wsdArray = webservices.getWebserviceDescriptions();
            for (int i = 0; i < wsdArray.length; ++i) {
                String wsdlPublishLocation;
                WebserviceDescriptionMetaData wsdMetaData = wsdArray[i];
                wsdMetaData.updateServiceAddress(locationResolver);
                String wsdName = wsdMetaData.getWebserviceDescriptionName();
                if (di.metaData instanceof ApplicationMetaData) {
                    ApplicationMetaData applMetaData = (ApplicationMetaData)di.metaData;
                    wsdlPublishLocation = applMetaData.getWsdlPublishLocationByName(wsdName);
                    wsdMetaData.setWsdlPublishLocation(wsdlPublishLocation);
                }
                if (!(di.metaData instanceof WebMetaData)) continue;
                WebMetaData webMetaData = (WebMetaData)di.metaData;
                wsdlPublishLocation = webMetaData.getWsdlPublishLocationByName(wsdName);
                wsdMetaData.setWsdlPublishLocation(wsdlPublishLocation);
            }
            WSDLFilePublisher wsdlfp = new WSDLFilePublisher(di);
            wsdlfp.publishWsdlFile(webservices);
            this.deployWebservices(di, webservices);
        }
    }

    protected void stopWebservice(DeploymentInfo di) {
        WebservicesMetaData webservices = (WebservicesMetaData)this.webservicesMap.get(di.url);
        if (webservices != null) {
            this.undeployWebservices(di, webservices);
            WSDLFilePublisher wsdlfp = new WSDLFilePublisher(di);
            wsdlfp.unpublishWsdlFile();
        }
    }

    protected void destroyWebservice(DeploymentInfo di) {
        this.webservicesMap.remove(di.url);
    }

    protected void handleStartupException(String moduleName, Throwable th) {
        this.log.error((Object)("Cannot startup webservice for: " + moduleName), th);
    }

    protected void handleShutdownException(String moduleName, Throwable th) {
        this.log.error((Object)("Cannot shutdown webservice for: " + moduleName), th);
    }

    protected void registerNotificationListener(ObjectName serviceName) throws InstanceNotFoundException {
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("org.jboss.deployment.SubDeployer.init");
        filter.enableType("org.jboss.deployment.SubDeployer.create");
        filter.enableType("org.jboss.deployment.SubDeployer.start");
        filter.enableType("org.jboss.deployment.SubDeployer.stop");
        filter.enableType("org.jboss.deployment.SubDeployer.destroy");
        this.server.addNotificationListener(serviceName, this, (NotificationFilter)filter, null);
    }

    protected void unregisterNotificationListener(ObjectName serviceName) {
        try {
            this.server.removeNotificationListener(serviceName, this);
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot remove notification listener: " + e.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebservicesMetaData parseWebservicesXML(DeploymentInfo di, URL webservicesURL) throws DeploymentException {
        WebservicesMetaData webservices = null;
        try {
            InputStream is = webservicesURL.openStream();
            try {
                Unmarshaller unmarshaller = new Unmarshaller();
                WebservicesFactory factory = new WebservicesFactory(di.localCl);
                webservices = (WebservicesMetaData)unmarshaller.unmarshal(is, (ObjectModelFactory)factory, null);
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Cannot obtain webservices meta data", (Throwable)e);
        }
        return webservices;
    }

    protected void deployWebservices(DeploymentInfo di, WebservicesMetaData webservices) throws DeploymentException {
        try {
            WebserviceDescriptionMetaData[] wsdArr = webservices.getWebserviceDescriptions();
            for (int i = 0; i < wsdArr.length; ++i) {
                WebserviceDescriptionMetaData wsd = wsdArr[i];
                PortComponentMetaData[] pcArr = wsd.getPortComponents();
                for (int j = 0; j < pcArr.length; ++j) {
                    PortComponentMetaData pcMetaData = pcArr[j];
                    PortComponentInfo pcInfo = new PortComponentInfo(di, pcMetaData);
                    this.server.invoke(AxisServiceMBean.OBJECT_NAME, "deployService", new Object[]{pcInfo}, new String[]{(class$org$jboss$webservice$PortComponentInfo == null ? ServiceDeployer.class$("org.jboss.webservice.PortComponentInfo") : class$org$jboss$webservice$PortComponentInfo).getName()});
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Cannot deploy webservice", (Throwable)e);
        }
    }

    protected void undeployWebservices(DeploymentInfo di, WebservicesMetaData webservices) {
        try {
            WebserviceDescriptionMetaData[] wsdarr = webservices.getWebserviceDescriptions();
            for (int i = 0; i < wsdarr.length; ++i) {
                WebserviceDescriptionMetaData wsDescription = wsdarr[i];
                PortComponentMetaData[] pcarr = wsDescription.getPortComponents();
                for (int j = 0; j < pcarr.length; ++j) {
                    PortComponentMetaData pcMetaData = pcarr[j];
                    PortComponentInfo pcInfo = new PortComponentInfo(di, pcMetaData);
                    String wsID = pcInfo.getServiceID();
                    this.server.invoke(AxisService.OBJECT_NAME, "undeployService", new Object[]{wsID}, new String[]{(class$java$lang$String == null ? ServiceDeployer.class$("java.lang.String") : class$java$lang$String).getName()});
                }
            }
        }
        catch (Exception ignore) {
            this.log.warn((Object)("Cannot undeploy webservice: " + ignore));
        }
    }

    protected void modifyServletConfig(Document doc, String servletName, PortComponentInfo pcInfo) throws DeploymentException {
        Element servletElement = null;
        Iterator it = doc.getRootElement().elements("servlet").iterator();
        while (it.hasNext() && servletElement == null) {
            Element el = (Element)it.next();
            String elName = el.elementTextTrim("servlet-name");
            if (!servletName.equals(elName)) continue;
            servletElement = el;
        }
        if (servletElement == null) {
            throw new DeploymentException("Cannot find <servlet> with servlet-name: " + servletName);
        }
        Element classElement = servletElement.element("servlet-class");
        if (classElement == null) {
            throw new DeploymentException("Cannot find <servlet-class> for servlet-name: " + servletName);
        }
        String className = classElement.getTextTrim();
        classElement.setText(this.getServiceEndpointServletName());
        PortComponentMetaData pcMetaData = pcInfo.getPortComponentMetaData();
        pcMetaData.setServiceEndpointBean(className);
        boolean startDetach = false;
        ArrayList<Element> detachedElements = new ArrayList<Element>();
        it = servletElement.elements().iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (startDetach) {
                detachedElements.add(el);
                el.detach();
            }
            if (!el.equals(classElement)) continue;
            startDetach = true;
        }
        Element paramElement = servletElement.addElement("init-param");
        paramElement.addElement("param-name").addText(INIT_PARAM_WEBSERVICE_ID);
        paramElement.addElement("param-value").addText(pcInfo.getServiceID());
        it = detachedElements.iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            servletElement.add(el);
        }
    }

    protected abstract String getServiceEndpointServletName();

    public class ServiceLocationResolver {
        private DeploymentInfo di;

        public ServiceLocationResolver(DeploymentInfo di) {
            this.di = di;
        }

        public String getServiceLocation(String schema, PortComponentMetaData pcmd) {
            String ejbLink = pcmd.getEjbLink();
            String servletLink = pcmd.getServletLink();
            String serviceName = pcmd.getPortComponentName();
            String servicePath = null;
            if (servletLink != null) {
                WebMetaData metaData = (WebMetaData)this.di.metaData;
                HashMap servletMappings = metaData.getServletMappings();
                String urlPattern = (String)servletMappings.get(servletLink);
                if (urlPattern == null) {
                    throw new IllegalStateException("Cannot obtain servlet-mapping for: " + servletLink);
                }
                if (!urlPattern.startsWith("/")) {
                    urlPattern = "/" + urlPattern;
                }
                servicePath = metaData.getContextRoot() + urlPattern;
            } else {
                ApplicationMetaData amd = (ApplicationMetaData)this.di.metaData;
                BeanMetaData bmd = amd.getBeanByEjbName(ejbLink);
                if (bmd == null) {
                    throw new IllegalStateException("Cannot find ejb-name: " + ejbLink);
                }
                String contextRoot = amd.getWebServiceContextRoot();
                if (contextRoot == null) {
                    String shortName = this.di.shortName;
                    contextRoot = shortName.substring(0, shortName.indexOf(46));
                    if (this.di.parent != null) {
                        shortName = this.di.parent.shortName;
                        contextRoot = shortName.substring(0, shortName.indexOf(46)) + "/" + contextRoot;
                    }
                    contextRoot = "/" + contextRoot;
                }
                this.di.context.put(ServiceDeployer.WEBSERVICE_CONTEXT_ROOT, contextRoot);
                EjbPortComponentMetaData ejbpcMetaData = bmd.getPortComponent();
                servicePath = ejbpcMetaData != null && ejbpcMetaData.getPortComponentURI() != null ? ejbpcMetaData.getPortComponentURI() : contextRoot + "/" + serviceName;
            }
            if (servicePath.endsWith("/*")) {
                servicePath = servicePath.substring(0, servicePath.indexOf("/*"));
            }
            if (schema == null) {
                schema = "http://";
            }
            int port = 0;
            String host = null;
            String serviceEndpointAddress = null;
            try {
                host = (String)ServiceDeployer.this.server.getAttribute(AxisServiceMBean.OBJECT_NAME, "WebServiceHost");
                port = (Integer)ServiceDeployer.this.server.getAttribute(AxisServiceMBean.OBJECT_NAME, "WebServicePort");
                if ("https://".equals(schema)) {
                    port = (Integer)ServiceDeployer.this.server.getAttribute(AxisServiceMBean.OBJECT_NAME, "WebServiceSecurePort");
                }
                serviceEndpointAddress = new URL(schema + host + ":" + port + servicePath).toExternalForm();
            }
            catch (Exception e) {
                ServiceDeployer.this.log.error((Object)("Cannot obtain attribute from AxisService, cause: " + e.toString()));
            }
            return serviceEndpointAddress;
        }
    }
}

