/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.client;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.Service;
import org.apache.axis.wsdl.gen.Parser;
import org.jboss.logging.Logger;
import org.jboss.webservice.EngineConfigurationFinder;
import org.jboss.webservice.client.CallImpl;
import org.jboss.webservice.client.ClientEngine;
import org.jboss.webservice.client.PortProxy;
import org.jboss.webservice.client.Stub;
import org.jboss.webservice.deployment.BeanXMLMetaData;
import org.jboss.webservice.deployment.ServiceDescription;
import org.jboss.webservice.deployment.TypeMappingDescription;
import org.jboss.webservice.deployment.WSDDGenerator;
import org.jboss.webservice.encoding.ser.MetaDataBeanDeserializerFactory;
import org.jboss.webservice.encoding.ser.MetaDataBeanSerializerFactory;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;

public class ServiceImpl
extends Service {
    private static final Logger log = Logger.getLogger((Class)ServiceImpl.class);
    private static final String DEFAULT_PORT = "DEFAULT_PORT";
    private String targetEndpointAddress;
    private Map serviceDescMap = new HashMap();
    private JavaWsdlMapping javaWsdlMapping;
    private Definition wsdlDefinition;
    private Properties callProperties;

    public ServiceImpl() {
    }

    public ServiceImpl(QName serviceName) {
        super(serviceName);
    }

    public ServiceImpl(URL wsdlDoc, QName serviceName) throws ServiceException {
        super(wsdlDoc, serviceName);
    }

    public void initService(ServiceDescription serviceDesc, String portName) throws ServiceException {
        log.debug((Object)("initService: port=" + portName));
        if (portName == null) {
            portName = DEFAULT_PORT;
        }
        if (this.wsdlDefinition != null && this.wsdlDefinition != serviceDesc.getWsdlDefinition()) {
            throw new IllegalArgumentException("Cannot redefine the wsdl definition for this service");
        }
        if (this.javaWsdlMapping != null && this.javaWsdlMapping != serviceDesc.getJavaWsdlMapping()) {
            throw new IllegalArgumentException("Cannot redefine the jaxrpc-mapping definition for this service");
        }
        if (this.serviceDescMap.get(portName) != null) {
            throw new IllegalArgumentException("A service decription for this tport is already registered");
        }
        this.wsdlDefinition = serviceDesc.getWsdlDefinition();
        this.javaWsdlMapping = serviceDesc.getJavaWsdlMapping();
        this.serviceDescMap.put(portName, serviceDesc);
        if (log.isDebugEnabled()) {
            WSDDGenerator wsddGenerator = new WSDDGenerator(serviceDesc);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            wsddGenerator.appendOperations(pw);
            wsddGenerator.appendTypeMappings(pw);
            log.debug((Object)("Service configuration:\n" + sw));
        }
        this.setupTypeMapping(serviceDesc);
    }

    public HandlerRegistry getHandlerRegistry() {
        throw new UnsupportedOperationException("Components should not use the getHandlerRegistry() method.");
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        throw new UnsupportedOperationException("Components should not use the getTypeMappingRegistry() method.");
    }

    public Remote getPort(Class seiClass) throws ServiceException {
        Remote port = super.getPort(seiClass);
        PortProxy handler = new PortProxy(port, seiClass);
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        Class[] ifaces = new Class[]{seiClass, Stub.class};
        return (Remote)Proxy.newProxyInstance(contextCL, ifaces, (InvocationHandler)handler);
    }

    public Remote getPort(QName portName, Class seiClass) throws ServiceException {
        Remote port = super.getPort(portName, seiClass);
        PortProxy handler = new PortProxy(port, seiClass);
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        Class[] ifaces = new Class[]{seiClass, Stub.class};
        return (Remote)Proxy.newProxyInstance(contextCL, ifaces, (InvocationHandler)handler);
    }

    public void setCallProperties(Properties callProperties) {
        this.callProperties = callProperties;
    }

    public ServiceDescription getServiceDescription(String portName) {
        ServiceDescription serviceDesc = null;
        if (this.serviceDescMap.size() == 1 && DEFAULT_PORT.equals(this.serviceDescMap.keySet().iterator().next())) {
            serviceDesc = (ServiceDescription)this.serviceDescMap.values().iterator().next();
        } else if (portName != null) {
            serviceDesc = (ServiceDescription)this.serviceDescMap.get(portName);
        }
        if (serviceDesc == null) {
            log.warn((Object)("Cannot get ServiceDescription for: portName=" + portName + " we have " + this.serviceDescMap.keySet()));
        }
        return serviceDesc;
    }

    public Definition getWsdlDefinition() {
        return this.wsdlDefinition;
    }

    public void setWsdlDefinition(Definition wsdlDefinition) {
        this.wsdlDefinition = wsdlDefinition;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    public void setJavaWsdlMapping(JavaWsdlMapping javaWsdlMapping) {
        this.javaWsdlMapping = javaWsdlMapping;
    }

    public Call createCall() throws ServiceException {
        CallImpl call = new CallImpl(this);
        if (this.callProperties != null) {
            Iterator<Object> keys = this.callProperties.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = this.callProperties.getProperty(key);
                call.setProperty(key, value);
            }
        }
        return call;
    }

    public Iterator getPorts() throws ServiceException {
        if (this.wsdlService == null) {
            throw new UnsupportedOperationException("wsdl service is not available");
        }
        return this.wsdlService.getPorts().keySet().iterator();
    }

    public QName getServiceName() {
        if (this.serviceName != null) {
            return this.serviceName;
        }
        if (this.wsdlService == null) {
            throw new UnsupportedOperationException("wsdl service is not available");
        }
        return this.wsdlService.getQName();
    }

    protected AxisClient getAxisClient() {
        if (this.engine == null) {
            this.engine = new ClientEngine(this.getEngineConfiguration());
        }
        return (AxisClient)this.engine;
    }

    protected EngineConfiguration getEngineConfiguration() {
        if (this.config == null) {
            this.config = EngineConfigurationFinder.getClientEngineConfiguration();
            if (this.config == null) {
                throw new IllegalStateException("Cannot obtain client config");
            }
        }
        return this.config;
    }

    protected Parser getParser() {
        Parser parser = super.getParser();
        parser.setNowrap(true);
        return parser;
    }

    protected String getTargetEnpointAddress() {
        return this.targetEndpointAddress;
    }

    public void setTargetEndpointAddress(String targetEndpointAddress) {
        this.targetEndpointAddress = targetEndpointAddress;
    }

    protected Port getWSDLPort(Class seiClass) throws ServiceException {
        if (this.wsdlService == null) {
            return null;
        }
        Map wsdlPorts = this.wsdlService.getPorts();
        if (wsdlPorts == null || wsdlPorts.size() == 0) {
            throw new ServiceException("Cannot obtain wsdl wsdlPorts for service: " + this.wsdlService.getQName());
        }
        Port wsdlPort = null;
        if (wsdlPorts.values().size() == 1) {
            wsdlPort = (Port)wsdlPorts.values().iterator().next();
            return wsdlPort;
        }
        if (this.javaWsdlMapping != null) {
            log.debug((Object)("Trying to get jaxrpc port mapping for: " + seiClass.getName()));
            ServiceEndpointInterfaceMapping[] seiMappings = this.javaWsdlMapping.getServiceEndpointInterfaceMappings();
            for (int i = 0; wsdlPort == null && i < seiMappings.length; ++i) {
                ServiceEndpointInterfaceMapping seiMapping = seiMappings[i];
                if (!seiClass.getName().equals(seiMapping.getServiceEndpointInterface())) continue;
                QName bindingName = seiMapping.getWsdlBinding();
                Iterator it = wsdlPorts.values().iterator();
                while (wsdlPort == null && it.hasNext()) {
                    Port auxPort = (Port)it.next();
                    if (!auxPort.getBinding().getQName().equals(bindingName)) continue;
                    wsdlPort = auxPort;
                }
            }
        }
        if (wsdlPort == null) {
            log.warn((Object)("Cannot obtain jaxrpc port mapping for: " + seiClass.getName()));
            wsdlPort = super.getWSDLPort(seiClass);
        }
        return wsdlPort;
    }

    private void setupTypeMapping(ServiceDescription serviceDesc) throws ServiceException {
        TypeMappingRegistry tmRegistry = super.getTypeMappingRegistry();
        if (tmRegistry == null) {
            throw new IllegalStateException("Cannot obtain TypeMappingRegistry");
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Iterator it = serviceDesc.getTypMappings();
        while (it.hasNext()) {
            TypeMappingDescription typeMapping = (TypeMappingDescription)it.next();
            QName typeQName = typeMapping.getTypeQName();
            String javaType = typeMapping.getJavaType();
            String encodingURI = typeMapping.getEncodingURI();
            BeanXMLMetaData metaData = typeMapping.getMetaData();
            TypeMapping tm = tmRegistry.getTypeMapping(encodingURI);
            SerializerFactory serFactory = null;
            DeserializerFactory desFactory = null;
            try {
                Class typeClass = typeMapping.loadJavaType(cl);
                if (typeClass == null) continue;
                String serFactoryName = typeMapping.getSerializerFactoryName();
                String desFactoryName = typeMapping.getDeserializerFactoryName();
                if (!tm.isRegistered(typeClass, typeQName) || typeMapping.isUserDefined()) {
                    Constructor<?> ctor;
                    if (serFactoryName != null) {
                        Class<?> serFactoryClass = cl.loadClass(serFactoryName);
                        if (this.hasQualifiedConstructor(serFactoryClass)) {
                            ctor = serFactoryClass.getConstructor(class$java$lang$Class == null ? ServiceImpl.class$("java.lang.Class") : class$java$lang$Class, class$javax$xml$namespace$QName == null ? ServiceImpl.class$("javax.xml.namespace.QName") : class$javax$xml$namespace$QName);
                            serFactory = (SerializerFactory)ctor.newInstance(typeClass, typeQName);
                            if (serFactory instanceof MetaDataBeanSerializerFactory) {
                                ((MetaDataBeanSerializerFactory)serFactory).setMetaData(metaData);
                            }
                        } else {
                            serFactory = (SerializerFactory)serFactoryClass.newInstance();
                        }
                    }
                    if (desFactoryName != null) {
                        Class<?> desFactoryClass = cl.loadClass(desFactoryName);
                        if (this.hasQualifiedConstructor(desFactoryClass)) {
                            ctor = desFactoryClass.getConstructor(class$java$lang$Class == null ? ServiceImpl.class$("java.lang.Class") : class$java$lang$Class, class$javax$xml$namespace$QName == null ? ServiceImpl.class$("javax.xml.namespace.QName") : class$javax$xml$namespace$QName);
                            desFactory = (DeserializerFactory)ctor.newInstance(typeClass, typeQName);
                            if (desFactory instanceof MetaDataBeanDeserializerFactory) {
                                ((MetaDataBeanDeserializerFactory)desFactory).setMetaData(metaData);
                            }
                        } else {
                            desFactory = (DeserializerFactory)desFactoryClass.newInstance();
                        }
                    }
                    if (serFactory == null || desFactory == null) continue;
                    log.debug((Object)("Register type mapping [qname=" + typeQName + ",class=" + javaType + "," + serFactoryName + "," + desFactoryName + "]"));
                    tm.register(typeClass, typeQName, serFactory, desFactory);
                    continue;
                }
                log.debug((Object)("Ignore type mapping [qname=" + typeQName + ",class=" + javaType + "," + serFactoryName + "," + desFactoryName + "]"));
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Cannot setup type mapping", e.getTargetException());
                throw new ServiceException(e.getTargetException());
            }
            catch (Exception e) {
                log.error((Object)"Cannot setup type mapping", (Throwable)e);
                throw new ServiceException((Throwable)e);
            }
        }
    }

    private boolean hasQualifiedConstructor(Class factoryClass) {
        try {
            Constructor ctor = factoryClass.getConstructor(Class.class, QName.class);
            return ctor != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

