/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.deployment;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;

public class NamespaceRegistry {
    public static final String PREFIX_XML_SCHEMA = "xsd";
    public static final String URI_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String PREFIX_XML_SCHEMA_INSTANCE = "xsi";
    public static final String URI_XML_SCHEMA_INSTANCE = "http://www.w3.org/2000/10/XMLSchema-instance";
    private HashMap namespaceMap = new HashMap();
    private int namespaceIndex;

    public NamespaceRegistry() {
        this.namespaceMap.put(URI_XML_SCHEMA, PREFIX_XML_SCHEMA);
        this.namespaceMap.put(URI_XML_SCHEMA_INSTANCE, PREFIX_XML_SCHEMA_INSTANCE);
    }

    public QName registerQName(QName qname) {
        if (qname == null) {
            return null;
        }
        String prefix = this.registerNamespaceURI(qname.getNamespaceURI(), qname.getPrefix());
        qname = new QName(qname.getNamespaceURI(), qname.getLocalPart(), prefix);
        return qname;
    }

    public String registerNamespaceURI(String namespaceURI, String prefix) {
        String regPrefix = (String)this.namespaceMap.get(namespaceURI);
        if (regPrefix == null && prefix != null && prefix.length() > 0) {
            regPrefix = prefix;
        }
        if (regPrefix == null) {
            regPrefix = "ns" + ++this.namespaceIndex;
        }
        this.namespaceMap.put(namespaceURI, regPrefix);
        return regPrefix;
    }

    public String getPrefix(String namespaceURI) {
        return (String)this.namespaceMap.get(namespaceURI);
    }

    public String getNamespaceURI(String prefix) {
        Iterator it = this.namespaceMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!prefix.equals(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public Iterator getRegisteredNamespaceURIs() {
        return this.namespaceMap.keySet().iterator();
    }
}

