/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.deployment;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.enum.Style;
import org.apache.axis.enum.Use;
import org.jboss.logging.Logger;
import org.jboss.webservice.deployment.OperationDescription;
import org.jboss.webservice.deployment.ServiceDescription;
import org.jboss.webservice.deployment.TypeMappingDescription;

public class WSDDGenerator {
    private final Logger log = Logger.getLogger((Class)WSDDGenerator.class);
    private ServiceDescription serviceDesc;

    public WSDDGenerator(ServiceDescription service) {
        this.serviceDesc = service;
    }

    public void generateDeployment(PrintWriter out, String serviceName, String provider) {
        this.appendHeader(out);
        this.appendServiceElement(out, serviceName, provider);
        this.appendOperations(out);
        this.appendTypeMappings(out);
        this.appendFooter(out);
        out.close();
    }

    public void appendHeader(PrintWriter out) {
        out.println("<deployment");
        out.println(" xmlns='http://xml.apache.org/axis/wsdd/'");
        out.println(" xmlns:java='http://xml.apache.org/axis/wsdd/providers/java'");
        out.println(" xmlns:soap='http://schemas.xmlsoap.org/soap/encoding/'");
        out.println(" xmlns:xsi='http://www.w3.org/2000/10/XMLSchema-instance'");
        out.println(" xmlns:xsd='http://www.w3.org/2001/XMLSchema'>");
        out.println();
    }

    public void appendServiceElement(PrintWriter out, String serviceID, String provider) {
        Style style = this.serviceDesc.getStyle();
        String styleStr = style != null ? "style='" + style + "' " : " ";
        Use use = this.serviceDesc.getUse();
        String useStr = use != null ? "use='" + use + "' " : " ";
        out.println("<service name='" + serviceID + "' " + styleStr + useStr + "provider='" + provider + "'>");
        out.println();
    }

    public void appendOperations(PrintWriter out) {
        Object[] opNames = this.serviceDesc.getOperationNames();
        Arrays.sort(opNames);
        for (int i = 0; i < opNames.length; ++i) {
            Object opName = opNames[i];
            OperationDescription operation = this.serviceDesc.getOperation((String)opName);
            operation.writeWSDD(out);
        }
        out.println();
    }

    public void appendTypeMappings(PrintWriter out) {
        QName[] typeQNames = this.serviceDesc.getTypMappingNames();
        LinkedHashMap<String, QName> typeQNameMap = new LinkedHashMap<String, QName>();
        for (int i = 0; i < typeQNames.length; ++i) {
            typeQNameMap.put(typeQNames[i].toString(), typeQNames[i]);
        }
        Object[] typeNames = new String[typeQNames.length];
        typeQNameMap.keySet().toArray(typeNames);
        Arrays.sort(typeNames);
        for (int i = 0; i < typeNames.length; ++i) {
            QName typeQName = (QName)typeQNameMap.get(typeNames[i]);
            TypeMappingDescription typeMapping = this.serviceDesc.getTypMapping(typeQName);
            typeMapping.writeWSDD(out);
            out.println();
        }
        out.println();
    }

    public void appendFooter(PrintWriter out) {
        out.println("</service>");
        out.println("</deployment>");
    }

    public static String getQNameAttrValue(QName qname) {
        if (qname == null) {
            throw new IllegalArgumentException("Cannot convert null qname");
        }
        String qnamePrefix = qname.getPrefix();
        if (qnamePrefix.length() > 0) {
            qnamePrefix = qnamePrefix + ":";
        }
        String qnameAttr = qnamePrefix + qname.getLocalPart();
        return qnameAttr;
    }

    public static void main(String[] args) throws Exception {
        URL wsdlURL = null;
        URL jaxrpcURL = null;
        String portName = null;
        if (args.length > 0) {
            try {
                wsdlURL = new URL(args[0]);
            }
            catch (MalformedURLException e) {
                wsdlURL = new File(args[0]).toURL();
            }
        }
        if (args.length > 1) {
            try {
                jaxrpcURL = new URL(args[1]);
            }
            catch (MalformedURLException e) {
                jaxrpcURL = new File(args[1]).toURL();
            }
        }
        if (args.length > 2) {
            portName = args[2];
        }
        ServiceDescription serviceDesc = new ServiceDescription(wsdlURL, jaxrpcURL, portName);
        serviceDesc.dumpWsdlDefinition(System.out);
        System.out.println("-------------------------------------------------------------------");
        WSDDGenerator generator = new WSDDGenerator(serviceDesc);
        StringWriter buffer = new StringWriter(1024);
        PrintWriter out = new PrintWriter(buffer);
        String serviceName = serviceDesc.getWsdlService().getQName().getLocalPart();
        generator.generateDeployment(out, serviceName, "Handler");
        System.out.println(buffer.toString());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.parse(new ByteArrayInputStream(buffer.toString().getBytes()));
        File file = new File("ws4ee-deployment.xml");
        out = new PrintWriter(new FileWriter(file));
        out.println(buffer.toString());
        out.close();
        System.out.println(file.getCanonicalPath());
    }
}

