/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.examples;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PBEs {
    private String algorithm = null;
    private String filename = null;
    private Key secretKey = null;
    private final byte[] salt = new byte[]{32, 33, 16, 85, -125, 1, 1, -111};
    private final int iterations = 20;

    public PBEs(String string, String string2) {
        this.algorithm = string;
        char[] cArray = new char[string2.length()];
        string2.getChars(0, string2.length(), cArray, 0);
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        SecretKeyFactory secretKeyFactory = null;
        try {
            secretKeyFactory = SecretKeyFactory.getInstance(string);
            this.secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            invalidKeySpecException.printStackTrace();
        }
    }

    public boolean run(int n, String string) {
        boolean bl = false;
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.salt, 20);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.algorithm);
            cipher.init(n, this.secretKey, pBEParameterSpec);
            bl = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            invalidAlgorithmParameterException.printStackTrace();
        }
        if (!bl) {
            return bl;
        }
        bl = false;
        CipherOutputStream cipherOutputStream = null;
        CipherInputStream cipherInputStream = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (n == 1) {
                fileInputStream = new FileInputStream(string);
                fileOutputStream = new FileOutputStream(String.valueOf(string) + ".PBEencrypted." + this.algorithm);
                cipherOutputStream = new CipherOutputStream(fileOutputStream, cipher);
                byte[] byArray = new byte[8192];
                int n2 = 0;
                while ((n2 = fileInputStream.read(byArray)) != -1) {
                    cipherOutputStream.write(byArray, 0, n2);
                }
                fileInputStream.close();
                cipherOutputStream.close();
                bl = true;
            } else {
                fileInputStream = new FileInputStream(String.valueOf(string) + ".PBEencrypted." + this.algorithm);
                cipherInputStream = new CipherInputStream(fileInputStream, cipher);
                fileOutputStream = new FileOutputStream(String.valueOf(string) + ".PBEdecrypted." + this.algorithm);
                byte[] byArray = new byte[8192];
                int n3 = 0;
                while ((n3 = cipherInputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n3);
                }
                cipherInputStream.close();
                fileOutputStream.close();
                bl = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return bl;
    }
}

