/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnException;
import cryptix.jce.provider.asn.AsnInputStream;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnOutputStream;
import java.io.IOException;

public final class AsnBitString
extends AsnObject {
    private final byte[] val;

    AsnBitString(AsnInputStream asnInputStream) throws AsnException, IOException {
        super((byte)3);
        int n = asnInputStream.readLength() - 1;
        if (n < 0) {
            throw new AsnException("Negative length.");
        }
        byte by = asnInputStream.readByte();
        if (by != 0) {
            throw new AsnException("Length not a multiple of 8.");
        }
        this.val = asnInputStream.readBytes(n);
    }

    public AsnBitString(byte[] byArray) {
        super((byte)3);
        this.val = (byte[])byArray.clone();
    }

    protected void encodePayload(AsnOutputStream asnOutputStream) throws IOException {
        asnOutputStream.writeByte((byte)0);
        asnOutputStream.writeBytes(this.val);
    }

    protected int getEncodedLengthOfPayload(AsnOutputStream asnOutputStream) {
        return this.val.length + 1;
    }

    public byte[] toByteArray() {
        return (byte[])this.val.clone();
    }

    public String toString(String string) {
        return "BIT_STRING";
    }
}

