/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnInputStream;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnOutputStream;
import java.io.IOException;
import java.util.Vector;

public final class AsnSequence
extends AsnObject {
    private final AsnObject[] vals;

    AsnSequence(AsnInputStream asnInputStream) throws IOException {
        super((byte)48);
        int n = asnInputStream.readLength();
        AsnInputStream asnInputStream2 = asnInputStream.getSubStream(n);
        Vector<AsnObject> vector = new Vector<AsnObject>(3);
        while (asnInputStream2.available() > 0) {
            vector.addElement(asnInputStream2.read());
        }
        this.vals = new AsnObject[vector.size()];
        vector.copyInto(this.vals);
    }

    public AsnSequence(AsnObject asnObject, AsnObject asnObject2) {
        super((byte)48);
        AsnObject[] asnObjectArray = new AsnObject[]{asnObject, asnObject2};
        this.vals = asnObjectArray;
    }

    public AsnSequence(AsnObject[] asnObjectArray) {
        super((byte)48);
        this.vals = (AsnObject[])asnObjectArray.clone();
    }

    protected void encodePayload(AsnOutputStream asnOutputStream) throws IOException {
        int n = 0;
        while (n < this.vals.length) {
            asnOutputStream.write(this.vals[n]);
            ++n;
        }
    }

    public AsnObject get(int n) {
        return this.vals[n];
    }

    protected int getEncodedLengthOfPayload(AsnOutputStream asnOutputStream) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.vals.length) {
            n += this.vals[n2].getEncodedLength(asnOutputStream);
            ++n2;
        }
        return n;
    }

    public int size() {
        return this.vals.length;
    }

    public String toString(String string) {
        String string2 = String.valueOf(string) + "SEQUENCE (" + this.vals.length + " elements):";
        int n = 0;
        while (n < this.vals.length) {
            string2 = String.valueOf(string2) + "\n" + this.vals[n].toString(String.valueOf(string) + "    ");
            ++n;
        }
        return string2;
    }
}

