/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import java.security.InvalidKeyException;
import java.security.Key;

public final class IDEA
extends BlockCipher {
    private static final int ROUNDS = 8;
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 16;
    private static final int INTERNAL_KEY_LENGTH = 52;
    private short[] ks = new short[52];

    public IDEA() {
        super(8);
    }

    private void blockEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        short s;
        short s2 = (short)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
        short s3 = (short)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
        short s4 = (short)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
        short s5 = (short)((byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF);
        int n3 = 0;
        int n4 = 8;
        while (n4-- > 0) {
            s2 = IDEA.mul(s2, this.ks[n3++]);
            s3 = (short)(s3 + this.ks[n3++]);
            s4 = (short)(s4 + this.ks[n3++]);
            s5 = IDEA.mul(s5, this.ks[n3++]);
            short s6 = s4;
            s4 = IDEA.mul(s2 ^ s4, this.ks[n3++]);
            s = s3;
            s3 = IDEA.mul(s4 + (s3 ^ s5), this.ks[n3++]);
            s4 = (short)(s4 + s3);
            s2 = (short)(s2 ^ s3);
            s5 = (short)(s5 ^ s4);
            s3 = (short)(s3 ^ s6);
            s4 = (short)(s4 ^ s);
        }
        s = IDEA.mul(s2, this.ks[n3++]);
        byArray2[n2++] = (byte)(s >>> 8);
        byArray2[n2++] = (byte)s;
        s = (short)(s4 + this.ks[n3++]);
        byArray2[n2++] = (byte)(s >>> 8);
        byArray2[n2++] = (byte)s;
        s = (short)(s3 + this.ks[n3++]);
        byArray2[n2++] = (byte)(s >>> 8);
        byArray2[n2++] = (byte)s;
        s = IDEA.mul(s5, this.ks[n3]);
        byArray2[n2++] = (byte)(s >>> 8);
        byArray2[n2] = (byte)s;
    }

    protected void coreCrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.blockEncrypt(byArray, n, byArray2, n2);
    }

    protected void coreInit(Key key, boolean bl) throws InvalidKeyException {
        this.makeKey(key);
        if (bl) {
            this.invertKey();
        }
    }

    private static short inv(short s) {
        int n = s & 0xFFFF;
        if (n <= 1) {
            return (short)n;
        }
        int n2 = 65537 / n;
        int n3 = 65537 % n;
        if (n3 == 1) {
            return (short)(1 - n2);
        }
        int n4 = 1;
        do {
            int n5 = n / n3;
            n4 += n5 * n2;
            if ((n %= n3) == 1) {
                return (short)n4;
            }
            n5 = n3 / n;
            n2 += n5 * n4;
        } while ((n3 %= n) != 1);
        return (short)(1 - n2);
    }

    private void invertKey() {
        int n = 4;
        int n2 = 51;
        short[] sArray = new short[52];
        sArray[n2--] = IDEA.inv(this.ks[3]);
        sArray[n2--] = -this.ks[2];
        sArray[n2--] = -this.ks[1];
        sArray[n2--] = IDEA.inv(this.ks[0]);
        int n3 = 1;
        while (n3 < 8) {
            sArray[n2--] = this.ks[n + 1];
            sArray[n2--] = this.ks[n];
            sArray[n2--] = IDEA.inv(this.ks[n + 5]);
            sArray[n2--] = -this.ks[n + 3];
            sArray[n2--] = -this.ks[n + 4];
            sArray[n2--] = IDEA.inv(this.ks[n + 2]);
            ++n3;
            n += 6;
        }
        sArray[n2--] = this.ks[n + 1];
        sArray[n2--] = this.ks[n];
        sArray[n2--] = IDEA.inv(this.ks[n + 5]);
        sArray[n2--] = -this.ks[n + 4];
        sArray[n2--] = -this.ks[n + 3];
        sArray[n2--] = IDEA.inv(this.ks[n + 2]);
        System.arraycopy(sArray, 0, this.ks, 0, 52);
    }

    private void makeKey(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Null user key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException("Invalid user key length");
        }
        this.ks[0] = (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        this.ks[1] = (short)((byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF);
        this.ks[2] = (short)((byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF);
        this.ks[3] = (short)((byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF);
        this.ks[4] = (short)((byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF);
        this.ks[5] = (short)((byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF);
        this.ks[6] = (short)((byArray[12] & 0xFF) << 8 | byArray[13] & 0xFF);
        this.ks[7] = (short)((byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF);
        int n = 0;
        int n2 = 0;
        int n3 = 8;
        while (n3 < 52) {
            this.ks[++n + 7 + n2] = (short)(this.ks[(n & 7) + n2] << 9 | this.ks[(n + 1 & 7) + n2] >>> 7 & 0x1FF);
            n2 += n & 8;
            n &= 7;
            ++n3;
        }
    }

    private static short mul(int n, int n2) {
        n2 &= 0xFFFF;
        if ((n &= 0xFFFF) != 0) {
            if (n2 != 0) {
                int n3 = n * n2;
                return (short)(n2 - n + ((n2 = n3 & 0xFFFF) < (n = n3 >>> 16) ? 1 : 0));
            }
            return (short)(1 - n);
        }
        return (short)(1 - n2);
    }
}

