/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import cryptix.jce.provider.cipher.Mode;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

final class ModeCBC
extends Mode {
    private final byte[] buf = new byte[this.CIPHER_BLOCK_SIZE];
    private final byte[] prevBlock = new byte[this.CIPHER_BLOCK_SIZE];
    private byte[] IV = null;

    ModeCBC(BlockCipher blockCipher) {
        super(blockCipher);
    }

    final byte[] coreGetIV() {
        return this.IV;
    }

    final int coreGetOutputSize(int n) {
        return (this.bufCount + n) / this.CIPHER_BLOCK_SIZE * this.CIPHER_BLOCK_SIZE;
    }

    final AlgorithmParameterSpec coreGetParamSpec() {
        if (this.IV == null) {
            return new IvParameterSpec(this.generateIV());
        }
        return new IvParameterSpec(this.IV);
    }

    final void coreInit(boolean bl, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipher.coreInit(key, bl);
        this.IV = this.extractIV(algorithmParameterSpec);
        if (bl) {
            System.arraycopy(this.IV, 0, this.prevBlock, 0, this.CIPHER_BLOCK_SIZE);
            this.bufCount = 0;
        } else {
            System.arraycopy(this.IV, 0, this.buf, 0, this.CIPHER_BLOCK_SIZE);
            this.bufCount = 0;
        }
    }

    int coreUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4;
        int n5;
        if (this.decrypt) {
            int n6;
            int n7;
            int n8 = 0;
            while (n2 >= (n7 = this.CIPHER_BLOCK_SIZE - this.bufCount)) {
                n6 = 0;
                while (n6 < n7) {
                    this.buf[this.bufCount++] = byArray[n++];
                    ++n6;
                }
                this.cipher.coreCrypt(this.buf, 0, byArray2, n3);
                int n9 = 0;
                while (n9 < this.CIPHER_BLOCK_SIZE) {
                    int n10 = n3++;
                    byArray2[n10] = (byte)(byArray2[n10] ^ this.prevBlock[n9]);
                    ++n9;
                }
                int n11 = 0;
                while (n11 < this.CIPHER_BLOCK_SIZE) {
                    this.prevBlock[n11] = this.buf[n11];
                    ++n11;
                }
                n2 -= this.CIPHER_BLOCK_SIZE;
                n8 += this.CIPHER_BLOCK_SIZE;
                this.bufCount = 0;
            }
            n6 = 0;
            while (n6 < n2) {
                this.buf[this.bufCount++] = byArray[n++];
                ++n6;
            }
            return n8;
        }
        int n12 = 0;
        while (n2 >= (n5 = this.CIPHER_BLOCK_SIZE - this.bufCount)) {
            n4 = 0;
            while (n4 < n5) {
                int n13 = this.bufCount++;
                this.buf[n13] = (byte)(this.buf[n13] ^ byArray[n++]);
                ++n4;
            }
            this.cipher.coreCrypt(this.buf, 0, this.buf, 0);
            System.arraycopy(this.buf, 0, byArray2, n3, this.CIPHER_BLOCK_SIZE);
            n2 -= n5;
            n3 += this.CIPHER_BLOCK_SIZE;
            n12 += this.CIPHER_BLOCK_SIZE;
            this.bufCount = 0;
        }
        n4 = 0;
        while (n4 < n2) {
            int n14 = this.bufCount++;
            this.buf[n14] = (byte)(this.buf[n14] ^ byArray[n++]);
            ++n4;
        }
        return n12;
    }

    final boolean needsPadding() {
        return true;
    }
}

