/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.Mode;
import cryptix.jce.provider.cipher.PaddingNone;
import cryptix.jce.provider.cipher.PaddingPKCS5;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

abstract class Padding {
    private final Mode mode;
    private byte[] scratchBuf;
    private int blSize;
    private boolean isBuffered;
    protected boolean decrypt;

    Padding(Mode mode) {
        this.mode = mode;
        this.blSize = this.getBlockSize();
        this.scratchBuf = new byte[this.blSize];
        this.isBuffered = false;
    }

    abstract byte[] corePad(byte[] var1, int var2) throws IllegalBlockSizeException;

    abstract int coreUnPad(byte[] var1, int var2);

    final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (byArray2.length < this.getOutputSize(n2)) {
            throw new ShortBufferException("The output buffer is too short");
        }
        if (this.decrypt) {
            if (byArray == null && !this.isBuffered) {
                return 0;
            }
            if (byArray != null && n2 < this.getPadSize(n2)) {
                throw new BadPaddingException("Input data not bounded by the padding size");
            }
            int n4 = 0;
            if (this.isBuffered) {
                n4 = this.mode.update(this.scratchBuf, 0, this.blSize, byArray2, n3);
                if (byArray != null) {
                    n4 += this.mode.update(byArray, n, n2, byArray2, n3 + this.blSize);
                }
            } else {
                n4 = this.mode.update(byArray, n, n2, byArray2, n3);
            }
            this.isBuffered = false;
            return this.coreUnPad(byArray2, n4);
        }
        byte[] byArray3 = this.corePad(byArray, n2);
        return this.mode.update(byArray3, n, byArray3.length, byArray2, n3);
    }

    final int getBlockSize() {
        return this.mode.getBlockSize();
    }

    protected int getBufSize() {
        return this.mode.getBufSize();
    }

    final byte[] getIV() {
        return this.mode.getIV();
    }

    static Padding getInstance(String string, Mode mode) throws NoSuchPaddingException {
        if (string.equalsIgnoreCase("None") || string.equalsIgnoreCase("NoPadding")) {
            return new PaddingNone(mode);
        }
        if (string.equalsIgnoreCase("PKCS5") || string.equalsIgnoreCase("PKCS#5") || string.equalsIgnoreCase("PKCS5Padding") || string.equalsIgnoreCase("PKCS7") || string.equalsIgnoreCase("PKCS#7")) {
            return new PaddingPKCS5(mode);
        }
        throw new NoSuchPaddingException("Padding not available [" + string + "]");
    }

    final int getOutputSize(int n) {
        return this.mode.getOutputSize(n + this.getPadSize(n));
    }

    abstract int getPadSize(int var1);

    final AlgorithmParameterSpec getParamSpec() {
        return this.mode.getParamSpec();
    }

    final void init(boolean bl, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.decrypt = bl;
        this.mode.init(this.decrypt, key, algorithmParameterSpec, secureRandom);
    }

    final int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (byArray2.length < this.getOutputSize(n2)) {
            throw new ShortBufferException("The output buffer is too short");
        }
        if (this.decrypt) {
            int n4 = 0;
            if (!this.isBuffered) {
                n4 = this.mode.update(byArray, n, n2 - this.blSize, byArray2, n3);
                System.arraycopy(byArray, n + (n2 - this.blSize), this.scratchBuf, 0, this.blSize);
                this.isBuffered = true;
            } else {
                n4 = this.mode.update(this.scratchBuf, 0, this.blSize, byArray2, n3);
                System.arraycopy(byArray, n + (n2 - this.blSize), this.scratchBuf, 0, this.blSize);
                n4 += this.mode.update(byArray, n, n2 - this.blSize, byArray2, n3 + this.blSize);
            }
            return n4;
        }
        return this.mode.update(byArray, n, n2, byArray2, n3);
    }
}

