/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dh;

import cryptix.jce.util.MPIOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

final class DHPublicKeyCryptix
implements DHPublicKey {
    private final BigInteger y;
    private final DHParameterSpec params;

    DHPublicKeyCryptix(BigInteger bigInteger, DHParameterSpec dHParameterSpec) {
        this.y = bigInteger;
        this.params = dHParameterSpec;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            MPIOutputStream mPIOutputStream = new MPIOutputStream((OutputStream)byteArrayOutputStream);
            mPIOutputStream.write(this.params.getP());
            mPIOutputStream.write(BigInteger.valueOf(this.params.getL()));
            mPIOutputStream.write(this.params.getG());
            mPIOutputStream.write(this.y);
            mPIOutputStream.flush();
            mPIOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("PANIC");
        }
    }

    public String getFormat() {
        return "Cryptix";
    }

    public DHParameterSpec getParams() {
        return this.params;
    }

    public BigInteger getY() {
        return this.y;
    }
}

