/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dsa;

import cryptix.jce.provider.dsa.SignatureData;
import cryptix.jce.provider.util.Util;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public final class DSASignature
extends SignatureSpi
implements Cloneable {
    private static final SecureRandom _fallbackRng = new SecureRandom();
    private final MessageDigest _md;
    private BigInteger _g;
    private BigInteger _p;
    private BigInteger _q;
    private BigInteger _exp;
    private static final boolean MODE_SIGN = false;
    private static final boolean MODE_VERIFY = true;

    public DSASignature() {
        try {
            this._md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("PANIC: Algorithm SHA not found!");
        }
    }

    private DSASignature(DSASignature dSASignature) throws CloneNotSupportedException {
        this._md = (MessageDigest)dSASignature._md.clone();
        this._g = dSASignature._g;
        this._p = dSASignature._p;
        this._q = dSASignature._q;
        this._exp = dSASignature._exp;
    }

    private void _clear() {
        this.appRandom = null;
        this._exp = null;
        this._q = null;
        this._p = null;
        this._g = null;
        this._md.reset();
    }

    private boolean _isValid(boolean bl) {
        int n = this._p.bitLength();
        if (n > 1024 || n < 512 || n % 64 != 0) {
            return false;
        }
        if (this._q.bitLength() != 160) {
            return false;
        }
        if (this._g.compareTo(this._p) != -1) {
            return false;
        }
        if (this._exp == null || this._exp.compareTo(this._p) != -1) {
            return false;
        }
        return this.appRandom == null == bl;
    }

    public Object clone() throws CloneNotSupportedException {
        return new DSASignature(this);
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("No params supported.");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, _fallbackRng);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("Not a DSA private key");
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
        this._exp = dSAPrivateKey.getX();
        DSAParams dSAParams = dSAPrivateKey.getParams();
        this._g = dSAParams.getG();
        this._p = dSAParams.getP();
        this._q = dSAParams.getQ();
        this.appRandom = secureRandom;
        this._md.reset();
        if (!this._isValid(false)) {
            this._clear();
            throw new InvalidKeyException("Corrupt key?");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Not a DSA public key");
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        this._exp = dSAPublicKey.getY();
        DSAParams dSAParams = dSAPublicKey.getParams();
        this._g = dSAParams.getG();
        this._p = dSAParams.getP();
        this._q = dSAParams.getQ();
        this.appRandom = null;
        this._md.reset();
        if (!this._isValid(true)) {
            this._clear();
            throw new InvalidKeyException("Corrupt key?");
        }
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("No params supported.");
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No params supported.");
    }

    protected byte[] engineSign() throws SignatureException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3 = new BigInteger(1, this._md.digest());
        do {
            BigInteger bigInteger4;
            int n = this._q.bitLength();
            while ((bigInteger4 = new BigInteger(n, this.appRandom)).compareTo(this._q) != -1) {
            }
            bigInteger2 = this._g.modPow(bigInteger4, this._p).mod(this._q);
            bigInteger = bigInteger4.modInverse(this._q).multiply(bigInteger3.add(this._exp.multiply(bigInteger2))).mod(this._q);
        } while (bigInteger2.equals(Util.BI_ZERO) || bigInteger.equals(Util.BI_ZERO));
        return new SignatureData(bigInteger2, bigInteger).getData();
    }

    protected int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
        byte[] byArray2 = this.engineSign();
        if (byArray2.length > n2) {
            throw new SignatureException("Buffer too small.");
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this._md.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this._md.update(byArray, n, n2);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        SignatureData signatureData = new SignatureData(byArray);
        BigInteger bigInteger = signatureData.getR();
        BigInteger bigInteger2 = signatureData.getS();
        if (bigInteger.compareTo(Util.BI_ZERO) != 1 || bigInteger.compareTo(this._q) != -1 || bigInteger2.compareTo(Util.BI_ZERO) != 1 || bigInteger2.compareTo(this._q) != -1) {
            throw new SignatureException("Invalid signature data");
        }
        BigInteger bigInteger3 = new BigInteger(1, this._md.digest());
        if (bigInteger3.bitLength() > 160) {
            throw new InternalError("PANIC");
        }
        BigInteger bigInteger4 = bigInteger2.modInverse(this._q);
        BigInteger bigInteger5 = bigInteger3.multiply(bigInteger4).mod(this._q);
        BigInteger bigInteger6 = bigInteger.multiply(bigInteger4).mod(this._q);
        BigInteger bigInteger7 = this._g.modPow(bigInteger5, this._p);
        BigInteger bigInteger8 = this._exp.modPow(bigInteger6, this._p);
        BigInteger bigInteger9 = bigInteger7.multiply(bigInteger8).mod(this._p).mod(this._q);
        if (bigInteger4.compareTo(this._q) != -1) {
            throw new InternalError("PANIC");
        }
        if (bigInteger9.compareTo(this._q) != -1) {
            throw new InternalError("PANIC");
        }
        if (bigInteger5.compareTo(this._q) != -1) {
            throw new InternalError("PANIC");
        }
        if (bigInteger6.compareTo(this._q) != -1) {
            throw new InternalError("PANIC");
        }
        if (bigInteger7.compareTo(this._p) != -1) {
            throw new InternalError("PANIC");
        }
        if (bigInteger8.compareTo(this._p) != -1) {
            throw new InternalError("PANIC");
        }
        return bigInteger9.equals(bigInteger);
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

