/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dsa;

import cryptix.jce.provider.dsa.SignatureData;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public final class RawDSASignature
extends SignatureSpi {
    private BigInteger ZERO = BigInteger.valueOf(0L);
    private BigInteger x;
    private BigInteger y;
    private BigInteger g;
    private BigInteger p;
    private BigInteger q;
    private final byte[] buf = new byte[20];
    private int bufPtr;
    private SecureRandom random;

    public RawDSASignature() {
        this.burn();
    }

    private void burn() {
        this.q = null;
        this.p = null;
        this.g = null;
        this.y = null;
        this.x = null;
        this.bufPtr = 0;
        int n = 0;
        while (n < this.buf.length) {
            this.buf[n] = 0;
            ++n;
        }
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("This algorithm does not have parameters.");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.engineInitSign(privateKey, this.random);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.burn();
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("Not a DSA private key");
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
        this.x = dSAPrivateKey.getX();
        DSAParams dSAParams = dSAPrivateKey.getParams();
        this.g = dSAParams.getG();
        this.p = dSAParams.getP();
        this.q = dSAParams.getQ();
        this.random = secureRandom;
        if (!this.validate()) {
            this.burn();
            throw new InvalidKeyException("Invalid key values");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.burn();
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Not a DSA public key");
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        this.y = dSAPublicKey.getY();
        DSAParams dSAParams = dSAPublicKey.getParams();
        this.g = dSAParams.getG();
        this.p = dSAParams.getP();
        this.q = dSAParams.getQ();
        if (!this.validate()) {
            this.burn();
            throw new InvalidKeyException("Invalid key values");
        }
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("This algorithm does not accept parameters.");
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This algorithm does not accept AlgorithmParameterSpec.");
    }

    protected byte[] engineSign() throws SignatureException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (this.bufPtr != 20) {
            throw new SignatureException("Insufficient data for signature");
        }
        BigInteger bigInteger3 = new BigInteger(1, this.buf);
        do {
            BigInteger bigInteger4;
            int n = this.q.bitLength();
            while ((bigInteger4 = new BigInteger(n, this.random)).compareTo(this.q) != -1) {
            }
            bigInteger2 = this.g.modPow(bigInteger4, this.p).mod(this.q);
            bigInteger = bigInteger4.modInverse(this.q).multiply(bigInteger3.add(this.x.multiply(bigInteger2))).mod(this.q);
        } while (bigInteger2.equals(this.ZERO) || bigInteger.equals(this.ZERO));
        return new SignatureData(bigInteger2, bigInteger).getData();
    }

    protected void engineUpdate(byte by) throws SignatureException {
        if (this.bufPtr >= 20) {
            throw new SignatureException("Signature data length exceeded");
        }
        this.buf[this.bufPtr++] = by;
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.bufPtr + n2 > 20) {
            throw new SignatureException("Signature data length exceeded");
        }
        System.arraycopy(byArray, n, this.buf, this.bufPtr, n2);
        this.bufPtr += n2;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.bufPtr != 20) {
            throw new SignatureException("Insufficient data for signature");
        }
        SignatureData signatureData = new SignatureData(byArray);
        BigInteger bigInteger = signatureData.getR();
        BigInteger bigInteger2 = signatureData.getS();
        if (bigInteger.compareTo(this.ZERO) != 1 || bigInteger2.compareTo(this.ZERO) != 1 || bigInteger.compareTo(this.q) != -1 || bigInteger2.compareTo(this.q) != -1) {
            throw new SignatureException("Invalid signature data");
        }
        BigInteger bigInteger3 = new BigInteger(1, this.buf);
        if (bigInteger3.bitLength() > 160) {
            throw new InternalError("PANIC");
        }
        BigInteger bigInteger4 = bigInteger2.modInverse(this.q);
        BigInteger bigInteger5 = bigInteger3.multiply(bigInteger4).mod(this.q);
        BigInteger bigInteger6 = bigInteger.multiply(bigInteger4).mod(this.q);
        BigInteger bigInteger7 = this.g.modPow(bigInteger5, this.p);
        BigInteger bigInteger8 = this.y.modPow(bigInteger6, this.p);
        BigInteger bigInteger9 = bigInteger7.multiply(bigInteger8).mod(this.p).mod(this.q);
        if (bigInteger4.compareTo(this.q) != -1) {
            throw new InternalError("PANIC");
        }
        if (bigInteger9.compareTo(this.q) != -1) {
            throw new InternalError("PANIC");
        }
        if (bigInteger5.compareTo(this.q) != -1) {
            throw new InternalError("PANIC");
        }
        if (bigInteger6.compareTo(this.q) != -1) {
            throw new InternalError("PANIC");
        }
        if (bigInteger7.compareTo(this.p) != -1) {
            throw new InternalError("PANIC");
        }
        if (bigInteger8.compareTo(this.p) != -1) {
            throw new InternalError("PANIC");
        }
        return bigInteger9.equals(bigInteger);
    }

    private boolean validate() {
        int n = this.p.bitLength();
        if (n > 1024 || n < 512 || n % 64 != 0) {
            return false;
        }
        if (this.q.bitLength() != 160 || this.g.compareTo(this.p) != -1) {
            return false;
        }
        if (this.y != null && this.y.compareTo(this.p) != -1) {
            return false;
        }
        if (this.x != null && this.x.compareTo(this.p) != -1) {
            return false;
        }
        if (this.x != null && this.y != null) {
            throw new InternalError("PANIC");
        }
        if (this.x == null && this.y == null) {
            throw new InternalError("PANIC");
        }
        return true;
    }
}

