/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dsa;

import java.math.BigInteger;
import java.security.SignatureException;

class SignatureData {
    private BigInteger r;
    private BigInteger s;

    public SignatureData(BigInteger bigInteger, BigInteger bigInteger2) throws SignatureException {
        if (bigInteger == null || bigInteger2 == null) {
            throw new SignatureException("Invalid signature");
        }
        if (bigInteger.signum() != 1 || bigInteger2.signum() != 1) {
            throw new SignatureException("Invalid signature");
        }
        this.r = bigInteger;
        this.s = bigInteger2;
    }

    public SignatureData(byte[] byArray) throws SignatureException {
        try {
            int n;
            int n2 = 0;
            if (byArray[n2++] != 48 || byArray[n2++] != byArray.length - 2 || byArray[n2++] != 2) {
                throw new SignatureException("Corrupted signature data");
            }
            if ((n = byArray[n2++]) > 21) {
                throw new SignatureException("Corrupted signature data");
            }
            byte[] byArray2 = new byte[n];
            int n3 = 0;
            while (n3 < n) {
                byArray2[n3] = byArray[n2++];
                ++n3;
            }
            if (byArray[n2++] != 2) {
                throw new SignatureException("Corrupted signature data");
            }
            if ((n = byArray[n2++]) > 21) {
                throw new SignatureException("Corrupted signature data");
            }
            byte[] byArray3 = new byte[n];
            int n4 = 0;
            while (n4 < n) {
                byArray3[n4] = byArray[n2++];
                ++n4;
            }
            this.r = new BigInteger(byArray2);
            this.s = new BigInteger(byArray3);
            if (n2 != byArray.length || this.r.signum() != 1 || this.s.signum() != 1) {
                throw new SignatureException("Corrupted signature data");
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new SignatureException("Corrupted signature data");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("Corrupted signature data");
        }
    }

    public byte[] getData() {
        byte[] byArray = this.r.toByteArray();
        byte[] byArray2 = this.s.toByteArray();
        byte[] byArray3 = new byte[6 + byArray.length + byArray2.length];
        int n = 0;
        byArray3[n++] = 48;
        byArray3[n++] = (byte)(byArray3.length - 2);
        byArray3[n++] = 2;
        byArray3[n++] = (byte)byArray.length;
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray3[n++] = byArray[n2];
            ++n2;
        }
        byArray3[n++] = 2;
        byArray3[n++] = (byte)byArray2.length;
        int n3 = 0;
        while (n3 < byArray2.length) {
            byArray3[n++] = byArray2[n3];
            ++n3;
        }
        return byArray3;
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }
}

