/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.elgamal;

import java.math.BigInteger;
import java.security.SecureRandom;

final class ElGamalAlgorithm {
    private ElGamalAlgorithm() {
    }

    public static BigInteger decrypt(BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) throws ArithmeticException {
        return bigIntegerArray[0].modPow(bigInteger2, bigInteger).modInverse(bigInteger).multiply(bigIntegerArray[1]).mod(bigInteger);
    }

    public static BigInteger[] encrypt(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        BigInteger bigInteger5 = ElGamalAlgorithm.generateK(bigInteger2);
        try {
            BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger3.modPow(bigInteger5, bigInteger2), bigInteger4.modPow(bigInteger5, bigInteger2).multiply(bigInteger).mod(bigInteger2)};
            return bigIntegerArray;
        }
        catch (ArithmeticException arithmeticException) {
            throw new RuntimeException("PANIC: Should not happend!!");
        }
    }

    private static BigInteger generateK(BigInteger bigInteger) {
        BigInteger bigInteger2;
        BigInteger bigInteger3 = BigInteger.valueOf(1L);
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger3);
        SecureRandom secureRandom = new SecureRandom();
        while ((bigInteger2 = new BigInteger(bigInteger.bitLength(), secureRandom)).compareTo(bigInteger3) <= 0 || bigInteger2.compareTo(bigInteger4) >= 0) {
        }
        return bigInteger2;
    }
}

