/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.elgamal;

import cryptix.jce.ElGamalParams;
import cryptix.jce.provider.elgamal.ElGamalPrivateKeyCryptix;
import cryptix.jce.provider.elgamal.ElGamalPublicKeyCryptix;
import cryptix.jce.provider.elgamal.PrecomputedParams;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public final class ElGamalKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int KEYSIZE_MIN = 384;
    private static final int KEYSIZE_MAX = 16384;
    private static final int KEYSIZE_DEFAULT = 1536;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private SecureRandom random;
    private int keysize;
    private boolean initialized = false;

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        ElGamalParams elGamalParams;
        if (!this.initialized) {
            this.initialize();
        }
        if ((elGamalParams = PrecomputedParams.get(this.keysize)) == null) {
            throw new RuntimeException("NYI");
        }
        BigInteger bigInteger2 = elGamalParams.getP();
        BigInteger bigInteger3 = elGamalParams.getG();
        BigInteger bigInteger4 = TWO;
        BigInteger bigInteger5 = bigInteger2.subtract(TWO);
        int n = bigInteger2.bitLength();
        while ((bigInteger = new BigInteger(n, this.random)).compareTo(bigInteger4) == -1 || bigInteger.compareTo(bigInteger5) == 1) {
        }
        BigInteger bigInteger6 = bigInteger3.modPow(bigInteger, bigInteger2);
        ElGamalPublicKeyCryptix elGamalPublicKeyCryptix = new ElGamalPublicKeyCryptix(bigInteger6, elGamalParams);
        ElGamalPrivateKeyCryptix elGamalPrivateKeyCryptix = new ElGamalPrivateKeyCryptix(bigInteger, elGamalParams);
        return new KeyPair(elGamalPublicKeyCryptix, elGamalPrivateKeyCryptix);
    }

    private void initialize() {
        this.initialize(1536, new SecureRandom());
    }

    public void initialize(int n, SecureRandom secureRandom) {
        if (n < 384 || n > 16384) {
            throw new IllegalArgumentException("keysize: invalid size (" + n + ")");
        }
        this.keysize = n;
        this.random = secureRandom;
        this.initialized = true;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new RuntimeException("NYI");
    }
}

