/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.key;

import cryptix.jce.provider.key.RawKeyGenerator;

public class TripleDESKeyGenerator
extends RawKeyGenerator {
    private static final int STRENGTH = 168;
    private static final int BIT_LEN = 192;

    public TripleDESKeyGenerator() {
        super("TripleDES", 168);
    }

    protected byte[] fixUp(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            byArray[n] = (byte)(by & 0xFE | (by >> 1 ^ by >> 2 ^ by >> 3 ^ by >> 4 ^ by >> 5 ^ by >> 6 ^ by >> 7) & 1);
            ++n;
        }
        return byArray;
    }

    protected boolean isValidSize(int n) {
        return n == 168;
    }

    protected boolean isWeak(byte[] byArray) {
        return false;
    }

    protected int strengthToBits(int n) {
        if (n != 168) {
            throw new RuntimeException("Invalid strength value (" + n + ")");
        }
        return 192;
    }
}

