/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.parameters;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public final class BlockParameters
extends AlgorithmParametersSpi {
    private String algorithm;
    private byte[] iv = null;

    protected final byte[] engineGetEncoded() throws IOException {
        return this.iv;
    }

    protected final byte[] engineGetEncoded(String string) throws IOException {
        throw new RuntimeException("Method getEncoded(String format) not implemented");
    }

    protected final AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        try {
            if (!Class.forName("javax.crypto.spec.IvParameterSpec").isAssignableFrom(clazz)) {
                throw new InvalidParameterSpecException("Class is not IvParameterSpec assignable");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException("Class is not IvParameterSpec");
        }
        return new IvParameterSpec(this.iv);
    }

    protected final void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("Wrong ParameterSpec");
        }
        this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
    }

    protected final void engineInit(byte[] byArray) throws IOException {
        this.iv = byArray;
    }

    protected final void engineInit(byte[] byArray, String string) throws IOException {
        throw new RuntimeException("Method init(byte[] params, String format) not implemented");
    }

    protected final String engineToString() {
        return "iv:[" + this.hexDump(this.iv) + "]";
    }

    private final String hexDump(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] cArray2 = new char[byArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by = byArray[n2];
            cArray2[n++] = cArray[by >>> 4 & 0xF];
            cArray2[n++] = cArray[by & 0xF];
            ++n2;
        }
        return new String(cArray2);
    }
}

