/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.random;

final class StatisticalTests {
    private static final int[] ONE_COUNT;

    static {
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 3;
        nArray[8] = 1;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 3;
        nArray[12] = 2;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 4;
        ONE_COUNT = nArray;
    }

    private StatisticalTests() {
    }

    public static boolean looksRandom(byte[] byArray) {
        return StatisticalTests.testMonobit(byArray) && StatisticalTests.testPoker(byArray);
    }

    public static boolean testMonobit(byte[] byArray) {
        if (byArray.length != 2500) {
            throw new IllegalArgumentException("2500 bytes expected");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < 2500) {
            int n3 = ONE_COUNT[byArray[n2] >> 4 & 0xF];
            int n4 = ONE_COUNT[byArray[n2] & 0xF];
            n += n3 + n4;
            ++n2;
        }
        return n > 9654 && n < 10346;
    }

    public static boolean testPoker(byte[] byArray) {
        if (byArray.length != 2500) {
            throw new IllegalArgumentException("2500 bytes expected");
        }
        int[] nArray = new int[16];
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xF;
            nArray[n2] = nArray[n2] + 1;
            int n3 = byArray[n] >>> 4 & 0xF;
            nArray[n3] = nArray[n3] + 1;
            ++n;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < 16) {
            n4 += nArray[n5] * nArray[n5];
            ++n5;
        }
        float f = 16.0f * (float)n4 / 5000.0f - 5000.0f;
        return f > 1.03f && f < 57.4f;
    }
}

