/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.asn.AsnBitString;
import cryptix.jce.provider.asn.AsnInputStream;
import cryptix.jce.provider.asn.AsnInteger;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnSequence;
import cryptix.jce.provider.rsa.RSAPrivateCrtKeyCryptix;
import cryptix.jce.provider.rsa.RSAPrivateKeyCryptix;
import cryptix.jce.provider.rsa.RSAPublicKeyCryptix;
import cryptix.jce.provider.rsa.RSAPublicKeyImpl;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class RSAKeyFactory
extends KeyFactorySpi {
    private PrivateKey decodePrivateKey(X509EncodedKeySpec x509EncodedKeySpec) throws InvalidKeySpecException {
        throw new RuntimeException("NYI");
    }

    private PublicKey decodePublicKey(X509EncodedKeySpec x509EncodedKeySpec) throws InvalidKeySpecException {
        try {
            AsnInputStream asnInputStream = new AsnInputStream(x509EncodedKeySpec.getEncoded());
            AsnSequence asnSequence = (AsnSequence)asnInputStream.read();
            if (asnSequence.size() != 2) {
                throw new InvalidKeySpecException("First SEQUENCE has " + asnSequence.size() + " elements.");
            }
            AsnObject asnObject = asnSequence.get(0);
            System.out.println(asnObject);
            AsnBitString asnBitString = (AsnBitString)asnSequence.get(1);
            asnInputStream = new AsnInputStream(asnBitString.toByteArray());
            asnSequence = (AsnSequence)asnInputStream.read();
            if (asnSequence.size() != 2) {
                throw new InvalidKeySpecException("Second SEQUENCE has " + asnSequence.size() + " elements.");
            }
            AsnInteger asnInteger = (AsnInteger)asnSequence.get(0);
            AsnInteger asnInteger2 = (AsnInteger)asnSequence.get(1);
            return new RSAPublicKeyImpl(asnInteger.toBigInteger(), asnInteger2.toBigInteger());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidKeySpecException("Unexpected ASN.1 type detected: " + classCastException.getMessage());
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException("Could not parse key.");
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPrivateKeySpec) {
            RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
            return new RSAPrivateKeyCryptix(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
        }
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
            return new RSAPrivateCrtKeyCryptix(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            return this.decodePrivateKey((X509EncodedKeySpec)keySpec);
        }
        throw new InvalidKeySpecException(String.valueOf(this.getClass().getName()) + ".engineGeneratePrivate: " + "KeySpec of type " + keySpec.getClass() + " not supported.");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
            return new RSAPublicKeyCryptix(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            PublicKey publicKey = this.decodePublicKey((X509EncodedKeySpec)keySpec);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
            return this.decodePublicKey(x509EncodedKeySpec);
        }
        throw new InvalidKeySpecException(String.valueOf(this.getClass().getName()) + ".engineGeneratePublic: " + "KeySpec type " + keySpec.getClass() + " not supported.");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        throw new RuntimeException("NYI");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new RuntimeException("NYI");
    }
}

