/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.rsa.RSAAlgorithm;
import cryptix.jce.provider.util.Util;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public abstract class RSASignature_PKCS1
extends SignatureSpi {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private BigInteger n;
    private BigInteger exp;
    private BigInteger p;
    private BigInteger q;
    private BigInteger u;
    private final MessageDigest md;

    RSASignature_PKCS1(String string) {
        try {
            this.md = MessageDigest.getInstance(string);
        }
        catch (Exception exception) {
            throw new InternalError("Unable to instantiate messagedigest:" + string);
        }
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("This algorithm does not have parameters.");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Not an RSA private key");
        }
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
        this.n = rSAPrivateKey.getModulus();
        this.exp = rSAPrivateKey.getPrivateExponent();
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
            this.p = rSAPrivateCrtKey.getPrimeP();
            this.q = rSAPrivateCrtKey.getPrimeQ();
            this.u = rSAPrivateCrtKey.getCrtCoefficient();
        } else {
            this.u = null;
            this.q = null;
            this.p = null;
        }
        this.initCommon();
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInitSign(privateKey);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Not an RSA public key");
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
        this.n = rSAPublicKey.getModulus();
        this.exp = rSAPublicKey.getPublicExponent();
        this.u = null;
        this.q = null;
        this.p = null;
        this.initCommon();
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("This algorithm does not accept parameters.");
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This algorithm does not accept AlgorithmParameterSpec.");
    }

    protected byte[] engineSign() throws SignatureException {
        BigInteger bigInteger = this.makePKCS1();
        BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.n, this.exp, this.p, this.q, this.u);
        return Util.toFixedLenByteArray(bigInteger2, this.modulusByteLength());
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.md.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.md.update(byArray, n, n2);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.n, this.exp, this.p, this.q, this.u);
        BigInteger bigInteger3 = this.makePKCS1();
        return bigInteger2.equals(bigInteger3);
    }

    protected abstract byte[] getAlgorithmEncoding();

    private void initCommon() throws InvalidKeyException {
        this.md.reset();
        int n = this.md.digest().length;
        int n2 = this.modulusByteLength();
        int n3 = this.getAlgorithmEncoding().length;
        int n4 = n2 - 3 - n3 - n;
        if (n4 < 0) {
            throw new InvalidKeyException("Signer's key modulus too short.");
        }
    }

    private BigInteger makePKCS1() throws SignatureException {
        byte[] byArray = this.md.digest();
        int n = byArray.length;
        int n2 = this.modulusByteLength();
        byte[] byArray2 = new byte[n2];
        byArray2[1] = 1;
        byte[] byArray3 = this.getAlgorithmEncoding();
        int n3 = byArray3.length;
        int n4 = n2 - 3 - n3 - n;
        if (n4 < 0) {
            throw new SignatureException("Signer's public key modulus too short.");
        }
        int n5 = 0;
        while (n5 < n4) {
            byArray2[2 + n5++] = -1;
        }
        System.arraycopy(byArray3, 0, byArray2, n4 + 3, n3);
        System.arraycopy(byArray, 0, byArray2, n2 - n, n);
        return new BigInteger(byArray2);
    }

    private int modulusByteLength() {
        return (this.n.bitLength() + 7) / 8;
    }
}

