/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.util;

import java.math.BigInteger;

public final class Util {
    public static final BigInteger BI_ZERO = BigInteger.valueOf(0L);
    public static final BigInteger BI_ONE = BigInteger.valueOf(1L);

    private Util() {
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null ^ byArray2 == null) {
            return false;
        }
        int n = byArray.length;
        int n2 = byArray2.length;
        if (n != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (byArray[n3] != byArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static byte[] toFixedLenByteArray(BigInteger bigInteger, int n) {
        int n2;
        if (bigInteger.signum() != 1) {
            throw new IllegalArgumentException("BigInteger not positive.");
        }
        byte[] byArray = bigInteger.toByteArray();
        int n3 = byArray.length;
        if (n3 <= 0) {
            throw new IllegalArgumentException("BigInteger too small.");
        }
        int n4 = n2 = byArray[0] == 0 ? 1 : 0;
        if ((n3 -= n2) > n) {
            throw new IllegalArgumentException("BigInteger too large.");
        }
        byte[] byArray2 = new byte[n];
        int n5 = n - n3;
        System.arraycopy(byArray, n2, byArray2, n5, n3);
        return byArray2;
    }
}

