/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CursorableLinkedList;
import org.apache.commons.pool.BaseKeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

public class GenericKeyedObjectPool
extends BaseKeyedObjectPool
implements KeyedObjectPool {
    public static final byte WHEN_EXHAUSTED_FAIL = 0;
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MAX_ACTIVE = 8;
    public static final byte DEFAULT_WHEN_EXHAUSTED_ACTION = 1;
    public static final long DEFAULT_MAX_WAIT = -1L;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    private int _maxIdle = 8;
    private int _maxActive = 8;
    private long _maxWait = -1L;
    private byte _whenExhaustedAction = 1;
    private boolean _testOnBorrow = false;
    private boolean _testOnReturn = false;
    private boolean _testWhileIdle = false;
    private long _timeBetweenEvictionRunsMillis = -1L;
    private int _numTestsPerEvictionRun = 3;
    private long _minEvictableIdleTimeMillis = 1800000L;
    private HashMap _poolMap = null;
    private CursorableLinkedList _poolList = null;
    private HashMap _activeMap = null;
    private int _totalActive = 0;
    private int _totalIdle = 0;
    private KeyedPoolableObjectFactory _factory = null;
    private Evictor _evictor = null;
    private CursorableLinkedList.Cursor _evictionCursor = null;
    private CursorableLinkedList.Cursor _evictionKeyCursor = null;

    public GenericKeyedObjectPool() {
        this(null, 8, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory) {
        this(factory, 8, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, Config config) {
        this(factory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive) {
        this(factory, maxActive, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this._factory = factory;
        this._maxActive = maxActive;
        switch (whenExhaustedAction) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = whenExhaustedAction;
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + whenExhaustedAction + " not recognized.");
            }
        }
        this._maxWait = maxWait;
        this._maxIdle = maxIdle;
        this._testOnBorrow = testOnBorrow;
        this._testOnReturn = testOnReturn;
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        this._testWhileIdle = testWhileIdle;
        this._poolMap = new HashMap();
        this._activeMap = new HashMap();
        this._poolList = new CursorableLinkedList();
        if (this._timeBetweenEvictionRunsMillis > 0L) {
            this._evictor = new Evictor();
            Thread t = new Thread(this._evictor);
            t.setDaemon(true);
            t.start();
        }
    }

    public int getMaxActive() {
        return this._maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxActive(int maxActive) {
        this._maxActive = maxActive;
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            this.notifyAll();
        }
    }

    public byte getWhenExhaustedAction() {
        return this._whenExhaustedAction;
    }

    public synchronized void setWhenExhaustedAction(byte whenExhaustedAction) {
        switch (whenExhaustedAction) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = whenExhaustedAction;
                this.notifyAll();
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + whenExhaustedAction + " not recognized.");
            }
        }
    }

    public synchronized long getMaxWait() {
        return this._maxWait;
    }

    public synchronized void setMaxWait(long maxWait) {
        this._maxWait = maxWait;
    }

    public int getMaxIdle() {
        return this._maxIdle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxIdle(int maxIdle) {
        this._maxIdle = maxIdle;
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            this.notifyAll();
        }
    }

    public boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this._testOnBorrow = testOnBorrow;
    }

    public boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this._testOnReturn = testOnReturn;
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        if (this._timeBetweenEvictionRunsMillis > 0L && timeBetweenEvictionRunsMillis <= 0L) {
            this._evictor.cancel();
            this._evictor = null;
            this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        } else if (this._timeBetweenEvictionRunsMillis <= 0L && timeBetweenEvictionRunsMillis > 0L) {
            this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
            this._evictor = new Evictor();
            Thread t = new Thread(this._evictor);
            t.setDaemon(true);
            t.start();
        } else {
            this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        }
    }

    public int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this._testWhileIdle = testWhileIdle;
    }

    public synchronized void setConfig(Config conf) {
        this.setMaxIdle(conf.maxIdle);
        this.setMaxActive(conf.maxActive);
        this.setMaxWait(conf.maxWait);
        this.setWhenExhaustedAction(conf.whenExhaustedAction);
        this.setTestOnBorrow(conf.testOnBorrow);
        this.setTestOnReturn(conf.testOnReturn);
        this.setTestWhileIdle(conf.testWhileIdle);
        this.setNumTestsPerEvictionRun(conf.numTestsPerEvictionRun);
        this.setMinEvictableIdleTimeMillis(conf.minEvictableIdleTimeMillis);
        this.setTimeBetweenEvictionRunsMillis(conf.timeBetweenEvictionRunsMillis);
    }

    public synchronized Object borrowObject(Object key) throws Exception {
        ObjectTimestampPair pair;
        long starttime = System.currentTimeMillis();
        block11: while (true) {
            CursorableLinkedList pool;
            if (null == (pool = (CursorableLinkedList)this._poolMap.get(key))) {
                pool = new CursorableLinkedList();
                this._poolMap.put(key, pool);
                this._poolList.add(key);
            }
            pair = null;
            try {
                pair = (ObjectTimestampPair)pool.removeFirst();
                if (null != pair) {
                    --this._totalIdle;
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            if (null == pair) {
                Object obj;
                int active = 0;
                Integer act = (Integer)this._activeMap.get(key);
                if (null != act) {
                    active = act;
                }
                if (this._maxActive <= 0 || active < this._maxActive) {
                    obj = this._factory.makeObject(key);
                    pair = new ObjectTimestampPair(obj);
                } else {
                    switch (this._whenExhaustedAction) {
                        case 2: {
                            obj = this._factory.makeObject(key);
                            pair = new ObjectTimestampPair(obj);
                            break;
                        }
                        case 0: {
                            throw new NoSuchElementException();
                        }
                        case 1: {
                            try {
                                if (this._maxWait <= 0L) {
                                    this.wait();
                                } else {
                                    this.wait(this._maxWait);
                                }
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (this._maxWait <= 0L || System.currentTimeMillis() - starttime < this._maxWait) continue block11;
                            throw new NoSuchElementException("Timeout waiting for idle object");
                        }
                        default: {
                            throw new IllegalArgumentException("whenExhaustedAction " + this._whenExhaustedAction + " not recognized.");
                        }
                    }
                }
            }
            this._factory.activateObject(key, pair.value);
            if (!this._testOnBorrow || this._factory.validateObject(key, pair.value)) break;
            try {
                this._factory.passivateObject(key, pair.value);
            }
            catch (Exception e) {
                // empty catch block
            }
            this._factory.destroyObject(key, pair.value);
        }
        Integer active = (Integer)this._activeMap.get(key);
        if (null == active) {
            this._activeMap.put(key, new Integer(1));
        } else {
            this._activeMap.put(key, new Integer(active + 1));
        }
        ++this._totalActive;
        return pair.value;
    }

    public synchronized void clear() {
        Iterator keyiter = this._poolList.iterator();
        while (keyiter.hasNext()) {
            Object key = keyiter.next();
            CursorableLinkedList list = (CursorableLinkedList)this._poolMap.get(key);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                try {
                    this._factory.destroyObject(key, ((ObjectTimestampPair)it.next()).value);
                }
                catch (Exception e) {
                    // empty catch block
                }
                it.remove();
            }
        }
        this._poolMap.clear();
        this._poolList.clear();
        this._totalIdle = 0;
        this.notifyAll();
    }

    public synchronized void clear(Object key) {
        CursorableLinkedList pool = (CursorableLinkedList)this._poolMap.remove(key);
        if (null == pool) {
            return;
        }
        this._poolList.remove(key);
        Iterator it = pool.iterator();
        while (it.hasNext()) {
            try {
                this._factory.destroyObject(key, ((ObjectTimestampPair)it.next()).value);
            }
            catch (Exception e) {
                // empty catch block
            }
            it.remove();
            --this._totalIdle;
        }
        this.notifyAll();
    }

    public int getNumActive() {
        return this._totalActive;
    }

    public int getNumIdle() {
        return this._totalIdle;
    }

    public synchronized int getNumActive(Object key) {
        try {
            return (Integer)this._activeMap.get(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public synchronized int getNumIdle(Object key) {
        try {
            return ((CursorableLinkedList)this._poolMap.get(key)).size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object key, Object obj) throws Exception {
        block21: {
            CursorableLinkedList pool = null;
            GenericKeyedObjectPool genericKeyedObjectPool = this;
            synchronized (genericKeyedObjectPool) {
                pool = (CursorableLinkedList)this._poolMap.get(key);
                if (null == pool) {
                    pool = new CursorableLinkedList();
                    this._poolMap.put(key, pool);
                    this._poolList.add(key);
                }
            }
            boolean success = true;
            if (this._testOnReturn && !this._factory.validateObject(key, obj)) {
                success = false;
                try {
                    this._factory.destroyObject(key, obj);
                }
                catch (Exception e) {}
            } else {
                try {
                    this._factory.passivateObject(key, obj);
                }
                catch (Exception e) {
                    success = false;
                }
            }
            boolean shouldDestroy = false;
            GenericKeyedObjectPool genericKeyedObjectPool2 = this;
            synchronized (genericKeyedObjectPool2) {
                --this._totalActive;
                Integer active = (Integer)this._activeMap.get(key);
                if (null != active) {
                    if (active <= 1) {
                        this._activeMap.remove(key);
                    } else {
                        this._activeMap.put(key, new Integer(active - 1));
                    }
                }
                if (this._maxIdle > 0 && pool.size() >= this._maxIdle) {
                    shouldDestroy = true;
                } else if (success) {
                    pool.addFirst((Object)new ObjectTimestampPair(obj));
                    ++this._totalIdle;
                }
                this.notifyAll();
            }
            if (!shouldDestroy) break block21;
            try {
                this._factory.destroyObject(key, obj);
            }
            catch (Exception e) {}
        }
    }

    public synchronized void invalidateObject(Object key, Object obj) throws Exception {
        --this._totalActive;
        Integer active = (Integer)this._activeMap.get(key);
        if (null != active) {
            if (active <= 1) {
                this._activeMap.remove(key);
            } else {
                this._activeMap.put(key, new Integer(active - 1));
            }
        }
        this._factory.destroyObject(key, obj);
        this.notifyAll();
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._poolList = null;
        this._poolMap = null;
        this._activeMap = null;
        if (null != this._evictionCursor) {
            this._evictionCursor.close();
            this._evictionCursor = null;
        }
        if (null != this._evictionKeyCursor) {
            this._evictionKeyCursor.close();
            this._evictionKeyCursor = null;
        }
        if (null != this._evictor) {
            this._evictor.cancel();
            this._evictor = null;
        }
    }

    public synchronized void setFactory(KeyedPoolableObjectFactory factory) throws IllegalStateException {
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = factory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void evict() throws Exception {
        Object key = null;
        int i = 0;
        int m = this.getNumTests();
        while (i < m) {
            block23: {
                block26: {
                    ObjectTimestampPair pair;
                    block27: {
                        block24: {
                            block25: {
                                if (this._poolMap.size() <= 0) break block23;
                                if (null == this._evictionKeyCursor) {
                                    this._evictionKeyCursor = this._poolList.cursor();
                                    key = null;
                                    if (null != this._evictionCursor) {
                                        this._evictionCursor.close();
                                        this._evictionCursor = null;
                                    }
                                }
                                if (null != this._evictionCursor) break block24;
                                if (this._evictionKeyCursor.hasNext()) break block25;
                                if (null != this._evictionKeyCursor) {
                                    this._evictionKeyCursor.close();
                                    this._evictionKeyCursor = this._poolList.cursor();
                                    if (null != this._evictionCursor) {
                                        this._evictionCursor.close();
                                        this._evictionCursor = null;
                                    }
                                }
                                break block23;
                            }
                            key = this._evictionKeyCursor.next();
                            CursorableLinkedList pool = (CursorableLinkedList)this._poolMap.get(key);
                            this._evictionCursor = pool.cursor(pool.size());
                        }
                        if (!this._evictionCursor.hasPrevious()) break block26;
                        pair = (ObjectTimestampPair)this._evictionCursor.previous();
                        if (this._minEvictableIdleTimeMillis <= 0L || System.currentTimeMillis() - pair.tstamp <= this._minEvictableIdleTimeMillis) break block27;
                        try {
                            this._evictionCursor.remove();
                            --this._totalIdle;
                            this._factory.destroyObject(key, pair.value);
                            if (((CursorableLinkedList)this._poolMap.get(key)).isEmpty()) {
                                this._poolMap.remove(key);
                                this._poolList.remove(key);
                            }
                            break block23;
                        }
                        catch (Exception e) {}
                        break block23;
                    }
                    if (!this._testWhileIdle) break block23;
                    boolean active = false;
                    try {
                        this._factory.activateObject(key, pair.value);
                        active = true;
                    }
                    catch (Exception e) {
                        this._evictionCursor.remove();
                        try {
                            this._factory.passivateObject(key, pair.value);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        this._factory.destroyObject(key, pair.value);
                    }
                    if (!active) break block23;
                    if (!this._factory.validateObject(key, pair.value)) {
                        try {
                            this._evictionCursor.remove();
                            --this._totalIdle;
                            try {
                                this._factory.passivateObject(key, pair.value);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            this._factory.destroyObject(key, pair.value);
                            if (((CursorableLinkedList)this._poolMap.get(key)).isEmpty()) {
                                this._poolMap.remove(key);
                                this._poolList.remove(key);
                            }
                            break block23;
                        }
                        catch (Exception e) {}
                        break block23;
                    } else {
                        try {
                            this._factory.passivateObject(key, pair.value);
                        }
                        catch (Exception e) {
                            this._evictionCursor.remove();
                            --this._totalIdle;
                            this._factory.destroyObject(key, pair.value);
                            if (((CursorableLinkedList)this._poolMap.get(key)).isEmpty()) {
                                this._poolMap.remove(key);
                                this._poolList.remove(key);
                            }
                            break block23;
                        }
                    }
                }
                if (this._evictionCursor != null) {
                    this._evictionCursor.close();
                    this._evictionCursor = null;
                }
            }
            ++i;
        }
    }

    synchronized String debugInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("Active: ").append(this.getNumActive()).append("\n");
        buf.append("Idle: ").append(this.getNumIdle()).append("\n");
        Iterator it = this._poolList.iterator();
        while (it.hasNext()) {
            buf.append("\t").append(this._poolMap.get(it.next())).append("\n");
        }
        return buf.toString();
    }

    private int getNumTests() {
        if (this._numTestsPerEvictionRun >= 0) {
            return this._numTestsPerEvictionRun;
        }
        return (int)Math.ceil((double)this._totalIdle / Math.abs((double)this._numTestsPerEvictionRun));
    }

    public static class Config {
        public int maxIdle = 8;
        public int maxActive = 8;
        public long maxWait = -1L;
        public byte whenExhaustedAction = 1;
        public boolean testOnBorrow = false;
        public boolean testOnReturn = false;
        public boolean testWhileIdle = false;
        public long timeBetweenEvictionRunsMillis = -1L;
        public int numTestsPerEvictionRun = 3;
        public long minEvictableIdleTimeMillis = 1800000L;
    }

    class Evictor
    implements Runnable {
        protected boolean _cancelled = false;

        Evictor() {
        }

        void cancel() {
            this._cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this._cancelled) {
                long sleeptime = 0L;
                GenericKeyedObjectPool genericKeyedObjectPool = GenericKeyedObjectPool.this;
                synchronized (genericKeyedObjectPool) {
                    sleeptime = GenericKeyedObjectPool.this._timeBetweenEvictionRunsMillis;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(sleeptime);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    GenericKeyedObjectPool.this.evict();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            GenericKeyedObjectPool genericKeyedObjectPool = GenericKeyedObjectPool.this;
            synchronized (genericKeyedObjectPool) {
                if (null != GenericKeyedObjectPool.this._evictionCursor) {
                    GenericKeyedObjectPool.this._evictionCursor.close();
                    GenericKeyedObjectPool.this._evictionCursor = null;
                }
                if (null != GenericKeyedObjectPool.this._evictionKeyCursor) {
                    GenericKeyedObjectPool.this._evictionKeyCursor.close();
                    GenericKeyedObjectPool.this._evictionKeyCursor = null;
                }
            }
        }
    }

    class ObjectTimestampPair {
        Object value;
        long tstamp;

        ObjectTimestampPair(Object val) {
            this.value = val;
            this.tstamp = System.currentTimeMillis();
        }

        ObjectTimestampPair(Object val, long time) {
            this.value = val;
            this.tstamp = time;
        }

        public String toString() {
            return this.value + ";" + this.tstamp;
        }
    }
}

