/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imr.AdminPackage.DuplicateServerName;
import org.jacorb.imr.AdminPackage.FileOpFailed;
import org.jacorb.imr.AdminPackage.IllegalServerName;
import org.jacorb.imr.AdminPackage.UnknownHostName;
import org.jacorb.imr.HostInfo;
import org.jacorb.imr.ImRHostInfo;
import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.ImRPOAInfo;
import org.jacorb.imr.ImRServerInfo;
import org.jacorb.imr.ImplementationRepositoryPOA;
import org.jacorb.imr.RegistrationPackage.DuplicatePOAName;
import org.jacorb.imr.RegistrationPackage.IllegalHostName;
import org.jacorb.imr.RegistrationPackage.IllegalPOAName;
import org.jacorb.imr.RegistrationPackage.InvalidSSDRef;
import org.jacorb.imr.ServerInfo;
import org.jacorb.imr.ServerStartupFailed;
import org.jacorb.imr.ServerTable;
import org.jacorb.imr.UnknownServerName;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.LocateReplyReceiver;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.dns.DNSLookup;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyInputStream;
import org.jacorb.orb.giop.LocateRequestInputStream;
import org.jacorb.orb.giop.LocateRequestOutputStream;
import org.jacorb.orb.giop.MessageReceptorPool;
import org.jacorb.orb.giop.NoBiDirServerReplyListener;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.ServerGIOPConnection;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.ETF.Profile;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.IOP.IOR;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class ImplementationRepositoryImpl
extends ImplementationRepositoryPOA {
    private ORB orb;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    private String iorFile = null;
    private File table_file;
    private ServerTable server_table;
    private File table_file_backup;
    private SocketListener listener;
    private Thread listenerThread;
    private int object_activation_retries = 5;
    private int object_activation_sleep = 50;
    private boolean allow_auto_register = false;
    private boolean check_object_liveness = false;
    private int connection_timeout = 2000;
    private long poaActivationTimeout = 120000L;
    private WriteThread wt;
    private boolean updatePending;
    private Shutdown shutdownThread;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;

    public ImplementationRepositoryImpl(ORB oRB) {
        this.orb = oRB;
        this.shutdownThread = new Shutdown();
        this.shutdownThread.setDaemon(true);
        this.shutdownThread.setName("Shutdown Thread");
        this.addShutdownHook(this.shutdownThread);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        java.lang.Object object;
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.imr");
        String string = "table.dat";
        String string2 = this.configuration.getAttribute("jacorb.imr.table_file", string);
        if (string2 == string && this.logger.isWarnEnabled()) {
            this.logger.warn("No file for the server table specified! Please configure the property jacorb.imr.table_file!");
            this.logger.warn("Will create \"table.dat\" in current directory, if necessary");
        }
        this.table_file = new File(string2);
        boolean bl = false;
        if (!this.table_file.exists()) {
            bl = true;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Table file " + string2 + " does not exist - autocreating it.");
            }
            try {
                this.table_file.createNewFile();
            }
            catch (IOException iOException) {
                throw new ConfigurationException("Failed to create table file", (Throwable)iOException);
            }
        } else {
            if (this.table_file.isDirectory()) {
                throw new ConfigurationException("The table file is a directory! Please check " + this.table_file.getAbsolutePath());
            }
            if (!this.table_file.canRead()) {
                throw new ConfigurationException("The table file is not readable! Please check " + this.table_file.getAbsolutePath());
            }
            if (!this.table_file.canWrite()) {
                throw new ConfigurationException("The table file is not writable! Please check " + this.table_file.getAbsolutePath());
            }
        }
        try {
            if (bl) {
                this.server_table = new ServerTable();
                this.save_server_table(this.table_file);
            } else {
                try {
                    object = new ObjectInputStream(new FileInputStream(this.table_file));
                    this.server_table = (ServerTable)((ObjectInputStream)object).readObject();
                    ((ObjectInputStream)object).close();
                }
                catch (Exception exception) {
                    this.logger.debug("Failed to read ServerTable", (Throwable)exception);
                    this.server_table = new ServerTable();
                    this.save_server_table(this.table_file);
                }
            }
        }
        catch (FileOpFailed fileOpFailed) {
            this.logger.debug("Failed to read ServerTable", (Throwable)fileOpFailed);
        }
        this.iorFile = this.configuration.getAttribute("jacorb.imr.ior_file");
        object = this.configuration.getAttribute("jacorb.imr.backup_file", "");
        if (((String)object).length() == 0) {
            this.logger.warn("No backup file specified!. No backup file will be created");
        }
        if (((String)object).length() > 0) {
            this.table_file_backup = new File((String)object);
            if (!this.table_file_backup.exists()) {
                bl = true;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Backup file " + (String)object + " does not exist - autocreating it.");
                }
                try {
                    this.table_file_backup.createNewFile();
                }
                catch (IOException iOException) {
                    throw new ConfigurationException("Failed to create backup file", (Throwable)iOException);
                }
            } else {
                if (this.table_file_backup.isDirectory()) {
                    throw new ConfigurationException("The backup file is a directory! Please check " + this.table_file_backup.getAbsolutePath());
                }
                if (!this.table_file_backup.canRead()) {
                    throw new ConfigurationException("The backup file is not readable! Please check " + this.table_file_backup.getAbsolutePath());
                }
                if (!this.table_file_backup.canWrite()) {
                    throw new ConfigurationException("The backup file is not writable! Please check " + this.table_file_backup.getAbsolutePath());
                }
            }
        }
        this.object_activation_retries = this.configuration.getAttributeAsInteger("jacorb.imr.object_activation_retries", 5);
        this.object_activation_sleep = this.configuration.getAttributeAsInteger("jacorb.imr.object_activation_sleep", 50);
        this.allow_auto_register = this.configuration.getAttributeAsBoolean("jacorb.imr.allow_auto_register", false);
        this.check_object_liveness = this.configuration.getAttributeAsBoolean("jacorb.imr.check_object_liveness", false);
        this.connection_timeout = this.configuration.getAttributeAsInteger("jacorb.imr.connection_timeout", 2000);
        this.poaActivationTimeout = this.configuration.getAttributeAsInteger("jacorb.imr.timeout", 120000);
        this.listener = new SocketListener();
        this.listener.configure((Configuration)this.configuration);
        this.listenerThread = new Thread(this.listener);
        this.listenerThread.setPriority(10);
        this.listenerThread.start();
        this.wt = new WriteThread();
        this.wt.setName("IMR Write Thread");
        this.wt.setDaemon(true);
        this.wt.start();
    }

    public String getIORFile() {
        return this.iorFile;
    }

    public void set_server_down(String string) throws UnknownServerName {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ImR: server " + string + " is going down... ");
        }
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.setDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_poa(String string, String string2, String string3, int n) throws IllegalPOAName, DuplicatePOAName, UnknownServerName {
        java.lang.Object object;
        ImRServerInfo imRServerInfo = null;
        ImRPOAInfo imRPOAInfo = null;
        boolean bl = false;
        this.updatePending = true;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ImR: registering poa " + string + " for server: " + string2 + " on " + string3);
        }
        if (this.allow_auto_register && !this.server_table.hasServer(string2)) {
            try {
                this.register_server(string2, "", "");
            }
            catch (IllegalServerName illegalServerName) {
            }
            catch (DuplicateServerName duplicateServerName) {
                // empty catch block
            }
        }
        imRServerInfo = this.server_table.getServer(string2);
        imRPOAInfo = this.server_table.getPOA(string);
        if (imRPOAInfo == null) {
            imRPOAInfo = new ImRPOAInfo(string, string3, n, imRServerInfo, this.poaActivationTimeout);
            imRServerInfo.addPOA(imRPOAInfo);
            this.server_table.putPOA(string, imRPOAInfo);
            this.logger.debug("ImR: new poa registered");
        } else {
            if (imRPOAInfo.active || !string2.equals(imRPOAInfo.server.name)) {
                object = imRPOAInfo.name.getBytes();
                byte[] byArray = new byte[((byte[])object).length + 1];
                System.arraycopy(object, 0, byArray, 0, ((byte[])object).length);
                byArray[((byte[])object).length] = 47;
                if (imRPOAInfo.host.equals(string3) && imRPOAInfo.port == n) {
                    bl = true;
                } else {
                    boolean bl2 = bl = !this.checkServerActive(imRPOAInfo.host, imRPOAInfo.port, byArray);
                }
                if (!bl) {
                    throw new DuplicatePOAName("POA " + string + " has already been registered " + "for server " + imRPOAInfo.server.name);
                }
                this.logger.debug("ImR: Remapping server/port");
            }
            imRPOAInfo.reactivate(string3, n);
            this.logger.debug("ImR: register_poa, reactivated");
        }
        try {
            WriteThread writeThread = this.wt;
            object = writeThread;
            synchronized (writeThread) {
                this.wt.notify();
                // ** MonitorExit[var8_10 /* !! */ ] (shouldn't be in output)
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            this.logger.debug("Caught Exception", (Throwable)illegalMonitorStateException);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_host(HostInfo hostInfo) throws IllegalHostName, InvalidSSDRef {
        if (hostInfo.name == null || hostInfo.name.length() == 0) {
            throw new IllegalHostName(hostInfo.name);
        }
        try {
            hostInfo.ssd_ref.get_system_load();
        }
        catch (Exception exception) {
            this.logger.debug("Caught Exception", (Throwable)exception);
            throw new InvalidSSDRef();
        }
        this.updatePending = true;
        this.server_table.putHost(hostInfo.name, new ImRHostInfo(hostInfo));
        try {
            WriteThread writeThread = this.wt;
            synchronized (writeThread) {
                this.wt.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            this.logger.debug("Caught Exception", (Throwable)illegalMonitorStateException);
        }
    }

    public ImRInfo get_imr_info() {
        return new ImRInfo(this.listener.getAddress(), this.listener.getPort());
    }

    public HostInfo[] list_hosts() {
        return this.server_table.getHosts();
    }

    public ServerInfo[] list_servers() {
        ServerInfo[] serverInfoArray;
        if (this.check_object_liveness) {
            this.logger.debug("ImR: Checking servers");
            serverInfoArray = this.server_table.getServers();
            for (int i = 0; i < serverInfoArray.length; ++i) {
                if (!serverInfoArray[i].active || serverInfoArray[i].poas.length <= 0) continue;
                byte[] byArray = serverInfoArray[i].poas[0].name.getBytes();
                byte[] byArray2 = new byte[byArray.length + 1];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray2[byArray.length] = 47;
                if (this.checkServerActive(serverInfoArray[i].poas[0].host, serverInfoArray[i].poas[0].port, byArray2)) continue;
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ImR: Setting server " + serverInfoArray[i].name + " down");
                    }
                    this.server_table.getServer(serverInfoArray[i].name).setDown();
                    serverInfoArray[i].active = false;
                    continue;
                }
                catch (UnknownServerName unknownServerName) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("ImR: Internal error - unknown server " + serverInfoArray[i].name, (Throwable)unknownServerName);
                }
            }
        } else {
            serverInfoArray = this.server_table.getServers();
        }
        return serverInfoArray;
    }

    public ServerInfo get_server_info(String string) throws UnknownServerName {
        return this.server_table.getServer(string).toServerInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_server(String string, String string2, String string3) throws IllegalServerName, DuplicateServerName {
        this.updatePending = true;
        ImRServerInfo imRServerInfo = new ImRServerInfo(string, string3, string2);
        this.server_table.putServer(string, imRServerInfo);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ImR: server " + string + " on " + string3 + " registered");
        }
        try {
            WriteThread writeThread = this.wt;
            synchronized (writeThread) {
                this.wt.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            this.logger.debug("Caught Exception", (Throwable)illegalMonitorStateException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister_server(String string) throws UnknownServerName {
        this.updatePending = true;
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        String[] stringArray = imRServerInfo.getPOANames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.server_table.removePOA(stringArray[i]);
        }
        this.server_table.removeServer(string);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ImR: server " + string + " unregistered");
        }
        try {
            WriteThread writeThread = this.wt;
            synchronized (writeThread) {
                this.wt.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            this.logger.debug("Caught Exception", (Throwable)illegalMonitorStateException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void edit_server(String string, String string2, String string3) throws UnknownServerName {
        this.updatePending = true;
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.command = string2;
        imRServerInfo.host = string3;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ImR: server " + string + " edited");
        }
        try {
            WriteThread writeThread = this.wt;
            synchronized (writeThread) {
                this.wt.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            this.logger.debug("Caught Exception", (Throwable)illegalMonitorStateException);
        }
    }

    public void hold_server(String string) throws UnknownServerName {
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.holding = true;
    }

    public void release_server(String string) throws UnknownServerName {
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.release();
    }

    public void start_server(String string) throws UnknownServerName, ServerStartupFailed {
        this.restartServer(this.server_table.getServer(string));
    }

    public void save_server_table() throws FileOpFailed {
        if (this.table_file_backup != null) {
            this.save_server_table(this.table_file_backup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean bl) {
        Runnable runnable = this.wt;
        synchronized (runnable) {
            this.wt.shutdown();
            this.wt.notify();
        }
        if (this.listener != null) {
            this.listener.stopListening(bl);
            try {
                runnable = this.listener;
                synchronized (runnable) {
                    this.listenerThread.join(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                this.logger.debug("Caught Exception", (Throwable)interruptedException);
            }
        }
        try {
            this.save_server_table();
        }
        catch (FileOpFailed fileOpFailed) {
            this.logger.debug("ImR: Failed to save backup table.", (Throwable)fileOpFailed);
        }
        this.logger.debug("ImR: Finished shutting down");
    }

    public void unregister_host(String string) throws UnknownHostName {
        if (this.server_table.removeHost(string) == null) {
            throw new UnknownHostName(string);
        }
    }

    private void save_server_table(File file) throws FileOpFailed {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            this.server_table.table_lock.gainExclusiveLock();
            objectOutputStream.writeObject(this.server_table);
            this.server_table.table_lock.releaseExclusiveLock();
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            this.logger.debug("Caught Exception", (Throwable)exception);
            throw new FileOpFailed();
        }
        this.updatePending = false;
    }

    public static void usage() {
        System.out.println("Usage: The following properties are useful in conjunction with the \nImplementationRepository:");
        System.out.println("\t \"jacorb.imr.endpoint_host\" Address to listen on for requests");
        System.out.println("\t \"jacorb.imr.endpoint_port\" Port to listen on for requests");
        System.out.println("\t \"jacorb.imr.table_file\" The file to store the server table into");
        System.out.println("\t \"jacorb.imr.backup_file\" The file to store the server table backup into");
        System.out.println("\t \"jacorb.imr.ior_file\" The file to store the ImRs IOR into");
        System.out.println("\t \"jacorb.imr.allow_auto_register\" if set to \"on\", servers that don't \n\talready have an entry on their first call to the imr, will get \n\tautomatically registered. Otherwise, an UnknownServer exception \n\tis thrown.");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        Properties properties = ObjectUtil.argsToProps(stringArray);
        properties.setProperty("jacorb.implname", "the_ImR");
        properties.setProperty("jacorb.use_imr", "off");
        try {
            ORB oRB = ORB.init(stringArray, properties);
            ImplementationRepositoryImpl implementationRepositoryImpl = new ImplementationRepositoryImpl(oRB);
            implementationRepositoryImpl.configure((Configuration)((org.jacorb.orb.ORB)oRB).getConfiguration());
            POA pOA = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
            pOA.the_POAManager().activate();
            Policy[] policyArray = new Policy[]{pOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), pOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
            POA pOA2 = pOA.create_POA("ImRPOA", pOA.the_POAManager(), policyArray);
            for (int i = 0; i < policyArray.length; ++i) {
                policyArray[i].destroy();
            }
            byte[] byArray = "ImR".getBytes();
            pOA2.activate_object_with_id(byArray, implementationRepositoryImpl);
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(new File(implementationRepositoryImpl.getIORFile())));
            printWriter.println(oRB.object_to_string(pOA2.servant_to_reference(implementationRepositoryImpl)));
            printWriter.flush();
            printWriter.close();
            oRB.run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ImplementationRepositoryImpl.usage();
            System.exit(1);
        }
    }

    private void restartServer(ImRServerInfo imRServerInfo) throws ServerStartupFailed {
        imRServerInfo.awaitRelease();
        if (!imRServerInfo.active) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ImR: server " + imRServerInfo.name + " is down");
            }
            if (imRServerInfo.command.length() == 0) {
                throw new ServerStartupFailed("Server " + imRServerInfo.name + " can't be restarted because" + " of missing startup command");
            }
            if (imRServerInfo.shouldBeRestarted()) {
                try {
                    ImRHostInfo imRHostInfo = this.server_table.getHost(imRServerInfo.host);
                    if (imRHostInfo == null) {
                        throw new ServerStartupFailed("Unknown host: >>" + imRServerInfo.host + "<<");
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ImR: will restart " + imRServerInfo.name);
                    }
                    imRHostInfo.startServer(imRServerInfo.command, this.orb);
                }
                catch (ServerStartupFailed serverStartupFailed) {
                    imRServerInfo.setNotRestarting();
                    throw serverStartupFailed;
                }
                catch (Exception exception) {
                    imRServerInfo.setNotRestarting();
                    this.logger.debug("Caught Exception", (Throwable)exception);
                    this.server_table.removeHost(imRServerInfo.host);
                    throw new ServerStartupFailed("Failed to connect to host!");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("ImR: somebody else is restarting " + imRServerInfo.name);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("ImR: server " + imRServerInfo.name + " is active");
        }
    }

    private void addShutdownHook(Thread thread) {
        Method method = this.getHookMethod("addShutdownHook");
        if (method != null) {
            this.invokeHookMethod(method, thread);
        }
    }

    private Method getHookMethod(String string) {
        Method method = null;
        Class[] classArray = new Class[]{class$java$lang$Thread == null ? (class$java$lang$Thread = ImplementationRepositoryImpl.class$("java.lang.Thread")) : class$java$lang$Thread};
        try {
            method = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = ImplementationRepositoryImpl.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod(string, classArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return method;
    }

    private void invokeHookMethod(Method method, Thread thread) {
        block2: {
            java.lang.Object[] objectArray = new java.lang.Object[]{thread};
            try {
                method.invoke((java.lang.Object)Runtime.getRuntime(), objectArray);
            }
            catch (Throwable throwable) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("Failed to invoke Runtime." + method.getName(), throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkServerActive(String string, int n, byte[] byArray) {
        ClientConnectionManager clientConnectionManager = null;
        IIOPAddress iIOPAddress = null;
        ClientConnection clientConnection = null;
        LocateRequestOutputStream locateRequestOutputStream = null;
        LocateReplyReceiver locateReplyReceiver = null;
        LocateReplyInputStream locateReplyInputStream = null;
        boolean bl = false;
        clientConnectionManager = ((org.jacorb.orb.ORB)this.orb).getClientConnectionManager();
        try {
            iIOPAddress = new IIOPAddress(string, n);
            iIOPAddress.configure((Configuration)this.configuration);
            IIOPProfile iIOPProfile = new IIOPProfile(iIOPAddress, byArray);
            iIOPProfile.configure((Configuration)this.configuration);
            clientConnection = clientConnectionManager.getConnection(iIOPProfile);
        }
        catch (ConfigurationException configurationException) {
            this.logger.debug("Failed to configure", (Throwable)configurationException);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Pinging " + string + " / " + n);
        }
        try {
            locateRequestOutputStream = new LocateRequestOutputStream(byArray, clientConnection.getId(), 2);
            locateReplyReceiver = new LocateReplyReceiver((org.jacorb.orb.ORB)this.orb);
            clientConnection.sendRequest(locateRequestOutputStream, locateReplyReceiver, locateRequestOutputStream.getRequestId(), true);
            locateReplyInputStream = locateReplyReceiver.getReply();
            switch (locateReplyInputStream.rep_hdr.locate_status.value()) {
                default: 
            }
            bl = true;
        }
        catch (Throwable throwable) {
            this.logger.debug("Caught Exception", throwable);
            bl = false;
        }
        finally {
            clientConnectionManager.releaseConnection(clientConnection);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Shutdown
    extends Thread {
        private Shutdown() {
        }

        public synchronized void run() {
            ImplementationRepositoryImpl.this.logger.debug("ImR: Shutting down");
            ImplementationRepositoryImpl.this.shutdown(true);
        }
    }

    private class WriteThread
    extends Thread {
        boolean done;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    ImplementationRepositoryImpl.this.save_server_table(ImplementationRepositoryImpl.this.table_file);
                }
                catch (FileOpFailed fileOpFailed) {
                    ImplementationRepositoryImpl.this.logger.debug("Caught Exception", (Throwable)fileOpFailed);
                }
                if (this.done) break;
                if (ImplementationRepositoryImpl.this.updatePending) continue;
                try {
                    WriteThread writeThread = this;
                    synchronized (writeThread) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ImplementationRepositoryImpl.this.logger.debug("ImR: IMR write thread waking up to save server table... ");
            }
        }

        public void shutdown() {
            this.done = true;
        }
    }

    private class ImRRequestListener
    implements RequestListener {
        public void requestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
            ImplementationRepositoryImpl.this.logger.debug("requestReceived");
            gIOPConnection.incPendingMessages();
            RequestInputStream requestInputStream = new RequestInputStream(ImplementationRepositoryImpl.this.orb, byArray);
            this.replyNewLocation(((org.jacorb.orb.ORB)ImplementationRepositoryImpl.this.orb).mapObjectKey(ParsedIOR.extractObjectKey(requestInputStream.req_hdr.target, (org.jacorb.orb.ORB)ImplementationRepositoryImpl.this.orb)), requestInputStream.req_hdr.request_id, requestInputStream.getGIOPMinor(), gIOPConnection);
        }

        public void locateRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
            gIOPConnection.incPendingMessages();
            LocateRequestInputStream locateRequestInputStream = new LocateRequestInputStream(ImplementationRepositoryImpl.this.orb, byArray);
            this.replyNewLocation(ParsedIOR.extractObjectKey(locateRequestInputStream.req_hdr.target, (org.jacorb.orb.ORB)ImplementationRepositoryImpl.this.orb), locateRequestInputStream.req_hdr.request_id, locateRequestInputStream.getGIOPMinor(), gIOPConnection);
        }

        public void cancelRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        }

        public void fragmentReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        }

        public void connectionClosed() {
        }

        private void replyNewLocation(byte[] byArray, int n, int n2, GIOPConnection gIOPConnection) {
            Object object;
            boolean bl;
            String string = POAUtil.extractImplName(byArray) + '/' + POAUtil.extractPOAName(byArray);
            ImRPOAInfo imRPOAInfo = ImplementationRepositoryImpl.this.server_table.getPOA(string);
            if (imRPOAInfo == null) {
                this.sendSysException(new OBJECT_NOT_EXIST("POA " + string + " unknown"), gIOPConnection, n, n2);
                return;
            }
            ImRServerInfo imRServerInfo = imRPOAInfo.server;
            if (ImplementationRepositoryImpl.this.logger.isDebugEnabled()) {
                ImplementationRepositoryImpl.this.logger.debug("ImR: Looking up: " + imRServerInfo.name);
            }
            boolean bl2 = bl = imRServerInfo.command.length() != 0 && ImplementationRepositoryImpl.this.server_table.getHost(imRServerInfo.host) != null;
            if (imRServerInfo.active && (ImplementationRepositoryImpl.this.check_object_liveness || bl) && !ImplementationRepositoryImpl.this.checkServerActive(imRPOAInfo.host, imRPOAInfo.port, byArray)) {
                imRServerInfo.setDown();
            }
            try {
                ImplementationRepositoryImpl.this.restartServer(imRServerInfo);
            }
            catch (ServerStartupFailed serverStartupFailed) {
                if (ImplementationRepositoryImpl.this.logger.isDebugEnabled()) {
                    ImplementationRepositoryImpl.this.logger.debug("Object (" + imRServerInfo.name + ") on " + imRPOAInfo.host + '/' + imRPOAInfo.port + " not reachable");
                }
                this.sendSysException(new TRANSIENT(serverStartupFailed.reason), gIOPConnection, n, n2);
                return;
            }
            boolean bl3 = imRPOAInfo.active;
            if (!imRPOAInfo.awaitActivation()) {
                this.sendSysException(new TRANSIENT("Timeout exceeded"), gIOPConnection, n, n2);
                return;
            }
            ReplyOutputStream replyOutputStream = new ReplyOutputStream(n, ReplyStatusType_1_2.LOCATION_FORWARD, n2, false, ImplementationRepositoryImpl.this.logger);
            IIOPAddress iIOPAddress = new IIOPAddress(imRPOAInfo.host, (short)imRPOAInfo.port);
            IOR iOR = null;
            try {
                iIOPAddress.configure((Configuration)ImplementationRepositoryImpl.this.configuration);
                object = new IIOPProfile(iIOPAddress, byArray, n2);
                ((IIOPProfile)object).configure((Configuration)ImplementationRepositoryImpl.this.configuration);
                iOR = ParsedIOR.createObjectIOR((Profile)object);
            }
            catch (ConfigurationException configurationException) {
                ImplementationRepositoryImpl.this.logger.debug("Caught exception", (Throwable)configurationException);
            }
            if (!bl3) {
                object = ImplementationRepositoryImpl.this.orb.string_to_object(new ParsedIOR(iOR, (org.jacorb.orb.ORB)ImplementationRepositoryImpl.this.orb, ImplementationRepositoryImpl.this.logger).getIORString());
                for (int i = 0; i < ImplementationRepositoryImpl.this.object_activation_retries; ++i) {
                    try {
                        Thread.sleep(ImplementationRepositoryImpl.this.object_activation_sleep);
                        if (object._non_existent()) continue;
                        break;
                    }
                    catch (Exception exception) {
                        ImplementationRepositoryImpl.this.logger.debug("Caught Exception", (Throwable)exception);
                    }
                }
            }
            try {
                replyOutputStream.write_IOR(iOR);
                if (ImplementationRepositoryImpl.this.logger.isDebugEnabled()) {
                    ImplementationRepositoryImpl.this.logger.debug("ImR: Sending location forward for " + imRServerInfo.name);
                }
                gIOPConnection.sendReply(replyOutputStream);
            }
            catch (IOException iOException) {
                ImplementationRepositoryImpl.this.logger.debug("Caught Exception", (Throwable)iOException);
                this.sendSysException(new UNKNOWN(iOException.toString()), gIOPConnection, n, n2);
            }
        }

        private void sendSysException(SystemException systemException, GIOPConnection gIOPConnection, int n, int n2) {
            ReplyOutputStream replyOutputStream = new ReplyOutputStream(n, ReplyStatusType_1_2.SYSTEM_EXCEPTION, n2, false, ImplementationRepositoryImpl.this.logger);
            SystemExceptionHelper.write(replyOutputStream, systemException);
            try {
                gIOPConnection.sendReply(replyOutputStream);
            }
            catch (IOException iOException) {
                ImplementationRepositoryImpl.this.logger.debug("Caught Exception", (Throwable)iOException);
            }
        }
    }

    private class SocketListener
    implements Runnable {
        private ServerSocket server_socket;
        private int port = 0;
        private String address;
        private int timeout = 0;
        private boolean run = true;
        private boolean wait = false;
        private MessageReceptorPool receptor_pool = MessageReceptorPool.getInstance();
        private RequestListener request_listener = null;
        private ReplyListener reply_listener = null;
        private TransportManager transport_manager = null;

        public SocketListener() {
            this.request_listener = new ImRRequestListener();
            this.reply_listener = new NoBiDirServerReplyListener();
        }

        public void configure(Configuration configuration) throws ConfigurationException {
            try {
                int n = ImplementationRepositoryImpl.this.configuration.getAttributeAsInteger("jacorb.imr.endpoint_port_number", 0);
                String string = ImplementationRepositoryImpl.this.configuration.getAttribute("jacorb.imr.endpoint_host", "");
                this.server_socket = string.length() > 0 ? new ServerSocket(n, 50, InetAddress.getByName(string)) : new ServerSocket(n);
                DNSLookup dNSLookup = new DNSLookup();
                dNSLookup.configure((Configuration)ImplementationRepositoryImpl.this.configuration);
                this.address = string.length() > 0 ? dNSLookup.inverseLookup(InetAddress.getByName(string)) : dNSLookup.inverseLookup(InetAddress.getLocalHost());
                if (this.address == null) {
                    this.address = string.length() > 0 ? string : InetAddress.getLocalHost().toString();
                }
                if (this.address.indexOf("/") >= 0) {
                    this.address = this.address.substring(this.address.indexOf("/") + 1);
                }
                this.port = this.server_socket.getLocalPort();
                if (ImplementationRepositoryImpl.this.logger.isDebugEnabled()) {
                    ImplementationRepositoryImpl.this.logger.debug("ImR Listener at " + this.port + ", " + this.address);
                }
            }
            catch (Exception exception) {
                throw new ConfigurationException("Listener: Couldn't init", (Throwable)exception);
            }
            this.transport_manager = new TransportManager((org.jacorb.orb.ORB)ImplementationRepositoryImpl.this.orb);
            this.transport_manager.configure((Configuration)ImplementationRepositoryImpl.this.configuration);
        }

        public int getPort() {
            return this.port;
        }

        public String getAddress() {
            return this.address;
        }

        public void setTimeout(int n) {
            this.timeout = n;
        }

        public void run() {
            while (this.run) {
                try {
                    Socket socket = this.server_socket.accept();
                    socket.setSoTimeout(this.timeout);
                    ServerIIOPConnection serverIIOPConnection = new ServerIIOPConnection(socket, false);
                    serverIIOPConnection.configure((Configuration)ImplementationRepositoryImpl.this.configuration);
                    ServerGIOPConnection serverGIOPConnection = new ServerGIOPConnection(serverIIOPConnection.get_server_profile(), serverIIOPConnection, this.request_listener, this.reply_listener, null, null);
                    ((GIOPConnection)serverGIOPConnection).configure((Configuration)ImplementationRepositoryImpl.this.configuration);
                    this.receptor_pool.connectionCreated(serverGIOPConnection);
                }
                catch (Exception exception) {
                    if (!this.run) continue;
                    ImplementationRepositoryImpl.this.logger.debug("Caught Exception", (Throwable)exception);
                }
            }
            ImplementationRepositoryImpl.this.orb.shutdown(this.wait);
        }

        public void stopListening(boolean bl) {
            this.run = false;
            this.wait = bl;
            try {
                this.server_socket.close();
            }
            catch (Exception exception) {
                ImplementationRepositoryImpl.this.logger.debug("Caught Exception", (Throwable)exception);
            }
        }
    }
}

