/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imr.util.ImRManager;
import org.jacorb.naming.NamingContextImpl;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer._ServantActivatorLocalBase;

public class NameServer {
    private static ORB orb = null;
    private static org.jacorb.config.Configuration configuration = null;
    private static Logger logger = null;
    private static String fileName = null;
    private static String filePrefix = "_nsdb";
    private static String commandSuffix = "";
    private static int time_out = 0;
    static String name_delimiter = "/";

    public static void configure(Configuration configuration) throws ConfigurationException {
        NameServer.configuration = (org.jacorb.config.Configuration)configuration;
        logger = NameServer.configuration.getNamedLogger("jacorb.naming");
        time_out = NameServer.configuration.getAttributeAsInteger("jacorb.naming.time_out", 0);
        fileName = NameServer.configuration.getAttribute("jacorb.naming.ior_filename", "");
        String string = NameServer.configuration.getAttribute("jacorb.naming.db_dir", "");
        if (!string.equals("")) {
            filePrefix = string + File.separatorChar + filePrefix;
        }
        if (NameServer.configuration.getAttribute("jacorb.use_imr", "off").equals("on")) {
            String string2 = NameServer.configuration.getAttribute("jacorb.java_exec", "") + commandSuffix;
            ImRManager.autoRegisterServer(orb, "StandardNS", string2, ImRManager.getLocalHostName(), true);
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.jacorb.naming.NameServer [-Djacorb.naming.ior_filename=fname] [-Djacorb.naming.time_out=x][-Djacorb.use_imr=on/off][-Djacorb.naming.purge=on/off ]");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        try {
            commandSuffix = " org.jacorb.naming.NameServer";
            Properties properties = ObjectUtil.argsToProps(stringArray);
            Properties properties2 = new Properties();
            properties2.put("jacorb.implname", "StandardNS");
            properties2.put("jacorb.orb.objectKeyMap.NameService", "StandardNS/NameServer-POA/_root");
            properties2.putAll((Map<?, ?>)properties);
            orb = ORB.init(stringArray, properties2);
            org.jacorb.config.Configuration configuration = ((org.jacorb.orb.ORB)orb).getConfiguration();
            NameServer.configure((Configuration)configuration);
            POA pOA = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            Policy[] policyArray = new Policy[]{pOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), pOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), pOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)};
            POA pOA2 = pOA.create_POA("NameServer-POA", pOA.the_POAManager(), policyArray);
            NamingContextImpl.init(orb, pOA);
            NameServantActivatorImpl nameServantActivatorImpl = new NameServantActivatorImpl(orb);
            nameServantActivatorImpl.configure((Configuration)configuration);
            pOA2.set_servant_manager(nameServantActivatorImpl);
            pOA2.the_POAManager().activate();
            for (int i = 0; i < policyArray.length; ++i) {
                policyArray[i].destroy();
            }
            byte[] byArray = new String("_root").getBytes();
            try {
                Object object = pOA2.create_reference_with_id(byArray, "IDL:omg.org/CosNaming/NamingContextExt:1.0");
                if (fileName != null && fileName.length() > 0) {
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(fileName), true);
                    printWriter.println(orb.object_to_string(object));
                    printWriter.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception.getMessage());
            }
            if (logger.isInfoEnabled()) {
                logger.info("NS up");
            }
            if (time_out == 0) {
                orb.run();
            } else {
                Thread.sleep(time_out);
            }
            orb.shutdown(true);
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
            NameServer.usage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static class NameServantActivatorImpl
    extends _ServantActivatorLocalBase {
        private ORB orb = null;
        private org.jacorb.config.Configuration configuration = null;
        private Logger logger = null;

        public NameServantActivatorImpl(ORB oRB) {
            this.orb = oRB;
        }

        public void configure(Configuration configuration) throws ConfigurationException {
            this.configuration = (org.jacorb.config.Configuration)configuration;
            this.logger = this.configuration.getNamedLogger("jacorb.naming.activator");
        }

        public Servant incarnate(byte[] byArray, POA pOA) throws ForwardRequest {
            NamingContextImpl namingContextImpl;
            block12: {
                String string = new String(byArray);
                namingContextImpl = null;
                try {
                    File file = new File(filePrefix + string);
                    if (file.exists()) {
                        FileInputStream fileInputStream;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Reading in context state from file");
                        }
                        if ((fileInputStream = new FileInputStream(file)).available() > 0) {
                            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                            namingContextImpl = (NamingContextImpl)objectInputStream.readObject();
                            objectInputStream.close();
                        }
                        fileInputStream.close();
                    } else if (this.logger.isDebugEnabled()) {
                        this.logger.debug("No naming context state, starting empty");
                    }
                }
                catch (IOException iOException) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("File seems corrupt, starting empty");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logger.error("Could not read object from file, class not found!");
                    System.exit(1);
                }
                if (namingContextImpl == null) {
                    namingContextImpl = new NamingContextImpl();
                }
                namingContextImpl.init(pOA);
                try {
                    namingContextImpl.configure((Configuration)this.configuration);
                }
                catch (ConfigurationException configurationException) {
                    if (!this.logger.isErrorEnabled()) break block12;
                    this.logger.error("ConfigurationException: " + configurationException.getMessage());
                }
            }
            return namingContextImpl;
        }

        public void etherealize(byte[] byArray, POA pOA, Servant servant, boolean bl, boolean bl2) {
            String string = new String(byArray);
            try {
                File file = new File(filePrefix + string);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject((NamingContextImpl)servant);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Saved state for servant " + string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.logger.error("Error opening output file " + filePrefix + string);
            }
        }
    }
}

