/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.ParseException;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.StaticTypeChecker;
import org.jacorb.notification.filter.etcl.StaticTypeException;
import org.jacorb.notification.filter.etcl.TCLCleanUp;
import org.jacorb.notification.filter.etcl.TCLParser;
import org.jacorb.notification.interfaces.Message;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.InvalidConstraint;

public class FilterConstraint {
    private String constraint_;
    private AbstractTCLNode rootNode_;

    public FilterConstraint(AbstractTCLNode abstractTCLNode) {
        this.rootNode_ = abstractTCLNode;
    }

    public FilterConstraint(ConstraintExp constraintExp) throws InvalidConstraint {
        try {
            this.constraint_ = constraintExp.constraint_expr;
            this.rootNode_ = TCLParser.parse(constraintExp.constraint_expr);
            if (this.rootNode_ != null) {
                TCLCleanUp tCLCleanUp = new TCLCleanUp();
                tCLCleanUp.fix(this.rootNode_);
                StaticTypeChecker staticTypeChecker = new StaticTypeChecker();
                staticTypeChecker.check(this.rootNode_);
            }
            return;
        }
        catch (StaticTypeException staticTypeException) {
            throw new InvalidConstraint(staticTypeException.getMessage(), constraintExp);
        }
        catch (ParseException parseException) {
            throw new InvalidConstraint(parseException.getMessage(), constraintExp);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            return;
        }
    }

    public String getConstraint() {
        return this.constraint_;
    }

    public EvaluationResult evaluate(EvaluationContext evaluationContext, Message message) throws EvaluationException {
        if (this.rootNode_ == null) {
            return EvaluationResult.BOOL_TRUE;
        }
        evaluationContext.setCurrentMessage(message);
        EvaluationResult evaluationResult = this.rootNode_.evaluate(evaluationContext);
        return evaluationResult;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<FilterConstraint: ");
        this.rootNode_.printToStringBuffer(stringBuffer);
        stringBuffer.append(" >");
        return stringBuffer.toString();
    }
}

