/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.CollectionsWrapper;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.AbstractProxyConsumerI;
import org.jacorb.notification.servant.ProxyPullConsumerImpl;
import org.jacorb.notification.servant.ProxyPushConsumerImpl;
import org.jacorb.notification.servant.SequenceProxyPullConsumerImpl;
import org.jacorb.notification.servant.SequenceProxyPushConsumerImpl;
import org.jacorb.notification.servant.StructuredProxyPullConsumerImpl;
import org.jacorb.notification.servant.StructuredProxyPushConsumerImpl;
import org.jacorb.notification.util.EventTypeUtil;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.PropertySetListener;
import org.jacorb.orb.ORB;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.Property;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ObtainInfoMode;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.NotifyPublishOperations;
import org.omg.CosNotifyComm.NotifySubscribe;
import org.omg.CosNotifyComm.NotifySubscribeHelper;
import org.omg.CosNotifyComm.NotifySubscribeOperations;

abstract class AbstractProxyConsumer
extends AbstractProxy
implements AbstractProxyConsumerI,
NotifyPublishOperations {
    private static final EventType[] EMPTY_EVENT_TYPE_ARRAY = new EventType[0];
    protected MessageFactory messageFactory_;
    private TaskProcessor taskProcessor_;
    private SynchronizedBoolean isStartTimeSupported_ = new SynchronizedBoolean(true);
    private SynchronizedBoolean isStopTimeSupported_ = new SynchronizedBoolean(true);
    private List subsequentDestinations_;
    private NotifySubscribeOperations proxySubscriptionListener_;
    private NotifySubscribe subscriptionListener_;
    private PropertySetListener reconfigureQoS_ = new PropertySetListener(){

        public void validateProperty(Property[] propertyArray, List list) {
        }

        public void actionPropertySetChanged(PropertySet propertySet) {
            AbstractProxyConsumer.this.configureStartTimeSupported();
            AbstractProxyConsumer.this.configureStopTimeSupported();
        }
    };

    AbstractProxyConsumer(AbstractAdmin abstractAdmin, ChannelContext channelContext) {
        super(abstractAdmin, channelContext);
        this.messageFactory_ = channelContext.getMessageFactory();
        this.subsequentDestinations_ = CollectionsWrapper.singletonList(this.admin_);
        this.taskProcessor_ = channelContext.getTaskProcessor();
    }

    public final List getSubsequentFilterStages() {
        return this.subsequentDestinations_;
    }

    public void preActivate() {
        this.configureStartTimeSupported();
        this.configureStopTimeSupported();
        this.qosSettings_.addPropertySetListener(new String[]{"Priority", "Timeout", "StartTimeSupported", "StopTimeSupported"}, this.reconfigureQoS_);
    }

    private void configureStartTimeSupported() {
        this.isStartTimeSupported_.set(this.qosSettings_.get("StartTimeSupported").extract_boolean());
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set QoS: StartTimeSupported=" + this.isStartTimeSupported_);
        }
    }

    private void configureStopTimeSupported() {
        this.isStopTimeSupported_.set(this.qosSettings_.get("StopTimeSupported").extract_boolean());
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set QoS: StopTimeSupported=" + this.isStopTimeSupported_);
        }
    }

    protected void schedulePullTask(MessageSupplier messageSupplier) {
        try {
            this.getTaskProcessor().scheduleTimedPullTask(messageSupplier);
        }
        catch (InterruptedException interruptedException) {
            this.logger_.fatalError("failed to schedule pull for MessageSupplier", (Throwable)interruptedException);
        }
    }

    protected void checkMessageProperties(Message message) {
    }

    public FilterStage getFirstStage() {
        return this;
    }

    public boolean isTimeOutSupported() {
        return this.isStopTimeSupported_.get();
    }

    public boolean isStartTimeSupported() {
        return this.isStartTimeSupported_.get();
    }

    public final SupplierAdmin MyAdmin() {
        return (SupplierAdmin)this.admin_.activate();
    }

    public final MessageConsumer getMessageConsumer() {
        throw new UnsupportedOperationException();
    }

    public final boolean hasMessageConsumer() {
        return false;
    }

    public void offer_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) throws InvalidEventType {
        this.offerManager_.offer_change(eventTypeArray, eventTypeArray2);
    }

    public EventType[] obtain_subscription_types(ObtainInfoMode obtainInfoMode) {
        EventType[] eventTypeArray = EMPTY_EVENT_TYPE_ARRAY;
        switch (obtainInfoMode.value()) {
            case 1: {
                this.registerListener();
                eventTypeArray = this.subscriptionManager_.obtain_subscription_types();
                break;
            }
            case 0: {
                eventTypeArray = this.subscriptionManager_.obtain_subscription_types();
                this.removeListener();
                break;
            }
            case 3: {
                this.registerListener();
                break;
            }
            case 2: {
                this.removeListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal ObtainInfoMode: ObtainInfoMode." + obtainInfoMode.value());
            }
        }
        return eventTypeArray;
    }

    private void registerListener() {
        NotifySubscribeOperations notifySubscribeOperations;
        if (this.proxySubscriptionListener_ == null && (notifySubscribeOperations = this.getSubscriptionListener()) != null) {
            this.proxySubscriptionListener_ = new NotifySubscribeOperations(){

                public void subscription_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) {
                    try {
                        notifySubscribeOperations.subscription_change(eventTypeArray, eventTypeArray2);
                    }
                    catch (NO_IMPLEMENT nO_IMPLEMENT) {
                        AbstractProxyConsumer.this.logger_.info("disable subscription_change for Supplier", (Throwable)nO_IMPLEMENT);
                        AbstractProxyConsumer.this.removeListener();
                    }
                    catch (InvalidEventType invalidEventType) {
                        if (AbstractProxyConsumer.this.logger_.isDebugEnabled()) {
                            AbstractProxyConsumer.this.logger_.debug("subscription_change(" + EventTypeUtil.toString(eventTypeArray) + ", " + EventTypeUtil.toString(eventTypeArray2) + ") failed", (Throwable)invalidEventType);
                        }
                        AbstractProxyConsumer.this.logger_.error("invalid event type", (Throwable)invalidEventType);
                    }
                }
            };
            this.subscriptionManager_.addListener(this.proxySubscriptionListener_);
        }
    }

    private void removeListener() {
        if (this.proxySubscriptionListener_ != null) {
            this.subscriptionManager_.removeListener(this.proxySubscriptionListener_);
            this.proxySubscriptionListener_ = null;
        }
    }

    protected void connectClient(Object object) {
        super.connectClient(object);
        try {
            this.subscriptionListener_ = NotifySubscribeHelper.narrow(object);
            this.logger_.debug("successfully narrowed connecting Supplier to NotifySubscribe");
        }
        catch (Throwable throwable) {
            this.logger_.info("connecting Supplier does not support subscription_change");
        }
    }

    final NotifySubscribeOperations getSubscriptionListener() {
        return this.subscriptionListener_;
    }

    static AbstractProxy newProxyPushConsumer(AbstractAdmin abstractAdmin, ClientType clientType) {
        AbstractProxyConsumer abstractProxyConsumer;
        switch (clientType.value()) {
            case 0: {
                abstractProxyConsumer = new ProxyPushConsumerImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 1: {
                abstractProxyConsumer = new StructuredProxyPushConsumerImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 2: {
                abstractProxyConsumer = new SequenceProxyPushConsumerImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            default: {
                throw new BAD_PARAM("Invalid ClientType: ClientType." + clientType.value());
            }
        }
        abstractProxyConsumer.configure((Configuration)((ORB)abstractAdmin.getORB()).getConfiguration());
        return abstractProxyConsumer;
    }

    static AbstractProxy newProxyPullConsumer(AbstractAdmin abstractAdmin, ClientType clientType) {
        AbstractProxyConsumer abstractProxyConsumer;
        switch (clientType.value()) {
            case 0: {
                abstractProxyConsumer = new ProxyPullConsumerImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 1: {
                abstractProxyConsumer = new StructuredProxyPullConsumerImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 2: {
                abstractProxyConsumer = new SequenceProxyPullConsumerImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            default: {
                throw new BAD_PARAM("Invalid ClientType: ClientType." + clientType.value());
            }
        }
        abstractProxyConsumer.configure((Configuration)((ORB)abstractAdmin.getORB()).getConfiguration());
        return abstractProxyConsumer;
    }
}

