/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.security;

import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import org.jboss.security.SecurityAssociation;

class GetPrincipalInfoAction {
    GetPrincipalInfoAction() {
    }

    static Principal getPrincipal() {
        Principal principal = (Principal)AccessController.doPrivileged(GetPrincipalAction.ACTION);
        return principal;
    }

    static char[] getCredential() {
        char[] credential = (char[])AccessController.doPrivileged(GetCredentialAction.ACTION);
        return credential;
    }

    private static class GetCredentialAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetCredentialAction();

        private GetCredentialAction() {
        }

        public Object run() {
            Object credential = SecurityAssociation.getCredential();
            char[] password = null;
            if (credential instanceof char[]) {
                password = (char[])credential;
            } else if (credential instanceof byte[]) {
                try {
                    String tmp = new String((byte[])credential, "UTF-8");
                    password = tmp.toCharArray();
                }
                catch (UnsupportedEncodingException e) {
                    throw new SecurityException(e.getMessage());
                }
            } else if (credential != null) {
                String tmp = credential.toString();
                password = tmp.toCharArray();
            }
            return password;
        }
    }

    private static class GetPrincipalAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetPrincipalAction();

        private GetPrincipalAction() {
        }

        public Object run() {
            Principal principal = SecurityAssociation.getPrincipal();
            return principal;
        }
    }
}

