/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.ioc;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aspects.ioc.Factory;
import org.jboss.aspects.ioc.Identifier;
import org.jboss.aspects.ioc.IocInterceptor;
import org.jboss.aspects.ioc.IocPointcut;

public class DependencyInjectorContainer {
    private static ConcurrentReaderHashMap registry = new ConcurrentReaderHashMap();
    private static InterceptorFactory[] interceptors = new InterceptorFactory[1];

    public static void register(String property, Object value, Class injectedType) {
        Identifier id = new Identifier(property, injectedType);
        boolean existed = registry.containsKey((Object)id);
        registry.put((Object)id, value);
        if (existed) {
            return;
        }
        String name = "ioc:" + id.name + ":" + id.injectedType.getName();
        String expr = "execution(*->new(..)) AND has(void *->set" + id.name + "(" + id.injectedType.getName() + "))";
        try {
            IocPointcut p = new IocPointcut(name, expr);
            AdviceBinding binding = new AdviceBinding(name, (Pointcut)p, null, null, interceptors);
            AspectManager.instance().addPointcut((Pointcut)p);
            AspectManager.instance().addBinding(binding);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getProperty(String property, Class injectedType) {
        Object value = registry.get((Object)new Identifier(property, injectedType));
        if (value instanceof Factory) {
            return ((Factory)value).create();
        }
        return value;
    }

    static {
        DependencyInjectorContainer.interceptors[0] = new IocInterceptor();
    }
}

