/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.io.Serializable;
import java.util.ArrayList;
import javax.naming.InitialContext;
import org.jboss.aop.Advised;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.remoting.AlreadyRegisteredException;
import org.jboss.aspects.remoting.ClusterChooserInterceptor;
import org.jboss.aspects.remoting.ClusterConstants;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.aspects.remoting.ForwardingInterceptor;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.IsLocalInterceptor;
import org.jboss.aspects.remoting.MergeMetaDataInterceptor;
import org.jboss.aspects.remoting.NotRegisteredException;
import org.jboss.aspects.remoting.ReplicantsManagerInterceptor;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;

public class ClusteredRemoting
implements ClusterConstants {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$aspects$remoting$ClusteredRemoting == null ? (class$org$jboss$aspects$remoting$ClusteredRemoting = ClusteredRemoting.class$("org.jboss.aspects.remoting.ClusteredRemoting")) : class$org$jboss$aspects$remoting$ClusteredRemoting));
    static /* synthetic */ Class class$org$jboss$aspects$remoting$ClusteredRemoting;

    public static ClassProxy clusterRegisteredObject(Object objectId, String partitionName, LoadBalancePolicy lb, String uri) throws Exception {
        return ClusteredRemoting.clusterRegisteredObject(objectId, partitionName, lb, new InvokerLocator(uri));
    }

    public static ClassProxy clusterRegisteredObject(Object objectId, String partitionName, LoadBalancePolicy lb, InvokerLocator locator) throws Exception {
        ClassProxy proxy;
        Class<?> clazz;
        Object obj = Dispatcher.singleton.getRegistered(objectId);
        if (obj == null) {
            throw new NotRegisteredException(objectId.toString() + " is not registered");
        }
        String proxyFamilyName = objectId.toString() + locator.getProtocol() + partitionName;
        HAPartition partition = (HAPartition)new InitialContext().lookup("/HAPartition/" + partitionName);
        HATarget target = new HATarget(partition, proxyFamilyName, (Serializable)locator, 2);
        FamilyClusterInfo familyClusterInfo = ClusteringTargetsRepository.initTarget((String)proxyFamilyName, (ArrayList)target.getReplicants());
        InstanceAdvisor advisor = null;
        if (obj instanceof Advised) {
            advisor = ((Advised)obj)._getInstanceAdvisor();
            clazz = obj.getClass();
        } else if (obj instanceof ClassProxy) {
            advisor = ((ClassProxy)obj)._getInstanceAdvisor();
            clazz = obj.getClass().getSuperclass();
        } else {
            clazz = obj.getClass();
            proxy = ClassProxyFactory.newInstance(obj.getClass());
            advisor = proxy._getInstanceAdvisor();
            advisor.insertInterceptor((Interceptor)new ReplicantsManagerInterceptor(proxyFamilyName, target));
            advisor.insertInterceptor((Interceptor)new ForwardingInterceptor(obj));
            Dispatcher.singleton.registerTarget(objectId, (Object)proxy);
        }
        proxy = ClassProxyFactory.newInstance(clazz);
        InstanceAdvisor proxyAdvisor = proxy._getInstanceAdvisor();
        proxyAdvisor.insertInterceptor((Interceptor)IsLocalInterceptor.singleton);
        proxyAdvisor.insertInterceptor((Interceptor)MergeMetaDataInterceptor.singleton);
        proxyAdvisor.insertInterceptor((Interceptor)ClusterChooserInterceptor.singleton);
        proxyAdvisor.insertInterceptor((Interceptor)InvokeRemoteInterceptor.singleton);
        proxyAdvisor.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILY_WRAPPER", (Object)new FamilyWrapper(proxyFamilyName, target.getReplicants()), PayloadKey.AS_IS);
        proxyAdvisor.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"LOADBALANCE_POLICY", (Object)lb, PayloadKey.AS_IS);
        proxyAdvisor.getMetaData().addMetaData((Object)"REMOTING", (Object)"SUBSYSTEM", (Object)"AOP", PayloadKey.AS_IS);
        proxyAdvisor.getMetaData().addMetaData((Object)"DISPATCHER", (Object)"OID", objectId, PayloadKey.AS_IS);
        return proxy;
    }

    public static ClassProxy registerClusteredObject(Object objectId, Object obj, String partitionName, LoadBalancePolicy lb, String uri) throws Exception {
        return ClusteredRemoting.registerClusteredObject(objectId, obj, partitionName, lb, new InvokerLocator(uri));
    }

    public static ClassProxy registerClusteredObject(Object objectId, Object obj, String partitionName, LoadBalancePolicy lb, InvokerLocator locator) throws Exception {
        ClassProxy proxy;
        if (Dispatcher.singleton.isRegistered(objectId)) {
            throw new AlreadyRegisteredException(objectId.toString() + " is already registered");
        }
        String proxyFamilyName = objectId.toString() + locator.getProtocol() + partitionName;
        HAPartition partition = (HAPartition)new InitialContext().lookup("/HAPartition/" + partitionName);
        HATarget target = new HATarget(partition, proxyFamilyName, (Serializable)locator, 2);
        FamilyClusterInfo familyClusterInfo = ClusteringTargetsRepository.initTarget((String)proxyFamilyName, (ArrayList)target.getReplicants());
        Object registeredObject = null;
        InstanceAdvisor advisor = null;
        if (obj instanceof Advised) {
            registeredObject = obj;
            advisor = ((Advised)obj)._getInstanceAdvisor();
        } else {
            proxy = ClassProxyFactory.newInstance(obj.getClass());
            advisor = proxy._getInstanceAdvisor();
            advisor.insertInterceptor((Interceptor)new ReplicantsManagerInterceptor(proxyFamilyName, target));
            advisor.insertInterceptor((Interceptor)new ForwardingInterceptor(obj));
            registeredObject = proxy;
        }
        advisor.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"HA_TARGET", (Object)target);
        Dispatcher.singleton.registerTarget(objectId, registeredObject);
        proxy = ClassProxyFactory.newInstance(obj.getClass());
        InstanceAdvisor proxyAdvisor = proxy._getInstanceAdvisor();
        proxyAdvisor.insertInterceptor((Interceptor)IsLocalInterceptor.singleton);
        proxyAdvisor.insertInterceptor((Interceptor)MergeMetaDataInterceptor.singleton);
        proxyAdvisor.insertInterceptor((Interceptor)ClusterChooserInterceptor.singleton);
        proxyAdvisor.insertInterceptor((Interceptor)InvokeRemoteInterceptor.singleton);
        proxyAdvisor.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILY_WRAPPER", (Object)new FamilyWrapper(proxyFamilyName, target.getReplicants()), PayloadKey.AS_IS);
        proxyAdvisor.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"LOADBALANCE_POLICY", (Object)lb, PayloadKey.AS_IS);
        proxyAdvisor.getMetaData().addMetaData((Object)"REMOTING", (Object)"SUBSYSTEM", (Object)"AOP", PayloadKey.AS_IS);
        proxyAdvisor.getMetaData().addMetaData((Object)"DISPATCHER", (Object)"OID", objectId, PayloadKey.AS_IS);
        return proxy;
    }

    public static void unregisterClusteredObject(Object object) {
        try {
            ClassProxy proxy = (ClassProxy)object;
            InstanceAdvisor advisor = proxy._getInstanceAdvisor();
            String oid = (String)advisor.getMetaData().getMetaData((Object)"DISPATCHER", (Object)"OID");
            InstanceAdvised registeredObject = (InstanceAdvised)Dispatcher.singleton.getRegistered((Object)oid);
            if (registeredObject == null) {
                throw new NotRegisteredException(oid.toString() + " is not registered");
            }
            Dispatcher.singleton.unregisterTarget((Object)oid);
            advisor = registeredObject._getInstanceAdvisor();
            HATarget target = (HATarget)advisor.getMetaData().getMetaData((Object)"CLUSTERED_REMOTING", (Object)"HA_TARGET");
            target.destroy();
        }
        catch (Exception ignored) {
            log.trace((Object)"Ignored exception unregistering a clustered object", (Throwable)ignored);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

