/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.util.ArrayList;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.remoting.ClusterConstants;
import org.jboss.ha.framework.server.HATarget;

public class ReplicantsManagerInterceptor
implements Interceptor,
ClusterConstants {
    private final HATarget target;
    private final String family;
    private final String name;

    public ReplicantsManagerInterceptor(String family, HATarget target) {
        this.family = family;
        this.target = target;
        this.name = family + "/ReplicantsManagerInterceptor";
    }

    public String getName() {
        return this.name;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object response = invocation.invokeNext();
        String clientFamily = (String)invocation.getMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILY");
        if (!this.family.equals(clientFamily)) {
            return response;
        }
        Long clientViewId = (Long)invocation.getMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_VIEW_ID");
        if (clientViewId == null) {
            return response;
        }
        if (clientViewId.longValue() != this.target.getCurrentViewId()) {
            invocation.addResponseAttachment((Object)"replicants", new ArrayList(this.target.getReplicants()));
            invocation.addResponseAttachment((Object)"viewId", (Object)new Long(this.target.getCurrentViewId()));
        }
        return response;
    }
}

