/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.security;

import java.security.Principal;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.security.SecurityContext;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityAssociation;

public class AuthenticationInterceptor
implements Interceptor {
    protected Logger log = Logger.getLogger(this.getClass());
    protected AuthenticationManager authenticationManager;

    public AuthenticationInterceptor(AuthenticationManager manager) {
        this.authenticationManager = manager;
    }

    public String getName() {
        return "AuthenticationInterceptor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        Object object;
        block5: {
            boolean principalWasNull;
            Principal principal = (Principal)invocation.getMetaData((Object)"security", (Object)"principal");
            Object credential = invocation.getMetaData((Object)"security", (Object)"credential");
            boolean bl = principalWasNull = SecurityAssociation.getPrincipal() == null;
            if (principal == null) {
                principal = SecurityAssociation.getPrincipal();
            }
            if (credential == null) {
                credential = SecurityAssociation.getCredential();
            }
            if (this.authenticationManager != null && !this.authenticationManager.isValid(principal, credential)) {
                String message = "Authentication exception, principal=" + principal;
                this.log.error((Object)message);
                throw new SecurityException(message);
            }
            SecurityAssociation.setPrincipal((Principal)principal);
            SecurityAssociation.setCredential((Object)credential);
            Object oldDomain = SecurityContext.currentDomain.get();
            try {
                SecurityContext.currentDomain.set(this.authenticationManager);
                object = invocation.invokeNext();
                Object var8_8 = null;
                SecurityContext.currentDomain.set(oldDomain);
                if (!principalWasNull) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_9 = null;
                    SecurityContext.currentDomain.set(oldDomain);
                    if (!principalWasNull) break block6;
                    SecurityAssociation.setPrincipal(null);
                    SecurityAssociation.setCredential(null);
                }
                throw throwable;
            }
            SecurityAssociation.setPrincipal(null);
            SecurityAssociation.setCredential(null);
        }
        return object;
    }
}

