/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.net.URL;
import java.util.Comparator;
import org.jboss.deployment.DefaultDeploymentSorter;
import org.jboss.util.NullArgumentException;

public class DeploymentSorter
implements Comparator,
DefaultDeploymentSorter {
    public static final String[] DEFAULT_SUFFIX_ORDER = new String[]{"deployer", "deployer.xml", "sar", "rar", "ds.xml", "service.xml", "har", "jar", "war", "wsr", "ear", "zip", "bsh", "last"};
    protected String[] suffixOrder;

    public DeploymentSorter(String[] suffixOrder) {
        if (suffixOrder == null) {
            throw new NullArgumentException("suffixOrder");
        }
        this.suffixOrder = suffixOrder;
    }

    public DeploymentSorter() {
        this(DEFAULT_SUFFIX_ORDER);
    }

    public String[] getSuffixOrder() {
        return this.suffixOrder;
    }

    public void setSuffixOrder(String[] suffixOrder) {
        this.suffixOrder = suffixOrder;
    }

    public int compare(Object o1, Object o2) {
        URL u1 = (URL)o1;
        URL u2 = (URL)o2;
        int order = this.getExtensionIndex(u1) - this.getExtensionIndex(u2);
        if (order != 0) {
            return order;
        }
        return u1.getFile().compareTo(u2.getFile());
    }

    public int getExtensionIndex(URL url) {
        int i;
        String path = url.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        for (i = 0; i < this.suffixOrder.length && !path.endsWith(this.suffixOrder[i]); ++i) {
        }
        return i;
    }
}

