/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.pm;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.logging.Logger;
import org.jboss.mx.persistence.AttributePersistenceManager;
import org.jboss.system.server.ServerConfigLocator;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLAttributePersistenceManager
implements AttributePersistenceManager {
    public static final String DATA_DIR_ELEMENT = "data-directory";
    public static final String DEFAULT_BASE_DIR = "data/xmbean-attrs";
    public static final String AL_ROOT_ELEMENT = "attribute-list";
    public static final String AL_ID_ATTRIBUTE = "id";
    public static final String AL_DATE_ATTRIBUTE = "date";
    public static final String AL_ATTRIBUTE_ELEMENT = "attribute";
    public static final String AL_NAME_ATTRIBUTE = "name";
    public static final String AL_TYPE_ATTRIBUTE = "type";
    public static final String AL_NULL_ATTRIBUTE = "null";
    public static final String AL_SERIALIZED_ATTRIBUTE = "serialized";
    public static final String AL_TRUE_VALUE = "true";
    public static final String AL_FALSE_VALUE = "false";
    private static final Logger log = Logger.getLogger((Class)XMLAttributePersistenceManager.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private File dataDir;
    private boolean state;
    private Map idMap;

    public XMLAttributePersistenceManager() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Constructed");
        }
    }

    public void create(String version, Element config) throws Exception {
        if (this.getState()) {
            return;
        }
        String baseDir = null;
        if (config == null) {
            baseDir = DEFAULT_BASE_DIR;
        } else {
            if (!config.getTagName().equals(DATA_DIR_ELEMENT)) {
                throw new Exception("expected 'data-directory' XML configuration element, got '" + config.getTagName() + "'");
            }
            baseDir = this.getElementContent(config);
        }
        this.dataDir = this.initDataDir(baseDir, version);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using data directory: " + this.dataDir.getCanonicalPath()));
        }
        this.idMap = Collections.synchronizedMap(new HashMap());
        this.setState(true);
    }

    public boolean getState() {
        return this.state;
    }

    public void destroy() {
        this.setState(false);
        this.dataDir = null;
        this.idMap = null;
    }

    public void store(String id, AttributeList attrs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("store(" + id + ") attrs=" + attrs));
        }
        this.checkActiveState();
        String origId = id;
        id = this.mapId(id);
        if (attrs == null) {
            throw new Exception("store() called with null AttributeList");
        }
        File file = this.checkFileForWrite(id);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.newDocument();
        Comment comment = doc.createComment(" automatically produced by XMLAttributePersistenceManager ");
        doc.appendChild(comment);
        Element root = doc.createElement(AL_ROOT_ELEMENT);
        root.setAttribute(AL_ID_ATTRIBUTE, origId);
        root.setAttribute(AL_DATE_ATTRIBUTE, dateFormat.format(new Date()));
        doc.appendChild(root);
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            String name = attr.getName();
            Object value = attr.getValue();
            Element element = doc.createElement(AL_ATTRIBUTE_ELEMENT);
            element.setAttribute(AL_NAME_ATTRIBUTE, name);
            if (value == null) {
                element.setAttribute(AL_NULL_ATTRIBUTE, AL_TRUE_VALUE);
                root.appendChild(element);
                continue;
            }
            if (value instanceof Element) {
                element.setAttribute(AL_TYPE_ATTRIBUTE, "org.w3c.dom.Element");
                Node copy = doc.importNode((Element)value, true);
                element.appendChild(copy);
                root.appendChild(element);
                continue;
            }
            Class<?> clazz = value.getClass();
            String type = clazz.getName();
            PropertyEditor peditor = PropertyEditorManager.findEditor(clazz);
            if (peditor != null) {
                peditor.setValue(value);
                element.setAttribute(AL_TYPE_ATTRIBUTE, type);
                element.appendChild(doc.createTextNode(peditor.getAsText()));
                root.appendChild(element);
                continue;
            }
            if (value instanceof Serializable) {
                String encoded = this.encodeAsHexString((Serializable)value);
                if (encoded != null) {
                    element.setAttribute(AL_TYPE_ATTRIBUTE, type);
                    element.setAttribute(AL_SERIALIZED_ATTRIBUTE, AL_TRUE_VALUE);
                    element.appendChild(doc.createTextNode(encoded));
                    root.appendChild(element);
                    continue;
                }
                root.appendChild(doc.createComment(" WARN <attribute name=\"" + name + "\" type=\"" + type + "\"/> could not be serialized "));
                log.warn((Object)("Could not serialize attribute '" + name + "' of type '" + type + "' and value: " + value));
                continue;
            }
            root.appendChild(doc.createComment(" WARN <attribute name=\"" + name + "\" type=\"" + type + "\"/> could not be persisted "));
            log.warn((Object)("Could not find a way to persist attribute '" + name + "' of type '" + type + "' and value: " + value));
        }
        try {
            this.outputXmlFile(doc, file);
        }
        catch (Exception e) {
            log.warn((Object)("Cannot persist AttributeList to: \"" + id + "\""), (Throwable)e);
            throw e;
        }
    }

    public AttributeList load(String id) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("load(" + id + ")"));
        }
        this.checkActiveState();
        id = this.mapId(id);
        if (!this.getState()) {
            return null;
        }
        AttributeList attrs = null;
        File file = this.checkFileForRead(id);
        if (file != null) {
            Document doc = this.parseXmlFile(file);
            NodeList docList = doc.getChildNodes();
            Node root = null;
            for (int i = 0; i < docList.getLength(); ++i) {
                Node node = docList.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals(AL_ROOT_ELEMENT)) continue;
                root = (Element)node;
                break;
            }
            if (root == null) {
                throw new Exception("Expected XML element: attribute-list");
            }
            attrs = new AttributeList();
            NodeList rootList = root.getChildNodes();
            for (int i = 0; i < rootList.getLength(); ++i) {
                Node node = rootList.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals(AL_ATTRIBUTE_ELEMENT)) continue;
                Element element = (Element)node;
                String name = element.getAttribute(AL_NAME_ATTRIBUTE);
                if (name.length() <= 0) {
                    throw new Exception("Attribute 'name' must be specified for element 'attribute'");
                }
                if (element.getAttribute(AL_NULL_ATTRIBUTE).toLowerCase().equals(AL_TRUE_VALUE)) {
                    attrs.add(new Attribute(name, null));
                    continue;
                }
                if (element.getAttribute(AL_SERIALIZED_ATTRIBUTE).toLowerCase().equals(AL_TRUE_VALUE)) {
                    String hexStr = this.getElementContent(element);
                    Serializable obj = this.decodeFromHexString(hexStr);
                    if (obj == null) {
                        throw new Exception("Failed to deserialize attribute '" + name + "'");
                    }
                    attrs.add(new Attribute(name, obj));
                    continue;
                }
                String type = element.getAttribute(AL_TYPE_ATTRIBUTE);
                if (type.length() <= 0) {
                    throw new Exception("Attribute 'type' must be specified for name='" + name + "'");
                }
                if (type.equals("org.w3c.dom.Element")) {
                    NodeList nlist = element.getChildNodes();
                    Node el = null;
                    for (int j = 0; j < nlist.getLength(); ++j) {
                        Node n = nlist.item(j);
                        if (n.getNodeType() != 1) continue;
                        el = (Element)n;
                        break;
                    }
                    if (el != null) {
                        attrs.add(new Attribute(name, el.cloneNode(true)));
                        continue;
                    }
                    attrs.add(new Attribute(name, null));
                    continue;
                }
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = null;
                try {
                    clazz = cl.loadClass(type);
                }
                catch (ClassNotFoundException e) {
                    throw new Exception("Class not found for attribute '" + name + "' of type '" + type + "'");
                }
                PropertyEditor peditor = PropertyEditorManager.findEditor(clazz);
                if (peditor != null) {
                    String value = this.getElementContent(element);
                    peditor.setAsText(value);
                    attrs.add(new Attribute(name, peditor.getValue()));
                    continue;
                }
                throw new Exception("Cannot find a way to load attribute '" + name + "' of type '" + type + "'");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("load() returns with: " + attrs));
        }
        return attrs;
    }

    public boolean exists(String id) throws Exception {
        this.checkActiveState();
        return new File(this.dataDir, this.mapId(id)).isFile();
    }

    public void remove(String id) throws Exception {
        this.checkActiveState();
        new File(this.dataDir, this.mapId(id)).delete();
    }

    public void removeAll() throws Exception {
        this.checkActiveState();
        String[] files = this.dataDir.list(new XMLFilter());
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                new File(this.dataDir, files[i]).delete();
            }
        }
    }

    public String[] listAll() throws Exception {
        this.checkActiveState();
        String[] files = this.dataDir.list(new XMLFilter());
        String[] result = null;
        if (files != null) {
            result = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                result[i] = this.mapFile(files[i]);
            }
        }
        return result;
    }

    private void setState(boolean state) {
        this.state = state;
    }

    private File initDataDir(String baseDir, String versionTag) throws Exception {
        File dir;
        block5: {
            dir = null;
            try {
                URL fileURL = new URL(baseDir);
                File file = new File(fileURL.getFile());
                if (file.isDirectory() && file.canRead() && file.canWrite()) {
                    dir = file;
                }
            }
            catch (Exception e) {
                File homeDir = ServerConfigLocator.locate().getServerHomeDir();
                dir = new File(homeDir, baseDir);
                dir.mkdirs();
                if (dir.isDirectory()) break block5;
                throw new Exception("The base directory is not valid: " + dir.getCanonicalPath());
            }
        }
        if (versionTag != null && !versionTag.equals("")) {
            dir = new File(dir, versionTag);
            dir.mkdirs();
            if (!dir.isDirectory()) {
                throw new Exception("The data directory is not valid: " + dir.getCanonicalPath());
            }
        }
        return dir;
    }

    private String encodeAsHexString(Serializable obj) {
        String retn = null;
        if (obj != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                byte[] bytes = baos.toByteArray();
                StringBuffer sbuf = new StringBuffer(1024);
                for (int i = 0; i < bytes.length; ++i) {
                    sbuf.append(hexDigits[bytes[i] >> 4 & 0xF]);
                    sbuf.append(hexDigits[bytes[i] & 0xF]);
                }
                retn = sbuf.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return retn;
    }

    private Serializable decodeFromHexString(String hexStr) {
        int len = hexStr.length() / 2;
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            int d1;
            char h1 = hexStr.charAt(i * 2);
            char h2 = hexStr.charAt(i * 2 + 1);
            int n = h1 >= 'a' ? 10 + h1 - 97 : (d1 = h1 >= 'A' ? 10 + h1 - 65 : h1 - 48);
            int d2 = h2 >= 'a' ? 10 + h2 - 97 : (h2 >= 'A' ? 10 + h2 - 65 : h2 - 48);
            bytes[i] = (byte)(d1 * 16 + d2);
        }
        Serializable retn = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            retn = (Serializable)ois.readObject();
        }
        catch (IOException e) {
            log.warn((Object)"Cannot deserialize object", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"Cannot deserialize object", (Throwable)e);
        }
        return retn;
    }

    private void outputXmlFile(Document doc, File file) throws Exception {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("indent", "yes");
        xformer.transform(source, result);
    }

    private Document parseXmlFile(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        Document doc = factory.newDocumentBuilder().parse(file);
        return doc;
    }

    private File checkFileForWrite(String filename) throws Exception {
        File file = new File(this.dataDir, filename);
        if (file.isFile()) {
            if (file.canRead() && file.canWrite()) {
                return file;
            }
            throw new Exception("file '" + filename + "' is not r/w");
        }
        if (file.isDirectory()) {
            throw new Exception(filename + " is a directory!");
        }
        return file;
    }

    private File checkFileForRead(String filename) throws Exception {
        File file = new File(this.dataDir, filename);
        if (file.isFile()) {
            if (file.canRead() && file.canWrite()) {
                return file;
            }
            throw new Exception("file '" + filename + "' is not r/w");
        }
        if (file.isDirectory()) {
            throw new Exception(filename + " is a directory!");
        }
        return null;
    }

    private String getElementContent(Element element) {
        NodeList nlist = element.getChildNodes();
        StringBuffer sbuf = new StringBuffer(1024);
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node node = nlist.item(i);
            if (node.getNodeType() != 3) continue;
            sbuf.append(((Text)node).getData());
        }
        return sbuf.toString();
    }

    private void checkActiveState() {
        if (!this.getState()) {
            throw new IllegalStateException("AttributePersistenceManager not active");
        }
    }

    private String encodeFileName(String name) {
        StringBuffer rc = new StringBuffer();
        block5: for (int i = 0; i < name.length(); ++i) {
            switch (name.charAt(i)) {
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    rc.append(name.charAt(i));
                    continue block5;
                }
                default: {
                    try {
                        byte[] data = ("" + name.charAt(i)).getBytes("UTF8");
                        for (int j = 0; j < data.length; ++j) {
                            rc.append('@');
                            rc.append(hexDigits[data[j] >> 4 & 0xF]);
                            rc.append(hexDigits[data[j] & 0xF]);
                        }
                        continue block5;
                    }
                    catch (UnsupportedEncodingException wonthappen) {
                        // empty catch block
                    }
                }
            }
        }
        return rc.toString();
    }

    private String decodeFileName(String name) {
        if (name == null) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '@') {
                int d1;
                char h1 = name.charAt(++i);
                char h2 = name.charAt(++i);
                int n = h1 >= 'a' ? 10 + h1 - 97 : (d1 = h1 >= 'A' ? 10 + h1 - 65 : h1 - 48);
                int d2 = h2 >= 'a' ? 10 + h2 - 97 : (h2 >= 'A' ? 10 + h2 - 65 : h2 - 48);
                byte[] bytes = new byte[]{(byte)(d1 * 16 + d2)};
                try {
                    String s = new String(bytes, "UTF8");
                    sbuf.append(s);
                }
                catch (UnsupportedEncodingException wonthappen) {}
                continue;
            }
            sbuf.append(c);
        }
        return sbuf.toString();
    }

    private String mapId(String id) throws Exception {
        if (id == null) {
            throw new Exception("called with null id");
        }
        String file = (String)this.idMap.get(id);
        if (file == null) {
            file = this.encodeFileName(id) + ".xml";
            this.idMap.put(id, file);
        }
        return file;
    }

    private String mapFile(String file) {
        if (file == null) {
            return null;
        }
        file = file.substring(0, file.length() - 4);
        return this.decodeFileName(file);
    }

    private class XMLFilter
    implements FilenameFilter {
        private XMLFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    }
}

