/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.jmx.adaptor.snmp.agent.Clock;
import org.jboss.jmx.adaptor.snmp.agent.Counter;
import org.jboss.jmx.adaptor.snmp.agent.Heartbeat;
import org.jboss.jmx.adaptor.snmp.agent.RequestHandler;
import org.jboss.jmx.adaptor.snmp.agent.SnmpAgentServiceMBean;
import org.jboss.jmx.adaptor.snmp.agent.TrapEmitter;
import org.jboss.system.ListenerServiceMBeanSupport;
import org.opennms.protocols.snmp.SnmpAgentHandler;
import org.opennms.protocols.snmp.SnmpAgentSession;
import org.opennms.protocols.snmp.SnmpPeer;

public class SnmpAgentService
extends ListenerServiceMBeanSupport
implements NotificationListener,
SnmpAgentServiceMBean {
    public static final int SNMPV1 = 1;
    public static final int SNMPV2 = 2;
    public static final String DEFAULT_READ_COMMUNITY = "public";
    public static final String DEFAULT_WRITE_COMMUNITY = "private";
    private Clock clock = null;
    private Counter trapCounter = null;
    private String managersResName = null;
    private String notificationMapResName = null;
    private String requestHandlerResName = null;
    private String trapFactoryClassName = null;
    private String requestHandlerClassName = null;
    private String readCommunity = "public";
    private String writeCommunity = "private";
    private int numberOfThreads = 1;
    private int port = 1161;
    private int snmpVersion = 1;
    private InetAddress bindAddress;
    private ObjectName timerName = null;
    private int heartBeatPeriod = 60;
    private Heartbeat heartbeat = null;
    private TrapEmitter trapEmitter = null;
    private SnmpAgentSession agentSession = null;

    public int getHeartBeatPeriod() {
        return this.heartBeatPeriod;
    }

    public void setHeartBeatPeriod(int heartBeatPeriod) {
        this.heartBeatPeriod = heartBeatPeriod;
    }

    public long getInstantiationTime() {
        return this.clock.instantiationTime();
    }

    public long getUptime() {
        return this.clock.uptime();
    }

    public long getTrapCount() {
        return this.trapCounter.peek();
    }

    public void setManagersResName(String managersResName) {
        this.managersResName = managersResName;
    }

    public String getManagersResName() {
        return this.managersResName;
    }

    public void setNotificationMapResName(String notificationMapResName) {
        this.notificationMapResName = notificationMapResName;
    }

    public String getNotificationMapResName() {
        return this.notificationMapResName;
    }

    public void setTrapFactoryClassName(String name) {
        this.trapFactoryClassName = name;
    }

    public String getTrapFactoryClassName() {
        return this.trapFactoryClassName;
    }

    public void setTimerName(ObjectName timerName) {
        this.timerName = timerName;
    }

    public ObjectName getTimerName() {
        return this.timerName;
    }

    public void setBindAddress(String bindAddress) throws UnknownHostException {
        this.bindAddress = this.toInetAddress(bindAddress);
    }

    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        if (numberOfThreads > 0 && numberOfThreads <= 12) {
            this.numberOfThreads = numberOfThreads;
        }
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setPort(int port) {
        if (port >= 0) {
            this.port = port;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setSnmpVersion(int snmpVersion) {
        switch (snmpVersion) {
            case 2: {
                this.snmpVersion = 2;
                break;
            }
            default: {
                this.snmpVersion = 1;
            }
        }
    }

    public int getSnmpVersion() {
        return this.snmpVersion;
    }

    public void setReadCommunity(String readCommunity) {
        if (readCommunity != null && readCommunity.length() > 0) {
            this.readCommunity = readCommunity;
        }
    }

    public void setWriteCommunity(String writeCommunity) {
        if (writeCommunity != null && writeCommunity.length() > 0) {
            this.writeCommunity = writeCommunity;
        }
    }

    public void setRequestHandlerClassName(String requestHandlerClassName) {
        this.requestHandlerClassName = requestHandlerClassName;
    }

    public String getRequestHandlerClassName() {
        return this.requestHandlerClassName;
    }

    public void setRequestHandlerResName(String requestHandlerResName) {
        this.requestHandlerResName = requestHandlerResName;
    }

    public String getRequestHandlerResName() {
        return this.requestHandlerResName;
    }

    protected void startService() throws Exception {
        this.clock = new Clock();
        this.trapCounter = new Counter(0L);
        this.log.debug((Object)"Instantiating trap emitter ...");
        this.trapEmitter = new TrapEmitter(this.getTrapFactoryClassName(), this.trapCounter, this.clock, this.getManagersResName(), this.getNotificationMapResName());
        this.log.debug((Object)"Starting trap emitter ...");
        this.trapEmitter.start();
        this.heartbeat = new Heartbeat(this.getServer(), this.getTimerName(), this.getHeartBeatPeriod());
        this.log.debug((Object)"Starting heartbeat controller ...");
        this.heartbeat.start();
        super.subscribe(true);
        this.log.debug((Object)"Starting snmp agent ...");
        this.startAgent();
        this.log.info((Object)"SNMP agent going active");
        this.sendNotification(new Notification("jboss.snmp.agent.coldstart", this, this.getNextNotificationSequenceNumber()));
    }

    protected void stopService() throws Exception {
        super.unsubscribe();
        this.log.debug((Object)"Stopping heartbeat controller ...");
        this.heartbeat.stop();
        this.heartbeat = null;
        this.log.debug((Object)"Stopping trap emitter ...");
        this.trapEmitter.stop();
        this.trapEmitter = null;
        this.log.debug((Object)"Stopping snmp agent ...");
        this.agentSession.close();
        this.agentSession = null;
        this.log.info((Object)"SNMP agent stopped");
    }

    public void handleNotification2(Notification n, Object handback) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received notification: <" + n + "> Payload " + "TS: <" + n.getTimeStamp() + "> " + "SN: <" + n.getSequenceNumber() + "> " + "T:  <" + n.getType() + ">"));
        }
        try {
            this.trapEmitter.send(n);
        }
        catch (Exception e) {
            this.log.error((Object)"Sending trap", (Throwable)e);
        }
    }

    private void startAgent() throws Exception {
        InetAddress address = this.bindAddress != null ? this.bindAddress : this.toInetAddress(System.getProperty("jboss.bind.address"));
        SnmpPeer peer = new SnmpPeer(address, this.port);
        peer.getParameters().setReadCommunity(this.readCommunity);
        peer.getParameters().setWriteCommunity(this.writeCommunity);
        peer.getParameters().setVersion(this.snmpVersion == 2 ? 1 : 0);
        RequestHandler handler = (RequestHandler)Class.forName(this.requestHandlerClassName, true, this.getClass().getClassLoader()).newInstance();
        handler.initialize(this.requestHandlerResName, this.getServer(), this.log, this.clock);
        this.agentSession = this.numberOfThreads > 1 ? new SnmpAgentSession((SnmpAgentHandler)handler, peer, this.numberOfThreads) : new SnmpAgentSession((SnmpAgentHandler)handler, peer);
    }

    private InetAddress toInetAddress(String host) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            return null;
        }
        return InetAddress.getByName(host);
    }
}

