/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.configuration;

import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SshAPIConfiguration
extends DefaultHandler
implements com.sshtools.j2ssh.configuration.SshAPIConfiguration {
    private String defaultCipher = null;
    private String defaultMac = null;
    private String defaultCompression = null;
    private String defaultPublicKey = null;
    private String defaultKeyExchange = null;
    private List cipherExtensions = new ArrayList();
    private List macExtensions = new ArrayList();
    private List compressionExtensions = new ArrayList();
    private List pkExtensions = new ArrayList();
    private List kexExtensions = new ArrayList();
    private List authExtensions = new ArrayList();
    private List pkFormats = new ArrayList();
    private List prvFormats = new ArrayList();
    private String defaultPublicFormat = null;
    private String defaultPrivateFormat = null;
    private String currentElement = null;
    private String parentElement = null;
    private List currentList = null;
    private ExtensionAlgorithm currentExt = null;

    public SshAPIConfiguration(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        this.reload(inputStream);
    }

    public void reload(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        this.defaultCipher = null;
        this.defaultMac = null;
        this.defaultCompression = null;
        this.defaultKeyExchange = null;
        this.defaultPublicKey = null;
        this.defaultPublicFormat = null;
        this.defaultPrivateFormat = null;
        this.cipherExtensions.clear();
        this.macExtensions.clear();
        this.compressionExtensions.clear();
        this.pkExtensions.clear();
        this.kexExtensions.clear();
        this.authExtensions.clear();
        this.pkFormats.clear();
        this.prvFormats.clear();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(inputStream, (DefaultHandler)this);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.currentElement != null) {
            if (this.currentElement.equals("AlgorithmName")) {
                if (this.currentExt == null) {
                    throw new SAXException("Unexpected AlgorithmName element!");
                }
                this.currentExt.setAlgorithmName(string);
                return;
            }
            if (this.currentElement.equals("ImplementationClass")) {
                if (this.currentExt == null) {
                    throw new SAXException("Unexpected ImplementationClass element!");
                }
                this.currentExt.setImplementationClass(string);
                return;
            }
            if (this.currentElement.equals("DefaultAlgorithm")) {
                if (this.parentElement.equals("CipherConfiguration")) {
                    this.defaultCipher = string;
                } else if (this.parentElement.equals("MacConfiguration")) {
                    this.defaultMac = string;
                } else if (this.parentElement.equals("CompressionConfiguration")) {
                    this.defaultCompression = string;
                } else if (this.parentElement.equals("PublicKeyConfiguration")) {
                    this.defaultPublicKey = string;
                } else if (this.parentElement.equals("KeyExchangeConfiguration")) {
                    this.defaultKeyExchange = string;
                } else {
                    throw new SAXException("Unexpected parent elemenet for DefaultAlgorithm element");
                }
            }
            if (this.currentElement.equals("DefaultPublicFormat")) {
                this.defaultPublicFormat = string;
            }
            if (this.currentElement.equals("DefaultPrivateFormat")) {
                this.defaultPrivateFormat = string;
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.currentElement != null) {
            if (!this.currentElement.equals(string3)) {
                throw new SAXException("Unexpected end element found ".concat(String.valueOf(String.valueOf(string3))));
            }
            if (this.currentElement.equals("SshAPIConfiguration")) {
                this.currentElement = null;
            } else if (this.currentElement.equals("CipherConfiguration") || this.currentElement.equals("MacConfiguration") || this.currentElement.equals("PublicKeyConfiguration") || this.currentElement.equals("CompressionConfiguration") || this.currentElement.equals("KeyExchangeConfiguration") || this.currentElement.equals("AuthenticationConfiguration")) {
                this.currentList = null;
                this.currentElement = "SshAPIConfiguration";
            } else if (this.currentElement.equals("ExtensionAlgorithm")) {
                if (this.currentExt == null) {
                    throw new SAXException("Critical error, null extension algortihm");
                }
                if (this.currentExt.getAlgorithmName() == null || this.currentExt.getImplementationClass() == null) {
                    throw new SAXException("Unexpected end of ExtensionAlgorithm Element");
                }
                this.currentList.add(this.currentExt);
                this.currentExt = null;
                this.currentElement = this.parentElement;
            } else if (this.currentElement.equals("DefaultAlgorithm") || this.currentElement.equals("DefaultPublicFormat") || this.currentElement.equals("DefaultPrivateFormat") || this.currentElement.equals("PublicKeyFormat") || this.currentElement.equals("PrivateKeyFormat")) {
                this.currentElement = this.parentElement;
            } else if (this.currentElement.equals("AlgorithmName")) {
                this.currentElement = "ExtensionAlgorithm";
            } else if (this.currentElement.equals("ImplementationClass")) {
                this.currentElement = "ExtensionAlgorithm";
            } else {
                throw new SAXException("Unexpected end element ".concat(String.valueOf(String.valueOf(string3))));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.currentElement == null) {
            if (!string3.equals("SshAPIConfiguration")) {
                throw new SAXException("Unexpected root element ".concat(String.valueOf(String.valueOf(string3))));
            }
        } else if (this.currentElement.equals("SshAPIConfiguration")) {
            if (!(string3.equals("CipherConfiguration") || string3.equals("MacConfiguration") || string3.equals("CompressionConfiguration") || string3.equals("PublicKeyConfiguration") || string3.equals("AuthenticationConfiguration") || string3.equals("KeyExchangeConfiguration"))) {
                throw new SAXException(String.valueOf(String.valueOf(new StringBuffer("Unexpected <").append(string3).append("> element after SshAPIConfiguration"))));
            }
        } else if (this.currentElement.equals("CipherConfiguration")) {
            if (string3.equals("ExtensionAlgorithm")) {
                this.currentList = this.cipherExtensions;
                this.parentElement = this.currentElement;
                this.currentExt = new ExtensionAlgorithm();
            } else {
                if (!string3.equals("DefaultAlgorithm")) throw new SAXException(String.valueOf(String.valueOf(new StringBuffer("Unexpected element <").append(string3).append("> found after CipherConfiguration"))));
                this.parentElement = this.currentElement;
            }
        } else if (this.currentElement.equals("MacConfiguration")) {
            if (string3.equals("ExtensionAlgorithm")) {
                this.currentList = this.macExtensions;
                this.parentElement = this.currentElement;
                this.currentExt = new ExtensionAlgorithm();
            } else {
                if (!string3.equals("DefaultAlgorithm")) throw new SAXException(String.valueOf(String.valueOf(new StringBuffer("Unexpected element <").append(string3).append("> found after CipherConfiguration"))));
                this.parentElement = this.currentElement;
            }
        } else if (this.currentElement.equals("CompressionConfiguration")) {
            if (string3.equals("ExtensionAlgorithm")) {
                this.currentList = this.compressionExtensions;
                this.parentElement = this.currentElement;
                this.currentExt = new ExtensionAlgorithm();
            } else {
                if (!string3.equals("DefaultAlgorithm")) throw new SAXException(String.valueOf(String.valueOf(new StringBuffer("Unexpected element <").append(string3).append("> found after CompressionConfiguration"))));
                this.parentElement = this.currentElement;
            }
        } else if (this.currentElement.equals("PublicKeyConfiguration")) {
            if (string3.equals("ExtensionAlgorithm")) {
                this.currentList = this.pkExtensions;
                this.parentElement = this.currentElement;
                this.currentExt = new ExtensionAlgorithm();
            } else if (string3.equals("DefaultAlgorithm")) {
                this.parentElement = this.currentElement;
            } else if (string3.equals("PublicKeyFormat")) {
                String string4 = attributes.getValue("ImplementationClass");
                if (string4 == null) {
                    throw new SAXException("<PublicKeyFormat> element requries the ImplementationClass attribute");
                }
                this.pkFormats.add(string4);
            } else if (string3.equals("PrivateKeyFormat")) {
                String string5 = attributes.getValue("ImplementationClass");
                if (string5 == null) {
                    throw new SAXException("<PrivateKeyFormat> element requries the ImplementationClass attribute");
                }
                this.prvFormats.add(string5);
            } else if (string3.equals("DefaultPublicFormat")) {
                this.parentElement = this.currentElement;
            } else {
                if (!string3.equals("DefaultPrivateFormat")) throw new SAXException(String.valueOf(String.valueOf(new StringBuffer("Unexpected element <").append(string3).append("> found after PublicKeyConfiguration"))));
                this.parentElement = this.currentElement;
            }
        } else if (this.currentElement.equals("AuthenticationConfiguration")) {
            if (!string3.equals("ExtensionAlgorithm")) throw new SAXException(String.valueOf(String.valueOf(new StringBuffer("Unexpected element <").append(string3).append("> found after AuthenticationConfiguration"))));
            this.currentList = this.authExtensions;
            this.parentElement = this.currentElement;
            this.currentExt = new ExtensionAlgorithm();
        } else if (this.currentElement.equals("KeyExchangeConfiguration")) {
            if (string3.equals("ExtensionAlgorithm")) {
                this.currentList = this.kexExtensions;
                this.parentElement = this.currentElement;
                this.currentExt = new ExtensionAlgorithm();
            } else {
                if (!string3.equals("DefaultAlgorithm")) throw new SAXException(String.valueOf(String.valueOf(new StringBuffer("Unexpected element <").append(string3).append("> found after KeyExchangeConfiguration"))));
                this.parentElement = this.currentElement;
            }
        } else if (!(this.currentElement.equals("ExtensionAlgorithm") && string3.equals("AlgorithmName") || this.currentElement.equals("ExtensionAlgorithm") && string3.equals("ImplementationClass"))) {
            throw new SAXException("Unexpected element ".concat(String.valueOf(String.valueOf(string3))));
        }
        this.currentElement = string3;
    }

    public List getCompressionExtensions() {
        return this.compressionExtensions;
    }

    public List getCipherExtensions() {
        return this.cipherExtensions;
    }

    public List getMacExtensions() {
        return this.macExtensions;
    }

    public List getAuthenticationExtensions() {
        return this.authExtensions;
    }

    public List getPublicKeyExtensions() {
        return this.pkExtensions;
    }

    public List getKeyExchangeExtensions() {
        return this.kexExtensions;
    }

    public String getDefaultCipher() {
        return this.defaultCipher;
    }

    public String getDefaultMac() {
        return this.defaultMac;
    }

    public String getDefaultCompression() {
        return this.defaultCompression;
    }

    public String getDefaultPublicKey() {
        return this.defaultPublicKey;
    }

    public String getDefaultKeyExchange() {
        return this.defaultKeyExchange;
    }

    public String getDefaultPublicKeyFormat() {
        return this.defaultPublicFormat;
    }

    public String getDefaultPrivateKeyFormat() {
        return this.defaultPrivateFormat;
    }

    public List getPublicKeyFormats() {
        return this.pkFormats;
    }

    public List getPrivateKeyFormats() {
        return this.prvFormats;
    }

    public String toString() {
        String string;
        ExtensionAlgorithm extensionAlgorithm;
        String string2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        string2 = String.valueOf(String.valueOf(string2)).concat("<!-- Sshtools J2SSH Configuration file -->\n");
        string2 = String.valueOf(String.valueOf(string2)).concat("<SshAPIConfiguration>\n");
        string2 = String.valueOf(String.valueOf(string2)).concat("   <!-- The Cipher configuration, add or overide default cipher implementations -->\n");
        string2 = String.valueOf(String.valueOf(string2)).concat("   <CipherConfiguration>\n");
        Iterator iterator = this.cipherExtensions.iterator();
        while (iterator.hasNext()) {
            extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
            string2 = String.valueOf(String.valueOf(string2)).concat("      <ExtensionAlgorithm>\n");
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("         <AlgorithmName>").append(extensionAlgorithm.getAlgorithmName()).append("</AlgorithmName>\n"))))));
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("         <ImplementationClass>").append(extensionAlgorithm.getImplementationClass()).append("</ImplementationClass>\n"))))));
            string2 = String.valueOf(String.valueOf(string2)).concat("      </ExtensionAlgorithm>\n");
        }
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("      <DefaultAlgorithm>").append(this.defaultCipher).append("</DefaultAlgorithm>\n"))))));
        string2 = String.valueOf(String.valueOf(string2)).concat("   </CipherConfiguration>\n");
        string2 = String.valueOf(String.valueOf(string2)).concat("   <!-- The Mac configuration, add or overide default mac implementations -->\n");
        string2 = String.valueOf(String.valueOf(string2)).concat("   <MacConfiguration>\n");
        iterator = this.macExtensions.iterator();
        while (iterator.hasNext()) {
            extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
            string2 = String.valueOf(String.valueOf(string2)).concat("      <ExtensionAlgorithm>\n");
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("         <AlgorithmName>").append(extensionAlgorithm.getAlgorithmName()).append("</AlgorithmName>\n"))))));
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("         <ImplementationClass>").append(extensionAlgorithm.getImplementationClass()).append("</ImplementationClass>\n"))))));
            string2 = String.valueOf(String.valueOf(string2)).concat("      </ExtensionAlgorithm>\n");
        }
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("      <DefaultAlgorithm>").append(this.defaultMac).append("</DefaultAlgorithm>\n"))))));
        string2 = String.valueOf(String.valueOf(string2)).concat("   </MacConfiguration>\n");
        string2 = String.valueOf(String.valueOf(string2)).concat("   <!-- The Compression configuration, add or overide default compression implementations -->\n");
        string2 = String.valueOf(String.valueOf(string2)).concat("   <CompressionConfiguration>\n");
        iterator = this.compressionExtensions.iterator();
        while (iterator.hasNext()) {
            extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
            string2 = String.valueOf(String.valueOf(string2)).concat("      <ExtensionAlgorithm>\n");
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("         <AlgorithmName>").append(extensionAlgorithm.getAlgorithmName()).append("</AlgorithmName>\n"))))));
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("         <ImplementationClass>").append(extensionAlgorithm.getImplementationClass()).append("</ImplementationClass>\n"))))));
            string2 = String.valueOf(String.valueOf(string2)).concat("      </ExtensionAlgorithm>\n");
        }
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("      <DefaultAlgorithm>").append(this.defaultCompression).append("</DefaultAlgorithm>\n"))))));
        string2 = String.valueOf(String.valueOf(string2)).concat("   </CompressionConfiguration>\n");
        string2 = String.valueOf(String.valueOf(string2)).concat("   <!-- The Public Key configuration, add or overide default public key implementations -->\n");
        string2 = String.valueOf(String.valueOf(string2)).concat("   <PublicKeyConfiguration>\n");
        iterator = this.pkExtensions.iterator();
        while (iterator.hasNext()) {
            extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
            string2 = String.valueOf(String.valueOf(string2)).concat("      <ExtensionAlgorithm>\n");
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("         <AlgorithmName>").append(extensionAlgorithm.getAlgorithmName()).append("</AlgorithmName>\n"))))));
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("         <ImplementationClass>").append(extensionAlgorithm.getImplementationClass()).append("</ImplementationClass>\n"))))));
            string2 = String.valueOf(String.valueOf(string2)).concat("      </ExtensionAlgorithm>\n");
        }
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("      <DefaultAlgorithm>").append(this.defaultPublicKey).append("</DefaultAlgorithm>\n"))))));
        iterator = this.pkFormats.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("      <PublicKeyFormat ImplementationClass=\"").append(string).append("\"/>\n"))))));
        }
        iterator = this.prvFormats.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("      <PrivateKeyFormat ImplementationClass=\"").append(string).append("\"/>\n"))))));
        }
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("      <DefaultPublicFormat>").append(this.defaultPublicFormat).append("</DefaultPublicFormat>\n"))))));
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("      <DefaultPrivateFormat>").append(this.defaultPrivateFormat).append("</DefaultPrivateFormat>\n"))))));
        string2 = String.valueOf(String.valueOf(string2)).concat("   </PublicKeyConfiguration>\n");
        string2 = String.valueOf(String.valueOf(string2)).concat("   <!-- The Key Exchange configuration, add or overide default key exchange implementations -->\n");
        string2 = String.valueOf(String.valueOf(string2)).concat("   <KeyExchangeConfiguration>\n");
        iterator = this.kexExtensions.iterator();
        while (iterator.hasNext()) {
            extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
            string2 = String.valueOf(String.valueOf(string2)).concat("      <ExtensionAlgorithm>\n");
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("         <AlgorithmName>").append(extensionAlgorithm.getAlgorithmName()).append("</AlgorithmName>\n"))))));
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("         <ImplementationClass>").append(extensionAlgorithm.getImplementationClass()).append("</ImplementationClass>\n"))))));
            string2 = String.valueOf(String.valueOf(string2)).concat("      </ExtensionAlgorithm>\n");
        }
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("      <DefaultAlgorithm>").append(this.defaultKeyExchange).append("</DefaultAlgorithm>\n"))))));
        string2 = String.valueOf(String.valueOf(string2)).concat("   </KeyExchangeConfiguration>\n");
        string2 = String.valueOf(String.valueOf(string2)).concat("   <!-- The Authentication configuration, add or overide default authentication implementations -->\n");
        string2 = String.valueOf(String.valueOf(string2)).concat("   <AuthenticationConfiguration>\n");
        iterator = this.authExtensions.iterator();
        while (iterator.hasNext()) {
            extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
            string2 = String.valueOf(String.valueOf(string2)).concat("      <ExtensionAlgorithm>\n");
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("         <AlgorithmName>").append(extensionAlgorithm.getAlgorithmName()).append("</AlgorithmName>\n"))))));
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("         <ImplementationClass>").append(extensionAlgorithm.getImplementationClass()).append("</ImplementationClass>\n"))))));
            string2 = String.valueOf(String.valueOf(string2)).concat("      </ExtensionAlgorithm>\n");
        }
        string2 = String.valueOf(String.valueOf(string2)).concat("   </AuthenticationConfiguration>\n");
        string2 = String.valueOf(String.valueOf(string2)).concat("</SshAPIConfiguration>");
        return string2;
    }
}

