/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.keygen;

import com.sshtools.common.keygen.KeygenPanel;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.publickey.OpenSSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SECSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshKeyGenerator;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.UIManager;

public class Main
extends JFrame
implements ActionListener {
    static final String ICON = "/com/sshtools/common/authentication/largepassphrase.png";
    JButton close;
    JButton generate;
    KeygenPanel keygen;

    public Main() {
        super("ssh-keygen");
        try {
            ConfigurationLoader.initialize((boolean)false);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        ((Frame)this).setIconImage(new ResourceIcon(ICON).getImage());
        this.keygen = new KeygenPanel();
        IconWrapperPanel iconWrapperPanel = new IconWrapperPanel(new ResourceIcon(ICON), this.keygen);
        iconWrapperPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.weighty = 1.0;
        this.generate = new JButton("Generate");
        this.generate.addActionListener(this);
        this.generate.setMnemonic('g');
        this.getRootPane().setDefaultButton(this.generate);
        UIUtil.jGridBagAdd(jPanel, this.generate, gridBagConstraints, -1);
        this.close = new JButton("Close");
        this.close.addActionListener(this);
        this.close.setMnemonic('c');
        UIUtil.jGridBagAdd(jPanel, this.close, gridBagConstraints, 0);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel2.add(jPanel);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel3.add((Component)iconWrapperPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(jPanel3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.close) {
            this.dispose();
            return;
        }
        final String string = new String(this.keygen.getNewPassphrase()).trim();
        final String string2 = new String(this.keygen.getOldPassphrase()).trim();
        if ((this.keygen.getAction() == 0 || this.keygen.getAction() == 3) && string.length() == 0 && JOptionPane.showConfirmDialog(this, "Passphrase is empty. Are you sure?", "Empty Passphrase", 0) == 1) {
            return;
        }
        final File file = new File(this.keygen.getInputFilename());
        final File file2 = new File(this.keygen.getOutputFilename());
        File file3 = new File(String.valueOf(String.valueOf(this.keygen.getOutputFilename())).concat(".pub"));
        if (this.keygen.getAction() == 1 || this.keygen.getAction() == 2 || this.keygen.getAction() == 0) {
            if (this.keygen.getOutputFilename().length() == 0) {
                JOptionPane.showMessageDialog(this, "No Output file supplied.", "Error", 0);
                return;
            }
            if (file2.exists() && JOptionPane.showConfirmDialog(this, String.valueOf(String.valueOf(new StringBuffer("Output file ").append(file2.getName()).append(" exists. Are you sure?"))), "File exists", 0) == 1) {
                return;
            }
            if (file2.exists() && !file2.canWrite()) {
                JOptionPane.showMessageDialog(this, String.valueOf(String.valueOf(new StringBuffer("Output file ").append(file2.getName()).append(" can not be written."))), "Unwriteable file", 0);
                return;
            }
        }
        if (this.keygen.getAction() == 1 || this.keygen.getAction() == 2) {
            if (this.keygen.getInputFilename().length() == 0) {
                JOptionPane.showMessageDialog(this, "No Input file supplied.", "Error", 0);
                return;
            }
        } else if (this.keygen.getAction() == 0 && file3.exists() && !file3.canWrite()) {
            JOptionPane.showMessageDialog(this, String.valueOf(String.valueOf(new StringBuffer("Public key file ").append(file3.getName()).append(" can not be written."))), "Unwriteable file", 0);
            return;
        }
        final ProgressMonitor progressMonitor = new ProgressMonitor(this, "Generating keys", "Generating", 0, 100);
        progressMonitor.setMillisToDecideToPopup(0);
        progressMonitor.setMillisToPopup(0);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    block7: {
                        try {
                            if (Main.this.keygen.getAction() == 3) {
                                progressMonitor.setNote("Changing passphrase");
                                SshKeyGenerator.changePassphrase((File)file, (String)string2, (String)string);
                                progressMonitor.setNote("Complete");
                                JOptionPane.showMessageDialog(Main.this, "Passphrase changed", "Passphrase changed", 1);
                                break block7;
                            }
                            if (Main.this.keygen.getAction() == 1) {
                                progressMonitor.setNote("Converting key file");
                                Main.this.writeString(file2, SshKeyGenerator.convertPublicKeyFile((File)file, (SshPublicKeyFormat)new OpenSSHPublicKeyFormat()));
                                progressMonitor.setNote("Complete");
                                JOptionPane.showMessageDialog(Main.this, "Key converted", "Key converted", 1);
                                break block7;
                            }
                            if (Main.this.keygen.getAction() == 2) {
                                progressMonitor.setNote("Converting key file");
                                Main.this.writeString(file2, SshKeyGenerator.convertPublicKeyFile((File)file, (SshPublicKeyFormat)new SECSHPublicKeyFormat()));
                                progressMonitor.setNote("Complete");
                                JOptionPane.showMessageDialog(Main.this, "Key converted", "Key converted", 1);
                                break block7;
                            }
                            progressMonitor.setNote("Creating generator");
                            SshKeyGenerator sshKeyGenerator = new SshKeyGenerator();
                            progressMonitor.setNote("Generating");
                            String string3 = System.getProperty("user.name");
                            sshKeyGenerator.generateKeyPair(Main.this.keygen.getType(), Main.this.keygen.getBits(), file2.getAbsolutePath(), string3, string);
                            progressMonitor.setNote("Complete");
                            JOptionPane.showMessageDialog(Main.this, "Key generated to ".concat(String.valueOf(String.valueOf(file2.getName()))), "Complete", 1);
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(Main.this, exception.getMessage(), "Error", 0);
                            Object var4_5 = null;
                            progressMonitor.close();
                        }
                    }
                    Object var4_4 = null;
                    progressMonitor.close();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    progressMonitor.close();
                    throw throwable;
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Main main = new Main();
        main.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        main.pack();
        UIUtil.positionComponent(0, main);
        ((Component)main).setVisible(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeString(File file, String string) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(fileOutputStream, true);
            printWriter.println(string);
            Object var6_5 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }
}

