/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.MultilineLabel;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.util.BrowserLauncher;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AboutAction
extends StandardAction {
    private static final String ACTION_COMMAND_KEY_ABOUT = "about-command";
    private static final String NAME_ABOUT = "About";
    private static final String SMALL_ICON_ABOUT = "/com/sshtools/common/ui/about.png";
    private static final String LARGE_ICON_ABOUT = "";
    private static final int MNEMONIC_KEY_ABOUT = 65;
    private SshToolsApplication application;
    private Component parent;

    public AboutAction(Component component, SshToolsApplication sshToolsApplication) {
        this.application = sshToolsApplication;
        this.parent = component;
        this.putValue("Name", NAME_ABOUT);
        this.putValue("SmallIcon", this.getIcon(SMALL_ICON_ABOUT));
        this.putValue("LargeIcon", this.getIcon(LARGE_ICON_ABOUT));
        this.putValue("ShortDescription", "About ".concat(String.valueOf(String.valueOf(sshToolsApplication.getApplicationName()))));
        this.putValue("LongDescription", "Show information about ".concat(String.valueOf(String.valueOf(sshToolsApplication.getApplicationName()))));
        this.putValue("MnemonicKey", new Integer(65));
        this.putValue("ActionCommandKey", ACTION_COMMAND_KEY_ABOUT);
        this.putValue("onMenuBar", new Boolean(true));
        this.putValue("menuName", "Help");
        this.putValue("menuItemGroup", new Integer(90));
        this.putValue("menuItemWeight", new Integer(90));
        this.putValue("onToolBar", new Boolean(true));
        this.putValue("toolBarGroup", new Integer(90));
        this.putValue("toolBarWeight", new Integer(10));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        JLabel jLabel = new JLabel(this.application.getApplicationName());
        jLabel.setFont(jLabel.getFont().deriveFont(24.0f));
        UIUtil.jGridBagAdd(jPanel, jLabel, gridBagConstraints, 0);
        JLabel jLabel2 = new JLabel(ConfigurationLoader.getVersionString((String)this.application.getApplicationName(), (String)this.application.getApplicationVersion()));
        jLabel2.setFont(jLabel2.getFont().deriveFont(10.0f));
        UIUtil.jGridBagAdd(jPanel, jLabel2, gridBagConstraints, 0);
        MultilineLabel multilineLabel = new MultilineLabel(this.application.getAboutAuthors());
        multilineLabel.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
        multilineLabel.setFont(multilineLabel.getFont().deriveFont(12.0f));
        UIUtil.jGridBagAdd(jPanel, multilineLabel, gridBagConstraints, 0);
        MultilineLabel multilineLabel2 = new MultilineLabel(this.application.getAboutLicenseDetails());
        multilineLabel2.setFont(multilineLabel2.getFont().deriveFont(10.0f));
        UIUtil.jGridBagAdd(jPanel, multilineLabel2, gridBagConstraints, 0);
        JLabel jLabel3 = new JLabel(this.application.getAboutURL());
        jLabel3.setForeground(Color.blue);
        jLabel3.setFont(new Font(jLabel3.getFont().getName(), 1, 10));
        jLabel3.setCursor(Cursor.getPredefinedCursor(12));
        jLabel3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    BrowserLauncher.openURL(AboutAction.this.application.getAboutURL());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
        UIUtil.jGridBagAdd(jPanel, jLabel3, gridBagConstraints, 0);
        JOptionPane.showMessageDialog(this.parent, jPanel, NAME_ABOUT, -1, this.application.getApplicationLargeIcon());
    }
}

