/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreferencesStore {
    protected static Log log = LogFactory.getLog((Class)(class$com$sshtools$common$ui$PreferencesStore == null ? (class$com$sshtools$common$ui$PreferencesStore = PreferencesStore.class$("com.sshtools.common.ui.PreferencesStore")) : class$com$sshtools$common$ui$PreferencesStore));
    private static File file;
    private static boolean storeAvailable;
    private static Properties preferences;
    static /* synthetic */ Class class$com$sshtools$common$ui$PreferencesStore;

    public static void saveTableMetrics(JTable jTable, String string) {
        for (int i = 0; i < jTable.getColumnModel().getColumnCount(); ++i) {
            int n = jTable.getColumnModel().getColumn(i).getWidth();
            PreferencesStore.put(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(".column.").append(i).append(".width"))), String.valueOf(n));
            PreferencesStore.put(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(".column.").append(i).append(".position"))), String.valueOf(jTable.convertColumnIndexToModel(i)));
        }
    }

    public static void restoreTableMetrics(JTable jTable, String string, int[] nArray) {
        if (jTable.getAutoResizeMode() != 0) {
            throw new IllegalArgumentException("Table AutoResizeMode must be JTable.AUTO_RESIZE_OFF");
        }
        for (int i = 0; i < jTable.getColumnModel().getColumnCount(); ++i) {
            try {
                jTable.moveColumn(jTable.convertColumnIndexToView(PreferencesStore.getInt(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(".column.").append(i).append(".position"))), i)), i);
                jTable.getColumnModel().getColumn(i).setPreferredWidth(PreferencesStore.getInt(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(".column.").append(i).append(".width"))), nArray == null ? jTable.getColumnModel().getColumn(i).getPreferredWidth() : nArray[i]));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static boolean isStoreAvailable() {
        return storeAvailable;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(File file) {
        PreferencesStore.file = file;
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            log.info((Object)"Creating SSHTerm preferences directory ".concat(String.valueOf(String.valueOf(file2.getAbsolutePath()))));
            if (!file2.mkdirs()) {
                log.error((Object)String.valueOf(String.valueOf(new StringBuffer("Preferences directory ").append(file2.getAbsolutePath()).append(" could not be created. ").append("Preferences will not be stored"))));
            }
        }
        if (!(storeAvailable = file2.exists())) return;
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            fileInputStream = new FileInputStream(file);
            preferences.load(fileInputStream);
            storeAvailable = true;
            Object var5_3 = null;
            if (fileInputStream == null) return;
            try {
                ((InputStream)fileInputStream).close();
                return;
            }
            catch (IOException iOException) {}
            return;
            {
                catch (IOException iOException) {
                    log.error((Object)iOException);
                    Object var5_4 = null;
                    if (fileInputStream == null) return;
                    try {
                        ((InputStream)fileInputStream).close();
                        return;
                    }
                    catch (IOException iOException2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (fileInputStream == null) throw throwable;
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        PreferencesStore.savePreferences();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void savePreferences() {
        FileOutputStream fileOutputStream;
        if (file == null) {
            log.error((Object)"Preferences not saved as PreferencesStore has not been initialise.");
            return;
        } else {
            fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file);
            preferences.store(fileOutputStream, "SSHTerm preferences");
            log.info((Object)"Preferences written to ".concat(String.valueOf(String.valueOf(file.getAbsolutePath()))));
            storeAvailable = true;
            Object var3_1 = null;
            if (fileOutputStream == null) return;
            try {
                ((OutputStream)fileOutputStream).close();
                return;
            }
            catch (IOException iOException) {}
        }
        return;
        {
            catch (IOException iOException) {
                log.error((Object)iOException);
                Object var3_2 = null;
                if (fileOutputStream == null) return;
                try {
                    ((OutputStream)fileOutputStream).close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static String get(String string, String string2) {
        return preferences.getProperty(string, string2);
    }

    public static void put(String string, String string2) {
        ((Hashtable)preferences).put(string, string2);
    }

    public static Rectangle getRectangle(String string, Rectangle rectangle) {
        String string2 = preferences.getProperty(string);
        if (string2 == null || string2.equals("")) {
            return rectangle;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        Rectangle rectangle2 = new Rectangle();
        try {
            rectangle2.x = Integer.parseInt(stringTokenizer.nextToken());
            rectangle2.y = Integer.parseInt(stringTokenizer.nextToken());
            rectangle2.width = Integer.parseInt(stringTokenizer.nextToken());
            rectangle2.height = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            log.warn((Object)String.valueOf(String.valueOf(new StringBuffer("Preference is ").append(string).append(" is badly formatted"))), (Throwable)numberFormatException);
        }
        return rectangle2;
    }

    public static void putRectangle(String string, Rectangle rectangle) {
        ((Hashtable)preferences).put(string, rectangle == null ? "" : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(rectangle.x))).append(",").append(rectangle.y).append(",").append(rectangle.width).append(",").append(rectangle.height))));
    }

    public static int getInt(String string, int n) {
        String string2 = preferences.getProperty(string);
        if (string2 != null && !string2.equals("")) {
            try {
                int n2 = Integer.parseInt(string2);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                log.warn((Object)String.valueOf(String.valueOf(new StringBuffer("Preference is ").append(string).append(" is badly formatted"))), (Throwable)numberFormatException);
            }
        }
        return n;
    }

    public static double getDouble(String string, double d) {
        String string2 = preferences.getProperty(string);
        if (string2 != null && !string2.equals("")) {
            try {
                double d2 = Double.parseDouble(string2);
                return d2;
            }
            catch (NumberFormatException numberFormatException) {
                log.warn((Object)String.valueOf(String.valueOf(new StringBuffer("Preference is ").append(string).append(" is badly formatted"))), (Throwable)numberFormatException);
            }
        }
        return d;
    }

    public static void putInt(String string, int n) {
        ((Hashtable)preferences).put(string, String.valueOf(n));
    }

    public static void putDouble(String string, double d) {
        ((Hashtable)preferences).put(string, String.valueOf(d));
    }

    public static boolean getBoolean(String string, boolean bl) {
        return PreferencesStore.get(string, String.valueOf(bl)).equals("true");
    }

    public static void putBoolean(String string, boolean bl) {
        ((Hashtable)preferences).put(string, String.valueOf(bl));
    }

    public static boolean preferenceExists(String string) {
        return ((Hashtable)preferences).containsKey(string);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        preferences = new Properties();
    }
}

