/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.mru.MRUList;
import com.sshtools.common.mru.MRUListModel;
import com.sshtools.common.ui.OptionsTab;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.j2ssh.io.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplication {
    public static final String PREF_CONNECTION_LAST_HOST = "apps.connection.lastHost";
    public static final String PREF_CONNECTION_LAST_USER = "apps.connection.lastUser";
    public static final String PREF_CONNECTION_LAST_PORT = "apps.connection.lastPort";
    public static final String PREF_CONNECTION_LAST_KEY = "apps.connection.lastKey";
    public static final String PREF_LAF = "apps.laf";
    public static final String CROSS_PLATFORM_LAF = "CROSS_PLATFORM";
    public static final String DEFAULT_LAF = "DEFAULT";
    public static final String SYSTEM_LAF = "SYSTEM";
    protected static Vector containers;
    protected static Log log;
    protected static MRUListModel mruModel;
    private static UIManager.LookAndFeelInfo[] allLookAndFeelInfo;
    protected Class panelClass;
    protected Class defaultContainerClass;
    protected List additionalOptionsTabs;
    static /* synthetic */ Class class$com$sshtools$common$ui$SshToolsApplication;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SshToolsApplication(Class clazz, Class clazz2) {
        this.panelClass = clazz;
        this.defaultContainerClass = clazz2;
        this.additionalOptionsTabs = new ArrayList();
        try {
            MRUList mRUList;
            block11: {
                File file;
                if (System.getSecurityManager() != null) {
                    AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
                }
                if ((file = this.getApplicationPreferencesDirectory()) == null) {
                    throw new AccessControlException("Application preferences directory not specified.");
                }
                FileInputStream fileInputStream = null;
                mRUList = new MRUList();
                try {
                    block10: {
                        try {
                            File file2 = new File(file, String.valueOf(String.valueOf(this.getApplicationName())).concat(".mru"));
                            if (file2.exists()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Loading MRU from ".concat(String.valueOf(String.valueOf(file2.getAbsolutePath()))));
                                }
                                fileInputStream = new FileInputStream(file2);
                                mRUList.reload(fileInputStream);
                                break block10;
                            }
                            if (!log.isDebugEnabled()) break block10;
                            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("MRU file ").append(file2.getAbsolutePath()).append(" doesn't exist, creating empty list"))));
                        }
                        catch (Exception exception) {
                            log.error((Object)"Could not load MRU list.", (Throwable)exception);
                            Object var8_10 = null;
                            IOUtil.closeStream(fileInputStream);
                            break block11;
                        }
                    }
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    IOUtil.closeStream(fileInputStream);
                    throw throwable;
                }
                IOUtil.closeStream((InputStream)fileInputStream);
            }
            mruModel = new MRUListModel();
            mruModel.setMRUList(mRUList);
            return;
        }
        catch (AccessControlException accessControlException) {
            log.error((Object)"Could not load MRU.", (Throwable)accessControlException);
        }
    }

    public static UIManager.LookAndFeelInfo[] getAllLookAndFeelInfo() {
        return allLookAndFeelInfo;
    }

    public MRUListModel getMRUModel() {
        return mruModel;
    }

    public abstract String getApplicationName();

    public abstract String getApplicationVersion();

    public abstract Icon getApplicationLargeIcon();

    public abstract String getAboutLicenseDetails();

    public abstract String getAboutURL();

    public abstract String getAboutAuthors();

    public abstract File getApplicationPreferencesDirectory();

    public OptionsTab[] getAdditionalOptionsTabs() {
        OptionsTab[] optionsTabArray = new OptionsTab[this.additionalOptionsTabs.size()];
        this.additionalOptionsTabs.toArray(optionsTabArray);
        return optionsTabArray;
    }

    public void addAdditionalOptionsTab(OptionsTab optionsTab) {
        this.additionalOptionsTabs.add(optionsTab);
    }

    public void removeAdditionalOptionsTab(OptionsTab optionsTab) {
        this.additionalOptionsTabs.remove(optionsTab);
    }

    public void removeAdditionalOptionsTab(String string) {
        OptionsTab optionsTab = this.getOptionsTab(string);
        if (optionsTab != null) {
            this.removeAdditionalOptionsTab(optionsTab);
        }
    }

    public OptionsTab getOptionsTab(String string) {
        Iterator iterator = this.additionalOptionsTabs.iterator();
        while (iterator.hasNext()) {
            OptionsTab optionsTab = (OptionsTab)iterator.next();
            if (!optionsTab.getTabTitle().equals(string)) continue;
            return optionsTab;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exit() {
        block7: {
            log.debug((Object)"Exiting application");
            PreferencesStore.savePreferences();
            FileOutputStream fileOutputStream = null;
            File file = this.getApplicationPreferencesDirectory();
            if (file != null) {
                try {
                    try {
                        File file2 = new File(this.getApplicationPreferencesDirectory(), String.valueOf(String.valueOf(this.getApplicationName())).concat(".mru"));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Saving MRU to ".concat(String.valueOf(String.valueOf(file2.getAbsolutePath()))));
                        }
                        fileOutputStream = new FileOutputStream(file2);
                        PrintWriter printWriter = new PrintWriter(fileOutputStream, true);
                        printWriter.println(mruModel.getMRUList().toString());
                    }
                    catch (IOException iOException) {
                        log.error((Object)"Could not save MRU. ", (Throwable)iOException);
                        Object var6_7 = null;
                        IOUtil.closeStream(fileOutputStream);
                        break block7;
                    }
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    IOUtil.closeStream(fileOutputStream);
                    throw throwable;
                }
                IOUtil.closeStream((OutputStream)fileOutputStream);
            } else {
                log.debug((Object)"Not saving preferences because no preferences directory is available.");
            }
        }
        System.exit(0);
    }

    public int getContainerCount() {
        return containers.size();
    }

    public SshToolsApplicationContainer getContainerAt(int n) {
        return (SshToolsApplicationContainer)containers.elementAt(n);
    }

    public SshToolsApplicationContainer getContainerForPanel(SshToolsApplicationPanel sshToolsApplicationPanel) {
        Iterator iterator = ((AbstractList)containers).iterator();
        while (iterator.hasNext()) {
            SshToolsApplicationContainer sshToolsApplicationContainer = (SshToolsApplicationContainer)iterator.next();
            if (sshToolsApplicationContainer.getApplicationPanel() != sshToolsApplicationPanel) continue;
            return sshToolsApplicationContainer;
        }
        return null;
    }

    public void closeContainer(SshToolsApplicationContainer sshToolsApplicationContainer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Asking ").append(sshToolsApplicationContainer).append(" if it can close"))));
        }
        if (sshToolsApplicationContainer.getApplicationPanel().canClose()) {
            Iterator iterator;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Closing");
                iterator = ((AbstractList)containers).iterator();
                while (iterator.hasNext()) {
                    log.debug((Object)String.valueOf(String.valueOf(iterator.next())).concat(" is currently open"));
                }
            }
            sshToolsApplicationContainer.getApplicationPanel().close();
            sshToolsApplicationContainer.closeContainer();
            containers.removeElement(sshToolsApplicationContainer);
            if (containers.size() == 0) {
                this.exit();
            } else {
                log.debug((Object)"Not closing completely because there are containers still open");
                iterator = ((AbstractList)containers).iterator();
                while (iterator.hasNext()) {
                    log.debug((Object)String.valueOf(String.valueOf(iterator.next())).concat(" is still open"));
                }
            }
        }
    }

    public SshToolsApplicationContainer newContainer() throws SshToolsApplicationException {
        SshToolsApplicationContainer sshToolsApplicationContainer = null;
        try {
            sshToolsApplicationContainer = (SshToolsApplicationContainer)this.defaultContainerClass.newInstance();
            this.newContainer(sshToolsApplicationContainer);
            SshToolsApplicationContainer sshToolsApplicationContainer2 = sshToolsApplicationContainer;
            return sshToolsApplicationContainer2;
        }
        catch (Throwable throwable) {
            throw new SshToolsApplicationException(throwable);
        }
    }

    public void newContainer(SshToolsApplicationContainer sshToolsApplicationContainer) throws SshToolsApplicationException {
        try {
            SshToolsApplicationPanel sshToolsApplicationPanel = (SshToolsApplicationPanel)this.panelClass.newInstance();
            sshToolsApplicationPanel.init(this);
            sshToolsApplicationPanel.rebuildActionComponents();
            sshToolsApplicationPanel.setAvailableActions();
            sshToolsApplicationContainer.init(this, sshToolsApplicationPanel);
            sshToolsApplicationPanel.setContainer(sshToolsApplicationContainer);
            if (!sshToolsApplicationContainer.isContainerVisible()) {
                sshToolsApplicationContainer.setContainerVisible(true);
            }
            containers.addElement(sshToolsApplicationContainer);
        }
        catch (Throwable throwable) {
            throw new SshToolsApplicationException(throwable);
        }
    }

    public SshToolsApplicationContainer convertContainer(SshToolsApplicationContainer sshToolsApplicationContainer, Class clazz) throws SshToolsApplicationException {
        log.info((Object)String.valueOf(String.valueOf(new StringBuffer("Converting container of class ").append(sshToolsApplicationContainer.getClass().getName()).append(" to ").append(clazz.getName()))));
        int n = containers.indexOf(sshToolsApplicationContainer);
        if (n == -1) {
            throw new SshToolsApplicationException("Container is not being manager by the application.");
        }
        SshToolsApplicationContainer sshToolsApplicationContainer2 = null;
        try {
            sshToolsApplicationContainer.closeContainer();
            SshToolsApplicationPanel sshToolsApplicationPanel = sshToolsApplicationContainer.getApplicationPanel();
            sshToolsApplicationContainer2 = (SshToolsApplicationContainer)clazz.newInstance();
            sshToolsApplicationContainer2.init(this, sshToolsApplicationPanel);
            sshToolsApplicationPanel.setContainer(sshToolsApplicationContainer2);
            if (!sshToolsApplicationContainer2.isContainerVisible()) {
                sshToolsApplicationContainer2.setContainerVisible(true);
            }
            containers.setElementAt(sshToolsApplicationContainer2, n);
            SshToolsApplicationContainer sshToolsApplicationContainer3 = sshToolsApplicationContainer2;
            return sshToolsApplicationContainer3;
        }
        catch (Throwable throwable) {
            throw new SshToolsApplicationException(throwable);
        }
    }

    public void init(String[] stringArray) throws SshToolsApplicationException {
        File file = this.getApplicationPreferencesDirectory();
        if (file != null) {
            PreferencesStore.init(new File(file, String.valueOf(String.valueOf(this.getApplicationName())).concat(".properties")));
            log.info((Object)"Preferences will be saved to ".concat(String.valueOf(String.valueOf(file.getAbsolutePath()))));
        } else {
            log.warn((Object)"No preferences can be saved.");
        }
        try {
            SshToolsApplication.setLookAndFeel(PreferencesStore.get(PREF_LAF, SYSTEM_LAF));
            UIManager.put("OptionPane.errorIcon", new ResourceIcon("/com/sshtools/common/ui/dialog-error4.png"));
            UIManager.put("OptionPane.informationIcon", new ResourceIcon("/com/sshtools/common/ui/dialog-information.png"));
            UIManager.put("OptionPane.warningIcon", new ResourceIcon("/com/sshtools/common/ui/dialog-warning2.png"));
            UIManager.put("OptionPane.questionIcon", new ResourceIcon("/com/sshtools/common/ui/dialog-question3.png"));
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
    }

    public static void setLookAndFeel(String string) throws Exception {
        LookAndFeel lookAndFeel = null;
        if (!string.equals(DEFAULT_LAF)) {
            if (string.equals(SYSTEM_LAF)) {
                String string2 = UIManager.getSystemLookAndFeelClassName();
                log.debug((Object)"System Look And Feel is ".concat(String.valueOf(String.valueOf(string2))));
                lookAndFeel = (LookAndFeel)Class.forName(string2).newInstance();
            } else if (string.equals(CROSS_PLATFORM_LAF)) {
                String string3 = UIManager.getCrossPlatformLookAndFeelClassName();
                log.debug((Object)"Cross Platform Look And Feel is ".concat(String.valueOf(String.valueOf(string3))));
                lookAndFeel = (LookAndFeel)Class.forName(string3).newInstance();
            } else {
                lookAndFeel = (LookAndFeel)Class.forName(string).newInstance();
            }
        }
        if (lookAndFeel != null) {
            log.info((Object)String.valueOf(String.valueOf(new StringBuffer("Setting look and feel ").append(lookAndFeel.getName()).append(" (").append(lookAndFeel.getClass().getName()).append(")"))));
            UIManager.setLookAndFeel(lookAndFeel);
            UIManager.put("EditorPane.font", UIManager.getFont("TextArea.font"));
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        containers = new Vector();
        log = LogFactory.getLog((Class)(class$com$sshtools$common$ui$SshToolsApplication == null ? (class$com$sshtools$common$ui$SshToolsApplication = SshToolsApplication.class$("com.sshtools.common.ui.SshToolsApplication")) : class$com$sshtools$common$ui$SshToolsApplication));
        try {
            lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        }
        catch (Throwable throwable) {
            lookAndFeelInfoArray = new UIManager.LookAndFeelInfo[]{};
        }
        allLookAndFeelInfo = new UIManager.LookAndFeelInfo[lookAndFeelInfoArray.length + 3];
        System.arraycopy(lookAndFeelInfoArray, 0, allLookAndFeelInfo, 0, lookAndFeelInfoArray.length);
        SshToolsApplication.allLookAndFeelInfo[lookAndFeelInfoArray.length] = new UIManager.LookAndFeelInfo("Default", DEFAULT_LAF);
        SshToolsApplication.allLookAndFeelInfo[lookAndFeelInfoArray.length + 1] = new UIManager.LookAndFeelInfo("Cross Platform", CROSS_PLATFORM_LAF);
        SshToolsApplication.allLookAndFeelInfo[lookAndFeelInfoArray.length + 2] = new UIManager.LookAndFeelInfo("System", SYSTEM_LAF);
    }
}

