/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.MenuAction;
import com.sshtools.common.ui.MultilineLabel;
import com.sshtools.common.ui.OptionsAction;
import com.sshtools.common.ui.OptionsPanel;
import com.sshtools.common.ui.OptionsTab;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.StatusBar;
import com.sshtools.common.ui.ToolBarSeparator;
import com.sshtools.common.ui.ToolButton;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplicationPanel
extends JPanel {
    protected Log log = LogFactory.getLog((Class)(class$com$sshtools$common$ui$SshToolsApplicationPanel == null ? (class$com$sshtools$common$ui$SshToolsApplicationPanel = SshToolsApplicationPanel.class$("com.sshtools.common.ui.SshToolsApplicationPanel")) : class$com$sshtools$common$ui$SshToolsApplicationPanel));
    protected SshToolsApplication application;
    protected JMenuBar menuBar;
    protected JToolBar toolBar;
    protected JPopupMenu contextMenu;
    protected SshToolsApplicationContainer container;
    protected Vector actions = new Vector();
    protected HashMap actionsVisible = new HashMap();
    protected boolean toolsVisible;
    protected Vector actionMenus = new Vector();
    static /* synthetic */ Class class$com$sshtools$common$ui$SshToolsApplicationPanel;

    public SshToolsApplicationPanel() {
    }

    public SshToolsApplicationPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public abstract boolean canClose();

    public abstract void close();

    public abstract void setAvailableActions();

    public void setActionVisible(String string, boolean bl) {
        this.log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Setting action '").append(string).append("' to visibility ").append(bl))));
        this.actionsVisible.put(string, bl);
    }

    public SshToolsApplicationContainer getContainer() {
        return this.container;
    }

    public void setContainer(SshToolsApplicationContainer sshToolsApplicationContainer) {
        this.container = sshToolsApplicationContainer;
    }

    public void registerActionMenu(ActionMenu actionMenu) {
        ActionMenu actionMenu2 = this.getActionMenu(actionMenu.name);
        if (actionMenu2 == null) {
            this.actionMenus.addElement(actionMenu);
        }
    }

    public ActionMenu getActionMenu(String string) {
        return this.getActionMenu(((AbstractList)this.actionMenus).iterator(), string);
    }

    private ActionMenu getActionMenu(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            ActionMenu actionMenu = (ActionMenu)iterator.next();
            if (!actionMenu.name.equals(string)) continue;
            return actionMenu;
        }
        return null;
    }

    public StandardAction getAction(String string) {
        Iterator iterator = ((AbstractList)this.actions).iterator();
        while (iterator.hasNext()) {
            StandardAction standardAction = (StandardAction)iterator.next();
            if (!standardAction.getName().equals(string)) continue;
            return standardAction;
        }
        return null;
    }

    public void deregisterAction(StandardAction standardAction) {
        this.actions.removeElement(standardAction);
    }

    public void registerAction(StandardAction standardAction) {
        this.actions.addElement(standardAction);
    }

    public void init(SshToolsApplication sshToolsApplication) throws SshToolsApplicationException {
        this.application = sshToolsApplication;
        this.menuBar = new JMenuBar();
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setBorderPainted(false);
        this.toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.contextMenu = new JPopupMenu();
        this.registerActionMenu(new ActionMenu("Tools", "Tools", 116, 30));
        if (PreferencesStore.isStoreAvailable()) {
            this.log.debug((Object)"Preferences store is available, adding options action");
            this.registerAction(new OptionsAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SshToolsApplicationPanel.this.showOptions();
                }
            });
        }
    }

    public void showOptions() {
        OptionsTab[] optionsTabArray = this.getApplication().getAdditionalOptionsTabs();
        OptionsPanel.showOptionsDialog(this, optionsTabArray);
    }

    public void rebuildActionComponents() {
        Cloneable cloneable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Cloneable cloneable2;
        Object object5;
        Object object6;
        Object object7;
        this.log.debug((Object)"Rebuild action components");
        this.toolBar.removeAll();
        Vector<Object> vector = new Vector<Object>();
        Object object8 = ((AbstractList)this.actions).iterator();
        while (object8.hasNext()) {
            object7 = (StandardAction)object8.next();
            object6 = (String)((AbstractAction)object7).getValue("Name");
            object5 = (Boolean)this.actionsVisible.get(object6);
            if (object5 == null) {
                object5 = Boolean.TRUE;
            }
            if (Boolean.TRUE.equals(object5)) {
                this.log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Action ").append((String)object6).append(" is enabled."))));
                vector.add(object7);
                continue;
            }
            this.log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Action ").append((String)object6).append(" not enabled."))));
        }
        object8 = new Vector();
        object7 = ((AbstractList)vector).iterator();
        while (object7.hasNext()) {
            object6 = (StandardAction)object7.next();
            if (!Boolean.TRUE.equals((Boolean)((AbstractAction)object6).getValue("onToolBar"))) continue;
            ((Vector)object8).addElement(object6);
        }
        Collections.sort(object8, new ToolBarActionComparator(this));
        object7 = null;
        object6 = ((AbstractList)object8).iterator();
        while (object6.hasNext()) {
            object5 = (StandardAction)object6.next();
            if (object7 != null && !((Integer)object7).equals((Integer)((AbstractAction)object5).getValue("toolBarGroup"))) {
                this.toolBar.add(new ToolBarSeparator());
            }
            this.toolBar.add(new ToolButton((Action)object5));
            object7 = (Integer)((AbstractAction)object5).getValue("toolBarGroup");
        }
        this.toolBar.revalidate();
        this.toolBar.repaint();
        object6 = new Vector();
        this.contextMenu.removeAll();
        object5 = ((AbstractList)vector).iterator();
        while (object5.hasNext()) {
            cloneable2 = (StandardAction)object5.next();
            if (!Boolean.TRUE.equals((Boolean)((AbstractAction)cloneable2).getValue("onContextMenu"))) continue;
            ((Vector)object6).addElement(cloneable2);
        }
        Collections.sort(object6, new ContextActionComparator(this));
        object7 = null;
        object5 = ((AbstractList)object6).iterator();
        while (object5.hasNext()) {
            cloneable2 = (StandardAction)object5.next();
            if (object7 != null && !((Integer)object7).equals((Integer)((AbstractAction)cloneable2).getValue("contextMenuGroup"))) {
                this.contextMenu.addSeparator();
            }
            this.contextMenu.add((Action)((Object)cloneable2));
            object7 = (Integer)((AbstractAction)cloneable2).getValue("contextMenuGroup");
        }
        this.contextMenu.revalidate();
        this.menuBar.removeAll();
        ((Vector)object8).removeAllElements();
        object5 = vector.elements();
        while (object5.hasMoreElements()) {
            cloneable2 = (StandardAction)object5.nextElement();
            if (!Boolean.TRUE.equals((Boolean)((AbstractAction)cloneable2).getValue("onMenuBar"))) continue;
            ((Vector)object8).addElement(cloneable2);
        }
        object5 = (Vector)this.actionMenus.clone();
        Collections.sort(object5);
        cloneable2 = new HashMap();
        Iterator iterator = ((AbstractList)object8).iterator();
        while (iterator.hasNext()) {
            object4 = (StandardAction)iterator.next();
            object3 = (String)((AbstractAction)object4).getValue("menuName");
            if (object3 == null) {
                this.log.error((Object)String.valueOf(String.valueOf(new StringBuffer("Action ").append(((StandardAction)object4).getName()).append(" doesnt specify a value for ").append("menuName"))));
                continue;
            }
            object2 = (String)((AbstractAction)object4).getValue("menuName");
            object = this.getActionMenu(((AbstractList)object5).iterator(), (String)object2);
            if (object == null) {
                this.log.error((Object)String.valueOf(String.valueOf(new StringBuffer("Action menu ").append(((StandardAction)object4).getName()).append(" does not exist"))));
                continue;
            }
            cloneable = (Vector<Object>)((HashMap)cloneable2).get(((ActionMenu)object).name);
            if (cloneable == null) {
                cloneable = new Vector<Object>();
                ((HashMap)cloneable2).put(((ActionMenu)object).name, cloneable);
            }
            ((Vector)cloneable).addElement(object4);
        }
        iterator = ((AbstractList)object5).iterator();
        while (iterator.hasNext()) {
            object4 = (ActionMenu)iterator.next();
            object3 = (Vector)((HashMap)cloneable2).get(((ActionMenu)object4).name);
            if (object3 != null) {
                Collections.sort(object3, new MenuItemActionComparator(this));
                object2 = new JMenu(((ActionMenu)object4).displayName);
                ((AbstractButton)object2).setMnemonic(((ActionMenu)object4).mnemonic);
                object7 = null;
                object = ((AbstractList)object3).iterator();
                while (object.hasNext()) {
                    JMenuItem jMenuItem;
                    cloneable = (StandardAction)object.next();
                    Integer n = (Integer)((AbstractAction)cloneable).getValue("menuItemGroup");
                    if (object7 != null && !n.equals(object7)) {
                        ((JMenu)object2).addSeparator();
                    }
                    object7 = n;
                    if (cloneable instanceof MenuAction) {
                        jMenuItem = (JMenu)((AbstractAction)cloneable).getValue("menu");
                        ((JMenu)object2).add(jMenuItem);
                        continue;
                    }
                    jMenuItem = new JMenuItem((Action)((Object)cloneable));
                    ((JMenu)object2).add(jMenuItem);
                }
                this.menuBar.add((JMenu)object2);
                continue;
            }
            this.log.error((Object)"Can't find menu ".concat(String.valueOf(String.valueOf(((ActionMenu)object4).name))));
        }
        this.menuBar.validate();
        this.menuBar.repaint();
    }

    public boolean isToolsVisible() {
        return this.toolsVisible;
    }

    public void setMenuBarVisible(boolean bl) {
        if (this.getJMenuBar() != null && this.getJMenuBar().isVisible() != bl) {
            this.getJMenuBar().setVisible(bl);
            this.revalidate();
        }
    }

    public void setToolBarVisible(boolean bl) {
        if (this.getToolBar() != null && this.getToolBar().isVisible() != bl) {
            this.getToolBar().setVisible(bl);
            this.revalidate();
        }
    }

    public void setStatusBarVisible(boolean bl) {
        if (this.getStatusBar() != null && this.getStatusBar().isVisible() != bl) {
            this.getStatusBar().setVisible(bl);
            this.revalidate();
        }
    }

    public void setToolsVisible(boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.getToolBar() != null && this.getToolBar().isVisible() != bl) {
                this.getToolBar().setVisible(bl);
            }
            if (this.getJMenuBar() != null && this.getJMenuBar().isVisible() != bl) {
                this.getJMenuBar().setVisible(bl);
            }
            if (this.getStatusBar() != null && this.getStatusBar().isVisible() != bl) {
                this.getStatusBar().setVisible(bl);
            }
            this.toolsVisible = bl;
            this.revalidate();
        }
    }

    public void showExceptionMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this, string2, string, 0);
    }

    public void showErrorMessage(Component component, String string, Throwable throwable) {
        this.showErrorMessage(component, null, string, throwable);
    }

    public void showErrorMessage(Component component, String string, String string2, Throwable throwable) {
        boolean bl = false;
        while (true) {
            Object[] objectArray = new String[]{bl ? "Hide Details" : "Details", "Ok"};
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append(string);
            }
            this.appendException(throwable, 0, stringBuffer, bl);
            MultilineLabel multilineLabel = new MultilineLabel(stringBuffer.toString());
            int n = JOptionPane.showOptionDialog(component, multilineLabel, string2, 2, 0, null, objectArray, objectArray[1]);
            if (n != 0) break;
            bl = !bl;
        }
    }

    private void appendException(Throwable throwable, int n, StringBuffer stringBuffer, boolean bl) {
        Object object;
        if (throwable.getMessage() != null && throwable.getMessage().length() > 0) {
            if (bl && n > 0) {
                stringBuffer.append("\n \nCaused by ...\n");
            }
            stringBuffer.append(throwable.getMessage());
        }
        if (bl) {
            if (throwable.getMessage() == null || throwable.getMessage().length() == 0) {
                stringBuffer.append("\n \nCaused by ...");
            } else {
                stringBuffer.append("\n \n");
            }
            object = new StringWriter();
            throwable.printStackTrace(new PrintWriter((Writer)object));
            stringBuffer.append(((StringWriter)object).toString());
        }
        try {
            object = throwable.getClass().getMethod("getCause", new Class[0]);
            Throwable throwable2 = (Throwable)((Method)object).invoke((Object)throwable, null);
            if (throwable2 != null) {
                this.appendException(throwable2, n + 1, stringBuffer, bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract boolean isConnected();

    public void setContainerTitle(File file) {
        String string = ConfigurationLoader.getVersionString((String)this.application.getApplicationName(), (String)this.application.getApplicationVersion());
        this.container.setContainerTitle(file == null ? string : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" [").append(file.getName()).append("]"))));
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JPopupMenu getContextMenu() {
        return this.contextMenu;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public StatusBar getStatusBar() {
        return null;
    }

    public SshToolsApplication getApplication() {
        return this.application;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConnectionFileFilter
    extends FileFilter {
        ConnectionFileFilter(SshToolsApplicationPanel sshToolsApplicationPanel) {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
        }

        public String getDescription() {
            return "Connection files (*.xml)";
        }
    }

    class MenuItemActionComparator
    implements Comparator {
        MenuItemActionComparator(SshToolsApplicationPanel sshToolsApplicationPanel) {
        }

        public int compare(Object object, Object object2) {
            int n = ((Integer)((StandardAction)object).getValue("menuItemGroup")).compareTo((Integer)((StandardAction)object2).getValue("menuItemGroup"));
            return n == 0 ? ((Integer)((StandardAction)object).getValue("menuItemWeight")).compareTo((Integer)((StandardAction)object2).getValue("menuItemWeight")) : n;
        }
    }

    class ContextActionComparator
    implements Comparator {
        ContextActionComparator(SshToolsApplicationPanel sshToolsApplicationPanel) {
        }

        public int compare(Object object, Object object2) {
            int n = ((Integer)((StandardAction)object).getValue("contextMenuGroup")).compareTo((Integer)((StandardAction)object2).getValue("contextMenuGroup"));
            return n == 0 ? ((Integer)((StandardAction)object).getValue("contextMenuWeight")).compareTo((Integer)((StandardAction)object2).getValue("contextMenuWeight")) : n;
        }
    }

    class ToolBarActionComparator
    implements Comparator {
        ToolBarActionComparator(SshToolsApplicationPanel sshToolsApplicationPanel) {
        }

        public int compare(Object object, Object object2) {
            int n = ((Integer)((StandardAction)object).getValue("toolBarGroup")).compareTo((Integer)((StandardAction)object2).getValue("toolBarGroup"));
            return n == 0 ? ((Integer)((StandardAction)object).getValue("toolBarWeight")).compareTo((Integer)((StandardAction)object2).getValue("toolBarWeight")) : n;
        }
    }

    public static class ActionMenu
    implements Comparable {
        int weight;
        int mnemonic;
        String name;
        String displayName;

        public ActionMenu(String string, String string2, int n, int n2) {
            this.name = string;
            this.displayName = string2;
            this.mnemonic = n;
            this.weight = n2;
        }

        public int compareTo(Object object) {
            int n = new Integer(this.weight).compareTo(new Integer(((ActionMenu)object).weight));
            return n == 0 ? this.displayName.compareTo(((ActionMenu)object).displayName) : n;
        }
    }
}

