/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.EmptyIcon;
import com.sshtools.common.ui.ResourceIcon;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class XTextField
extends JTextField
implements ClipboardOwner {
    private JPopupMenu popup;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action deleteAction;
    private Action selectAllAction;

    public XTextField() {
        this(null, null, 0);
    }

    public XTextField(String string) {
        this(null, string, 0);
    }

    public XTextField(int n) {
        this(null, null, n);
    }

    public XTextField(String string, int n) {
        this(null, string, n);
    }

    public XTextField(Document document, String string, int n) {
        super(document, string, n);
        this.initXtensions();
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private void showPopup(int n, int n2) {
        this.requestFocus();
        if (this.popup == null) {
            this.popup = new JPopupMenu("Clipboard");
            this.cutAction = new CutAction();
            this.popup.add(this.cutAction);
            this.copyAction = new CopyAction();
            this.popup.add(this.copyAction);
            this.pasteAction = new PasteAction();
            this.popup.add(this.pasteAction);
            this.deleteAction = new DeleteAction();
            this.popup.add(this.deleteAction);
            this.popup.addSeparator();
            this.selectAllAction = new SelectAllAction();
            this.popup.add(this.selectAllAction);
        }
        this.cutAction.setEnabled(this.isEnabled() && this.getSelectedText() != null);
        this.copyAction.setEnabled(this.isEnabled() && this.getSelectedText() != null);
        this.deleteAction.setEnabled(this.isEnabled() && this.getSelectedText() != null);
        this.pasteAction.setEnabled(this.isEnabled() && Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).isDataFlavorSupported(DataFlavor.stringFlavor));
        this.selectAllAction.setEnabled(this.isEnabled());
        this.popup.show(this, n, n2);
    }

    private void initXtensions() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    XTextField.this.showPopup(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                XTextField.this.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    class SelectAllAction
    extends AbstractAction {
        SelectAllAction() {
            this.putValue("SmallIcon", new EmptyIcon(16, 16));
            this.putValue("Name", "Select All");
            this.putValue("ShortDescription", "Select All");
            this.putValue("LongDescription", "Select all items in the context");
            this.putValue("MnemonicKey", new Integer(97));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XTextField.this.selectAll();
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            this.putValue("Name", "Delete");
            this.putValue("SmallIcon", new ResourceIcon("/com/sshtools/common/ui/delete.png"));
            this.putValue("ShortDescription", "Delete selection");
            this.putValue("LongDescription", "Delete the selection from the text");
            this.putValue("MnemonicKey", new Integer(100));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XTextField.this.setText("");
        }
    }

    class PasteAction
    extends AbstractAction {
        public PasteAction() {
            this.putValue("Name", "Paste");
            this.putValue("SmallIcon", new ResourceIcon("/com/sshtools/common/ui/paste.png"));
            this.putValue("ShortDescription", "Paste clipboard content");
            this.putValue("LongDescription", "Paste the clipboard contents to the current care position or replace the selection");
            this.putValue("MnemonicKey", new Integer(112));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    XTextField.this.setText(transferable.getTransferData(DataFlavor.stringFlavor).toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class CutAction
    extends AbstractAction {
        public CutAction() {
            this.putValue("Name", "Cut");
            this.putValue("SmallIcon", new ResourceIcon("/com/sshtools/common/ui/cut.png"));
            this.putValue("ShortDescription", "Cut selection");
            this.putValue("LongDescription", "Cut the selection from the text and place it in the clipboard");
            this.putValue("MnemonicKey", new Integer(117));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(XTextField.this.getText()), XTextField.this);
            XTextField.this.setText("");
        }
    }

    class CopyAction
    extends AbstractAction {
        public CopyAction() {
            this.putValue("Name", "Copy");
            this.putValue("SmallIcon", new ResourceIcon("/com/sshtools/common/ui/copy.png"));
            this.putValue("ShortDescription", "Copy");
            this.putValue("LongDescription", "Copy the selection from the text and place it in the clipboard");
            this.putValue("MnemonicKey", new Integer(99));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(XTextField.this.getText()), XTextField.this);
        }
    }
}

