/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.resources;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.resources.Resources;
import org.apache.commons.resources.ResourcesException;

public abstract class ResourcesBase
implements Resources {
    protected String name = "ResourcesBase";
    protected boolean returnNull = true;

    public void init() throws ResourcesException {
    }

    public void destroy() throws ResourcesException {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isReturnNull() {
        return this.returnNull;
    }

    public void setReturnNull(boolean returnNull) {
        this.returnNull = returnNull;
    }

    public String getString(String key, Locale locale, TimeZone timeZone) throws ResourcesException {
        return new String(this.getBytes(key, locale, timeZone));
    }

    public InputStream getInputStream(String key, Locale locale, TimeZone timeZone) throws ResourcesException {
        return new ByteArrayInputStream(this.getBytes(key, locale, timeZone));
    }

    public Reader getReader(String key, Locale locale, TimeZone timeZone) throws ResourcesException {
        return new StringReader(this.getString(key, locale, timeZone));
    }
}

