/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.resources.ConfigurationReader;
import org.apache.commons.resources.Resources;
import org.apache.commons.resources.ResourcesException;
import org.apache.commons.resources.XMLConfigurationReader;
import org.apache.commons.resources.message.MessageResources;
import org.apache.commons.resources.message.MessageResourcesFactory;

public class ResourcesManager
implements Serializable {
    protected Map resources;
    protected static MessageResources messageResources = MessageResourcesFactory.createFactory().createResources("org.apache.commons.resources.LocalStrings");

    public ResourcesManager(ConfigurationReader configReader) throws ResourcesException {
        this(configReader, false);
    }

    public ResourcesManager(ConfigurationReader configReader, boolean initialize) throws ResourcesException {
        this.resources = configReader.getResourcesMap();
        if (initialize) {
            this.initResources();
        }
    }

    public ResourcesManager(URL configURL) throws ResourcesException, IOException {
        this(configURL, false);
    }

    public ResourcesManager(URL configURL, boolean initialize) throws ResourcesException, IOException {
        this(configURL.openStream(), initialize);
    }

    public ResourcesManager(InputStream inputStream) throws ResourcesException {
        this(inputStream, false);
    }

    public ResourcesManager(InputStream inputStream, boolean initialize) throws ResourcesException {
        XMLConfigurationReader configReader = new XMLConfigurationReader();
        configReader.read(inputStream);
        this.resources = configReader.getResourcesMap();
        if (initialize) {
            this.initResources();
        }
    }

    public Resources getResources(String name) {
        return (Resources)this.resources.get(name);
    }

    public Collection getResourcesCollection() {
        return this.resources.values();
    }

    protected void initResources() throws ResourcesException {
        Collection resourceCollection = this.resources.values();
        Iterator iterator = resourceCollection.iterator();
        while (iterator.hasNext()) {
            Resources resource = (Resources)iterator.next();
            resource.init();
        }
    }
}

