/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.resources.AddResourceRule;
import org.apache.commons.resources.ConfigurationReader;
import org.apache.commons.resources.ResourcesException;
import org.apache.commons.resources.message.MessageResources;
import org.apache.commons.resources.message.MessageResourcesFactory;
import org.xml.sax.SAXException;

public class XMLConfigurationReader
implements ConfigurationReader {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$commons$resources$XMLConfigurationReader == null ? (class$org$apache$commons$resources$XMLConfigurationReader = XMLConfigurationReader.class$("org.apache.commons.resources.XMLConfigurationReader")) : class$org$apache$commons$resources$XMLConfigurationReader));
    protected static MessageResources messages = MessageResourcesFactory.createFactory().createResources("org.apache.commons.resources.LocalStrings");
    protected Map resources = new HashMap();
    static /* synthetic */ Class class$org$apache$commons$resources$XMLConfigurationReader;

    public Map getResourcesMap() {
        return this.resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(URL url) throws ResourcesException {
        if (url == null) {
            throw new IllegalArgumentException(messages.getMessage("resources.config.url"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading configuration from " + url.toExternalForm()));
        }
        InputStream stream = null;
        try {
            stream = url.openStream();
        }
        catch (IOException e) {
            throw new ResourcesException(messages.getMessage("resources.config.open", (Object)url.toExternalForm()), e);
        }
        try {
            this.read(stream);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable t) {}
                stream = null;
            }
        }
    }

    public void read(InputStream stream) throws ResourcesException {
        if (stream == null) {
            throw new IllegalArgumentException(messages.getMessage("resources.config.stream"));
        }
        this.resources = new HashMap();
        Digester digester = new Digester();
        digester.addRule("resources-config/resources/resource", (Rule)new AddResourceRule(this));
        digester.addSetProperty("resources-config/resources/resource/set-property", "property", "value");
        try {
            digester.parse(stream);
        }
        catch (IOException ioe) {
            throw new ResourcesException(messages.getMessage("resources.config.io"), ioe);
        }
        catch (SAXException sax) {
            throw new ResourcesException(messages.getMessage("resources.config.sax"), sax);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

